/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.items.guide;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.GuideBook;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.entry.EntryItemStack;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.PageText;
import amerifrance.guideapi.page.PageTextImage;
import com.corwinjv.mobtotems.blocks.ModBlocks;
import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.gui.util;
import com.corwinjv.mobtotems.items.ModItems;
import com.corwinjv.mobtotems.items.guide.PageOfferingBoxCost;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

@GuideBook
public class MobTotemsGuideBook
implements IGuideBook {
    public static Book myGuide;

    @Nonnull
    public Book buildBook() {
        LinkedHashMap<ResourceLocation, EntryItemStack> entries = new LinkedHashMap<ResourceLocation, EntryItemStack>();
        ArrayList<CategoryItemStack> categories = new ArrayList<CategoryItemStack>();
        ArrayList<Object> pages = new ArrayList<Object>();
        pages.add(new PageText(util.getLocalizedGuideText("totemic_focus_page_1")));
        pages.add(new PageIRecipe((IRecipe)new ShapedOreRecipe(null, ModItems.ITEMS.get("totemic_focus"), new Object[]{"GXF", " X ", " X ", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('G'), Items.field_151016_H, Character.valueOf('F'), Items.field_151008_G})));
        entries.put(new ResourceLocation("mobtotems", "totemic_focus"), new EntryItemStack(pages, util.getLocalizedGuideText("totemic_focus_entry_name"), new ItemStack(ModItems.ITEMS.get("totemic_focus"))));
        pages = new ArrayList();
        pages.add(new PageText(util.getLocalizedGuideText("carving_knife_page_1")));
        pages.add(new PageIRecipe((IRecipe)new ShapedOreRecipe(null, ModItems.ITEMS.get("carving_knife"), new Object[]{"   ", " F ", "S  ", Character.valueOf('F'), Items.field_151145_ak, Character.valueOf('S'), Items.field_151055_y})));
        entries.put(new ResourceLocation("mobtotems", "carving_knife"), new EntryItemStack(pages, util.getLocalizedGuideText("carving_knife_entry_name"), new ItemStack(ModItems.ITEMS.get("carving_knife"))));
        pages = new ArrayList();
        pages.add(new PageText(util.getLocalizedGuideText("offering_box_page_1")));
        pages.add(new PageText(util.getLocalizedGuideText("offering_box_page_2")));
        pages.add(new PageText(util.getLocalizedGuideText("offering_box_page_3")));
        pages.add(new PageTextImage(util.getLocalizedGuideText("offering_box_page_4"), util.getGuideResourceLocation("finished_totem_example_3.png"), false));
        pages.add(new PageTextImage(util.getLocalizedGuideText("offering_box_page_5"), util.getGuideResourceLocation("finished_totem_example_4.png"), false));
        entries.put(new ResourceLocation("mobtotems", "offering_box"), new EntryItemStack(pages, util.getLocalizedGuideText("offering_box_entry_name"), new ItemStack(ModBlocks.OFFERING_BOX)));
        pages = new ArrayList();
        pages.add(new PageText(util.getLocalizedGuideText("sacred_light_page_1")));
        pages.add(new PageIRecipe((IRecipe)new ShapedOreRecipe(null, ModBlocks.SACRED_LIGHT, new Object[]{"GRG", "XNX", "GTG", Character.valueOf('G'), Items.field_151016_H, Character.valueOf('R'), Items.field_151072_bj, Character.valueOf('X'), Items.field_151078_bh, Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('T'), ModBlocks.TOTEM_WOOD}).setRegistryName("sacred_light")));
        pages.add(new PageTextImage(util.getLocalizedGuideText("sacred_light_example"), util.getGuideResourceLocation("finished_totem_example.png"), false));
        entries.put(new ResourceLocation("mobtotems", "sacred_light"), new EntryItemStack(pages, util.getLocalizedGuideText("sacred_light_entry_name"), new ItemStack(ModBlocks.SACRED_LIGHT)));
        categories.add(new CategoryItemStack(entries, util.getLocalizedGuideText("totems_category_name"), new ItemStack(ModItems.ITEMS.get("totemic_focus"), 1, 0)));
        entries = new LinkedHashMap();
        for (int i = 1; i < TotemType.values().length; ++i) {
            pages = new ArrayList();
            pages.add(new PageText(util.getLocalizedGuideText("totem_types_page_" + i)));
            pages.add(new PageOfferingBoxCost(TotemType.fromMeta(i)));
            entries.put(new ResourceLocation("mobtotems", "totem_wood_totem_type=" + TotemType.fromMeta(i).func_176610_l()), new EntryItemStack(pages, util.getLocalizedGuideText("totem_type_page_name_" + i), new ItemStack(ModBlocks.TOTEM_WOOD, 1, i)));
        }
        categories.add(new CategoryItemStack(entries, util.getLocalizedGuideText("totem_types_category_name"), new ItemStack(ModBlocks.TOTEM_WOOD, 1, TotemType.CREEPER.getMeta())));
        entries = new LinkedHashMap();
        pages = new ArrayList();
        pages.add(new PageText(util.getLocalizedGuideText("wolf_bauble_page_1")));
        pages.add(new PageIRecipe((IRecipe)new ShapedOreRecipe(null, ModItems.ITEMS.get("wolf_totem_bauble"), new Object[]{"SSS", "CPC", " C ", Character.valueOf('C'), Blocks.field_150435_aG, Character.valueOf('P'), Items.field_151065_br, Character.valueOf('S'), Items.field_151007_F})));
        pages.add(new PageText(util.getLocalizedGuideText("wolf_bauble_page_2")));
        pages.add(new PageIRecipe((IRecipe)new ShapedOreRecipe(null, ModBlocks.INCENSE_KINDLING_BOX, new Object[]{"WWW", "WIW", "WFW", Character.valueOf('W'), Blocks.field_150344_f, Character.valueOf('I'), Blocks.field_150329_H, Character.valueOf('F'), Items.field_151145_ak})));
        pages.add(new PageText(util.getLocalizedGuideText("wolf_bauble_page_3")));
        entries.put(new ResourceLocation("mobtotems", "wolf_totem_bauble"), new EntryItemStack(pages, util.getLocalizedGuideText("wolf_bauble_entry_name"), new ItemStack(ModItems.ITEMS.get("wolf_totem_bauble"))));
        categories.add(new CategoryItemStack(entries, util.getLocalizedGuideText("baubles_category_name"), new ItemStack(ModItems.ITEMS.get("wolf_totem_bauble"))));
        myGuide = new Book();
        myGuide.setTitle("mobtotems.GuideBook.title");
        myGuide.setDisplayName(util.getLocalizedGuideText("name"));
        myGuide.setWelcomeMessage(util.getLocalizedGuideText("welcome"));
        myGuide.setAuthor("CorwinJV");
        myGuide.setColor(Color.DARK_GRAY);
        myGuide.setCategoryList(categories);
        myGuide.setRegistryName(new ResourceLocation("mobtotems", "mobtotems_guide"));
        return myGuide;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleModel(ItemStack bookStack) {
        GuideAPI.setModel((Book)myGuide);
    }

    public void handlePost(ItemStack bookStack) {
        GameRegistry.addShapelessRecipe((ResourceLocation)bookStack.func_77973_b().getRegistryName(), null, (ItemStack)bookStack, (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151122_aG), Ingredient.func_193367_a((Item)Items.field_151103_aS)});
    }
}

