/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.zone;

import buildcraft.api.core.IZone;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.robotics.zone.ZoneChunk;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Point2i;
import javax.vecmath.Tuple2i;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;

public class ZonePlan
implements IZone {
    private final HashMap<ChunkPos, ZoneChunk> chunkMapping = new HashMap();

    public ZonePlan() {
    }

    public ZonePlan(ZonePlan old) {
        for (ChunkPos chunkPos : old.chunkMapping.keySet()) {
            this.chunkMapping.put(chunkPos, new ZoneChunk(old.chunkMapping.get(chunkPos)));
        }
    }

    public boolean get(int x, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkPos chunkId = new ChunkPos(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            return false;
        }
        ZoneChunk property = this.chunkMapping.get(chunkId);
        return property.get(x & 0xF, z & 0xF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(int x, int z, boolean val) {
        ZoneChunk property;
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkPos chunkId = new ChunkPos(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            if (!val) return;
            property = new ZoneChunk();
            this.chunkMapping.put(chunkId, property);
        } else {
            property = this.chunkMapping.get(chunkId);
        }
        property.set(x & 0xF, z & 0xF, val);
        if (!property.isEmpty()) return;
        this.chunkMapping.remove(chunkId);
    }

    public List<Point2i> getAll() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int zChunk = 0; zChunk < 16; ++zChunk) {
            for (int xChunk = 0; xChunk < 16; ++xChunk) {
                if (!this.get(xChunk, zChunk)) continue;
                builder.add((Object)new Point2i(xChunk, zChunk));
            }
        }
        this.chunkMapping.forEach((chunkPos, zoneChunk) -> {
            List<Point2i> zoneChunkAll = zoneChunk.getAll();
            zoneChunkAll.forEach(p -> p.add((Tuple2i)new Point2i(chunkPos.func_180334_c(), chunkPos.func_180333_d())));
            builder.addAll(zoneChunkAll);
        });
        return builder.build();
    }

    public ZonePlan getWithOffset(int offsetX, int offsetY) {
        ZonePlan zonePlan = new ZonePlan();
        this.getAll().forEach(p -> zonePlan.set(p.x + offsetX, p.y + offsetY, true));
        return zonePlan;
    }

    public boolean hasChunk(ChunkPos chunkPos) {
        return this.chunkMapping.containsKey(chunkPos);
    }

    public Set<ChunkPos> getChunkPoses() {
        return this.chunkMapping.keySet();
    }

    public HashMap<ChunkPos, ZoneChunk> getChunkMapping() {
        return this.chunkMapping;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("chunkMapping", (NBTBase)NBTUtilBC.writeCompoundList(this.chunkMapping.entrySet().stream().map(entry -> {
            NBTTagCompound zoneChunkTag = new NBTTagCompound();
            ((ZoneChunk)entry.getValue()).writeToNBT(zoneChunkTag);
            zoneChunkTag.func_74768_a("chunkX", ((ChunkPos)entry.getKey()).field_77276_a);
            zoneChunkTag.func_74768_a("chunkZ", ((ChunkPos)entry.getKey()).field_77275_b);
            return zoneChunkTag;
        })));
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtilBC.readCompoundList(nbt.func_74781_a("chunkMapping")).forEach(zoneChunkTag -> {
            ZoneChunk chunk = new ZoneChunk();
            chunk.readFromNBT((NBTTagCompound)zoneChunkTag);
            this.chunkMapping.put(new ChunkPos(zoneChunkTag.func_74762_e("chunkX"), zoneChunkTag.func_74762_e("chunkZ")), chunk);
        });
    }

    @Override
    public double distanceTo(BlockPos index) {
        return Math.sqrt(this.distanceToSquared(index));
    }

    @Override
    public double distanceToSquared(BlockPos index) {
        double maxSqrDistance = Double.MAX_VALUE;
        for (Map.Entry<ChunkPos, ZoneChunk> e : this.chunkMapping.entrySet()) {
            double dz;
            double dx = (e.getKey().field_77276_a << 12) - index.func_177958_n();
            double sqrDistance = dx * dx + (dz = (double)((e.getKey().field_77275_b << 12) - index.func_177952_p())) * dz;
            if (!(sqrDistance < maxSqrDistance)) continue;
            maxSqrDistance = sqrDistance;
        }
        return maxSqrDistance;
    }

    @Override
    public boolean contains(Vec3d point) {
        int xBlock = (int)Math.floor(point.field_72450_a);
        int zBlock = (int)Math.floor(point.field_72449_c);
        return this.get(xBlock, zBlock);
    }

    @Override
    public BlockPos getRandomBlockPos(Random rand) {
        if (this.chunkMapping.size() == 0) {
            return null;
        }
        int chunkId = rand.nextInt(this.chunkMapping.size());
        for (Map.Entry<ChunkPos, ZoneChunk> e : this.chunkMapping.entrySet()) {
            if (chunkId == 0) {
                BlockPos i = e.getValue().getRandomBlockPos(rand);
                int x = (e.getKey().field_77276_a << 4) + i.func_177958_n();
                int z = (e.getKey().field_77275_b << 4) + i.func_177952_p();
                return new BlockPos(x, i.func_177956_o(), z);
            }
            --chunkId;
        }
        return null;
    }

    public ZonePlan readFromByteBuf(PacketBuffer buf) {
        this.chunkMapping.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ChunkPos key = new ChunkPos(buf.readInt(), buf.readInt());
            ZoneChunk value = new ZoneChunk();
            value.readFromByteBuf(buf);
            this.chunkMapping.put(key, value);
        }
        return this;
    }

    public void writeToByteBuf(PacketBuffer buf) {
        buf.writeInt(this.chunkMapping.size());
        for (Map.Entry<ChunkPos, ZoneChunk> e : this.chunkMapping.entrySet()) {
            buf.writeInt(e.getKey().field_77276_a);
            buf.writeInt(e.getKey().field_77275_b);
            e.getValue().writeToByteBuf(buf);
        }
    }
}

