/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.items.IList;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackMatchingPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtil {
    @Nonnull
    public static final ItemStack EMPTY;
    private static final Map<Item, List<StackMatchingPredicate>> matchingPredicates;

    public static boolean canMerge(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (!ItemStack.func_179545_c((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    @Nonnull
    public static ItemStack getItemStackForState(IBlockState state) {
        Block b = state.func_177230_c();
        ItemStack stack = new ItemStack(b);
        if (stack.func_190926_b()) {
            return EMPTY;
        }
        if (stack.func_77981_g()) {
            stack = new ItemStack(stack.func_77973_b(), 1, b.func_176201_c(state));
        }
        return stack;
    }

    public static boolean contains(@Nonnull ItemStack required, @Nonnull ItemStack container) {
        if (StackUtil.canMerge(required, container)) {
            return container.func_190916_E() >= required.func_190916_E();
        }
        return false;
    }

    public static boolean contains(@Nonnull ItemStack required, Collection<ItemStack> containers) {
        for (ItemStack possible : containers) {
            if (possible == null) {
                throw new NullPointerException("Found a null itemstack in " + containers);
            }
            if (!StackUtil.contains(required, possible)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nonnull StackDefinition stackDefinition, @Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stackDefinition.filter.matches(stack) && stack.func_190916_E() >= stackDefinition.count;
    }

    public static boolean contains(@Nonnull StackDefinition stackDefinition, @Nonnull NonNullList<ItemStack> stacks) {
        return stacks.stream().anyMatch(stack -> StackUtil.contains(stackDefinition, stack));
    }

    public static boolean contains(@Nonnull IngredientStack ingredientStack, @Nonnull ItemStack stack) {
        return !stack.func_190926_b() && ingredientStack.ingredient.apply(stack) && stack.func_190916_E() >= ingredientStack.count;
    }

    public static boolean contains(@Nonnull IngredientStack ingredientStack, @Nonnull NonNullList<ItemStack> stacks) {
        return stacks.stream().anyMatch(stack -> StackUtil.contains(ingredientStack, stack));
    }

    public static boolean containsAll(Collection<ItemStack> required, Collection<ItemStack> containers) {
        for (ItemStack req : required) {
            if (req == null) {
                throw new NullPointerException("Found a null itemstack in " + containers);
            }
            if (req.func_190926_b() || StackUtil.contains(req, containers)) continue;
            return false;
        }
        return true;
    }

    public static NBTTagCompound stripNonFunctionNbt(@Nonnull ItemStack from) {
        NBTTagCompound nbt = NBTUtilBC.getItemData(from).func_74737_b();
        if (nbt.func_186856_d() == 0) {
            return nbt;
        }
        nbt.func_82580_o("_data");
        return nbt;
    }

    public static boolean doesStackNbtMatch(@Nonnull ItemStack target, @Nonnull ItemStack with) {
        NBTTagCompound nbtTarget = StackUtil.stripNonFunctionNbt(target);
        NBTTagCompound nbtWith = StackUtil.stripNonFunctionNbt(with);
        return nbtTarget.equals((Object)nbtWith);
    }

    public static boolean doesEitherStackMatch(@Nonnull ItemStack stackA, @Nonnull ItemStack stackB) {
        return OreDictionary.itemMatches((ItemStack)stackA, (ItemStack)stackB, (boolean)false) || OreDictionary.itemMatches((ItemStack)stackB, (ItemStack)stackA, (boolean)false);
    }

    public static boolean canStacksOrListsMerge(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (stack1.func_77973_b() instanceof IList) {
            IList list = (IList)stack1.func_77973_b();
            return list.matches(stack1, stack2);
        }
        if (stack2.func_77973_b() instanceof IList) {
            IList list = (IList)stack2.func_77973_b();
            return list.matches(stack2, stack1);
        }
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean matchesStackOrList(@Nonnull ItemStack filterOrList, @Nonnull ItemStack test) {
        if (filterOrList.func_190926_b() || test.func_190926_b()) {
            return false;
        }
        if (filterOrList.func_77973_b() instanceof IList) {
            IList list = (IList)filterOrList.func_77973_b();
            return list.matches(filterOrList, test);
        }
        return StackUtil.canMerge(filterOrList, test);
    }

    public static int mergeStacks(@Nonnull ItemStack mergeSource, @Nonnull ItemStack mergeTarget, boolean doMerge) {
        if (!StackUtil.canMerge(mergeSource, mergeTarget)) {
            return 0;
        }
        int mergeCount = Math.min(mergeTarget.func_77976_d() - mergeTarget.func_190916_E(), mergeSource.func_190916_E());
        if (mergeCount < 1) {
            return 0;
        }
        if (doMerge) {
            mergeTarget.func_190920_e(mergeTarget.func_190916_E() + mergeCount);
        }
        return mergeCount;
    }

    public static boolean isCraftingEquivalent(@Nonnull ItemStack base, @Nonnull ItemStack comparison, boolean oreDictionary) {
        int[] idBase;
        if (StackUtil.isMatchingItem(base, comparison, true, false)) {
            return true;
        }
        if (oreDictionary && (idBase = OreDictionary.getOreIDs((ItemStack)base)).length > 0) {
            for (int id : idBase) {
                for (ItemStack itemstack : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (comparison.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77952_i() != Short.MAX_VALUE && comparison.func_77952_i() != itemstack.func_77952_i()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCraftingEquivalent(int[] oreIDs, ItemStack comparison) {
        if (oreIDs.length > 0) {
            for (int id : oreIDs) {
                for (ItemStack itemstack : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (comparison.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77952_i() != Short.MAX_VALUE && comparison.func_77952_i() != itemstack.func_77952_i()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMatchingItemOrList(ItemStack base, ItemStack comparison) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (base.func_77973_b() instanceof IList) {
            IList list = (IList)base.func_77973_b();
            return list.matches(base, comparison);
        }
        if (comparison.func_77973_b() instanceof IList) {
            IList list = (IList)comparison.func_77973_b();
            return list.matches(comparison, base);
        }
        return StackUtil.isMatchingItem(base, comparison, true, false);
    }

    public static boolean isMatchingItem(@Nonnull ItemStack base, @Nonnull ItemStack comparison) {
        return StackUtil.isMatchingItem(base, comparison, true, true);
    }

    public static boolean isEqualItem(@Nonnull ItemStack base, @Nonnull ItemStack comparison) {
        if (StackUtil.isMatchingItem(base, comparison, false, true)) {
            return StackUtil.isWildcard(base) || StackUtil.isWildcard(comparison) || base.func_77952_i() == comparison.func_77952_i();
        }
        return false;
    }

    public static boolean isMatchingItem(@Nonnull ItemStack base, @Nonnull ItemStack comparison, boolean matchDamage, boolean matchNBT) {
        if (base.func_190926_b() || comparison.func_190926_b()) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (matchDamage && base.func_77981_g() && !StackUtil.isWildcard(base) && !StackUtil.isWildcard(comparison) && base.func_77952_i() != comparison.func_77952_i()) {
            return false;
        }
        if (matchNBT) {
            NBTTagCompound baseTag = base.func_77978_p();
            if (baseTag != null && !baseTag.equals((Object)comparison.func_77978_p())) {
                return false;
            }
        } else {
            List predicates = matchingPredicates.getOrDefault(base.func_77973_b(), Collections.emptyList());
            for (StackMatchingPredicate predicate : predicates) {
                if (predicate.isMatching(base, comparison)) continue;
                return false;
            }
        }
        return true;
    }

    public static void registerMatchingPredicate(@Nonnull Item forItem, @Nonnull StackMatchingPredicate predicate) {
        List predicates = matchingPredicates.computeIfAbsent(forItem, item -> new ArrayList());
        predicates.add(predicate);
    }

    public static boolean isWildcard(@Nonnull ItemStack stack) {
        return StackUtil.isWildcard(stack.func_77952_i());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static NonNullList<ItemStack> listOf() {
        return NonNullList.func_191197_a((int)0, (Object)EMPTY);
    }

    public static NonNullList<ItemStack> listOf(ItemStack ... stacks) {
        switch (stacks.length) {
            case 0: {
                return StackUtil.listOf();
            }
            case 1: {
                return NonNullList.func_191197_a((int)1, (Object)stacks[0]);
            }
        }
        NonNullList list = NonNullList.func_191197_a((int)stacks.length, (Object)EMPTY);
        for (int i = 0; i < stacks.length; ++i) {
            list.set(i, (Object)stacks[i]);
        }
        return list;
    }

    @Nonnull
    public static <T> T asNonNull(@Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException("Object was null!");
        }
        return obj;
    }

    @Nonnull
    public static <T> T asNonNullSoft(@Nullable T obj, @Nonnull T fallback) {
        if (obj == null) {
            return fallback;
        }
        return obj;
    }

    @Nonnull
    public static ItemStack asNonNullSoft(@Nullable ItemStack stack) {
        return StackUtil.asNonNullSoft(stack, EMPTY);
    }

    public static <E> Collector<E, ?, NonNullList<E>> nonNullListCollector() {
        return Collectors.toCollection(NonNullList::func_191196_a);
    }

    public static int hash(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (!stack.func_77942_o()) {
            return Objects.hash(stack.func_77973_b(), stack.func_77960_j());
        }
        return stack.serializeNBT().hashCode();
    }

    public static NonNullList<ItemStack> mergeSameItems(List<ItemStack> items) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ItemStack toAdd : items) {
            boolean found = false;
            for (ItemStack stack : stacks) {
                if (!StackUtil.canMerge(stack, toAdd)) continue;
                stack.func_190917_f(toAdd.func_190916_E());
                found = true;
            }
            if (found) continue;
            stacks.add((Object)toAdd.func_77946_l());
        }
        return stacks;
    }

    static {
        matchingPredicates = new HashMap<Item, List<StackMatchingPredicate>>();
        ItemStack stack = ItemStack.field_190927_a;
        if (stack == null) {
            throw new NullPointerException("Empty ItemStack was null!");
        }
        EMPTY = stack;
    }
}

