/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

public class MathUtil {
    private static final short HCF_SIZE = 64;
    private static final short[][] HCF_TABLE;

    private static short findHcfDirect(short a, short b) {
        while (b > 0) {
            short t = b;
            b = (short)(a % b);
            a = t;
        }
        return a;
    }

    public static double interp(double interp, double from, double to) {
        return from * (1.0 - interp) + to * interp;
    }

    public static int clamp(int toClamp, int min, int max) {
        return Math.max(Math.min(toClamp, max), min);
    }

    public static int clamp(double toClamp, int min, int max) {
        return MathUtil.clamp((int)toClamp, min, max);
    }

    public static double clamp(double toClamp, double min, double max) {
        return Math.max(Math.min(toClamp, max), min);
    }

    public static long clamp(long toClamp, long min, long max) {
        return Math.max(Math.min(toClamp, max), min);
    }

    public static int findHighestCommonFactor(int a, int b) {
        int t;
        if (b > a) {
            t = b;
            b = a;
            a = t;
        }
        if (a < 64) {
            return HCF_TABLE[a][b];
        }
        while (b > 0) {
            t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    public static int findLowestCommonMultiple(int a, int b) {
        return a / MathUtil.findHighestCommonFactor(a, b) * b;
    }

    static {
        short a;
        HCF_TABLE = new short[64][64];
        for (a = 0; a < 64; a = (short)((short)(a + 1))) {
            MathUtil.HCF_TABLE[a][0] = a;
        }
        for (a = 0; a < 64; a = (short)((short)(a + 1))) {
            for (short b = 1; b <= a; b = (short)(b + 1)) {
                MathUtil.HCF_TABLE[a][b] = MathUtil.findHcfDirect(a, b);
            }
        }
    }
}

