/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.contents.ContentsNode;
import buildcraft.lib.client.guide.parts.contents.IContentsNode;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.misc.ArrayUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ContentsNodeGui {
    public final GuiGuide gui;
    public final ContentsNode node;
    private IFontRenderer fontRenderer;
    private List<GuideChapter> chapters;
    private GuidePart[] parts;
    private PageLink[] links;

    public ContentsNodeGui(GuiGuide gui, ContentsNode node) {
        this.gui = gui;
        this.node = node;
    }

    public List<GuideChapter> getChapters() {
        if (this.populate() || this.chapters == null) {
            this.chapters = new ArrayList<GuideChapter>();
            for (GuidePart part : this.parts) {
                if (!(part instanceof GuideChapter)) continue;
                this.chapters.add((GuideChapter)part);
            }
        }
        return this.chapters;
    }

    public void setFontRenderer(IFontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        if (this.parts != null) {
            for (GuidePart part : this.parts) {
                part.setFontRenderer(fontRenderer);
            }
        }
    }

    public void invalidate() {
        this.parts = null;
        this.links = null;
        this.chapters = null;
    }

    private boolean populate() {
        if (this.parts == null) {
            ArrayList<GuidePart> allText = new ArrayList<GuidePart>();
            ArrayList<PageLink> allLinks = new ArrayList<PageLink>();
            ArrayDeque queue = new ArrayDeque();
            ArrayUtil.addAllReversed(queue, this.node.getVisibleChildren());
            while (!queue.isEmpty()) {
                IContentsNode next = (IContentsNode)queue.removeLast();
                GuidePart part = next.createGuidePart(this.gui);
                if (this.fontRenderer != null) {
                    part.setFontRenderer(this.fontRenderer);
                }
                allText.add(part);
                if (next instanceof PageLink) {
                    allLinks.add((PageLink)next);
                } else {
                    allLinks.add(null);
                }
                ArrayUtil.addAllReversed(queue, next.getVisibleChildren());
            }
            this.parts = allText.toArray(new GuidePart[0]);
            this.links = allLinks.toArray(new PageLink[0]);
            return true;
        }
        return false;
    }

    public GuidePart.PagePosition render(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        return this.iterate(current, height, (pos, part, link) -> part.renderIntoArea(x, y, width, height, pos, index));
    }

    public void onClicked(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        this.iterate(current, height, (pos, part, link) -> {
            GuidePageFactory factory;
            GuidePageBase page;
            pos = part.renderIntoArea(x, y, width, height, pos, -1);
            if (pos.page == index && part.wasHovered() && link != null && (page = (factory = link.getFactoryLink()).createNew(this.gui)) != null) {
                this.gui.openPage(page);
                return null;
            }
            return pos;
        });
    }

    @Nullable
    private GuidePart.PagePosition iterate(GuidePart.PagePosition pos, int height, IGuideBitIter iter) {
        this.populate();
        for (int i = 0; i < this.links.length; ++i) {
            GuidePart part = this.parts[i];
            PageLink link = this.links[i];
            int space = 16;
            if (link == null) {
                for (int j = i; j < this.links.length; ++j) {
                    if (this.links[j] == null) continue;
                    pos = pos.guaranteeSpace(space * (1 + j - i), height);
                    break;
                }
            }
            if ((pos = iter.iterate(pos, part, link)) != null) continue;
            return null;
        }
        return pos;
    }

    @FunctionalInterface
    private static interface IGuideBitIter {
        @Nullable
        public GuidePart.PagePosition iterate(GuidePart.PagePosition var1, GuidePart var2, PageLink var3);
    }
}

