/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.font;

import buildcraft.lib.client.guide.font.GuideFont;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.font.MinecraftFont;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public enum FontManager {
    INSTANCE;

    private static final boolean ENABLE_SMOOTH_FONT;
    private final Map<String, IFontRenderer> fonts = new HashMap<String, IFontRenderer>();

    public IFontRenderer getOrLoadFont(String name, int size) {
        if (ENABLE_SMOOTH_FONT) {
            return new GuideFont(new Font(name, 0, size));
        }
        return MinecraftFont.INSTANCE;
    }

    public void registerFont(String name, IFontRenderer font) {
        if (font == null) {
            throw new NullPointerException("font");
        }
        if (this.fonts.containsKey(name)) {
            throw new IllegalStateException("Cannot register the font \"" + name + "\" twice!");
        }
        this.fonts.put(name, font);
    }

    static {
        ENABLE_SMOOTH_FONT = Boolean.getBoolean("buildcraft.guide.smooth_font");
    }
}

