/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.statements;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionInternalSided;
import buildcraft.api.statements.IActionProvider;
import buildcraft.api.statements.IOverrideDefaultStatements;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementParameterItemStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public final class StatementManager {
    public static Map<String, IStatement> statements = new HashMap<String, IStatement>();
    public static Map<String, IParameterReader> parameters = new HashMap<String, IParameterReader>();
    public static Map<String, IParamReaderBuf> paramsBuf = new HashMap<String, IParamReaderBuf>();
    private static List<ITriggerProvider> triggerProviders = new LinkedList<ITriggerProvider>();
    private static List<IActionProvider> actionProviders = new LinkedList<IActionProvider>();

    private StatementManager() {
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static void registerStatement(IStatement statement) {
        statements.put(statement.getUniqueTag(), statement);
    }

    public static void registerParameter(IParameterReader reader) {
        StatementManager.registerParameter(reader, (PacketBuffer buf) -> reader.readFromNbt(buf.func_150793_b()));
    }

    public static void registerParameter(IParameterReader reader, IParamReaderBuf bufReader) {
        String name = reader.readFromNbt(new NBTTagCompound()).getUniqueTag();
        StatementManager.registerParameter(name, reader);
        StatementManager.registerParameter(name, bufReader);
    }

    public static void registerParameter(String name, IParameterReader reader) {
        parameters.put(name, reader);
    }

    public static void registerParameter(String name, IParamReaderBuf reader) {
        paramsBuf.put(name, reader);
    }

    public static List<ITriggerExternal> getExternalTriggers(EnumFacing side, TileEntity entity) {
        List<ITriggerExternal> result;
        if (entity instanceof IOverrideDefaultStatements && (result = ((IOverrideDefaultStatements)entity).overrideTriggers()) != null) {
            return result;
        }
        LinkedHashSet<ITriggerExternal> triggers = new LinkedHashSet<ITriggerExternal>();
        for (ITriggerProvider provider : triggerProviders) {
            provider.addExternalTriggers(triggers, side, entity);
        }
        return new ArrayList<ITriggerExternal>(triggers);
    }

    public static List<IActionExternal> getExternalActions(EnumFacing side, TileEntity entity) {
        List<IActionExternal> result;
        if (entity instanceof IOverrideDefaultStatements && (result = ((IOverrideDefaultStatements)entity).overrideActions()) != null) {
            return result;
        }
        LinkedHashSet<IActionExternal> actions = new LinkedHashSet<IActionExternal>();
        for (IActionProvider provider : actionProviders) {
            provider.addExternalActions(actions, side, entity);
        }
        return new ArrayList<IActionExternal>(actions);
    }

    public static List<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        LinkedHashSet<ITriggerInternal> triggers = new LinkedHashSet<ITriggerInternal>();
        for (ITriggerProvider provider : triggerProviders) {
            provider.addInternalTriggers(triggers, container);
        }
        return new ArrayList<ITriggerInternal>(triggers);
    }

    public static List<IActionInternal> getInternalActions(IStatementContainer container) {
        LinkedHashSet<IActionInternal> actions = new LinkedHashSet<IActionInternal>();
        for (IActionProvider provider : actionProviders) {
            provider.addInternalActions(actions, container);
        }
        return new ArrayList<IActionInternal>(actions);
    }

    public static List<ITriggerInternalSided> getInternalSidedTriggers(IStatementContainer container, EnumFacing side) {
        LinkedHashSet<ITriggerInternalSided> triggers = new LinkedHashSet<ITriggerInternalSided>();
        for (ITriggerProvider provider : triggerProviders) {
            provider.addInternalSidedTriggers(triggers, container, side);
        }
        return new ArrayList<ITriggerInternalSided>(triggers);
    }

    public static List<IActionInternalSided> getInternalSidedActions(IStatementContainer container, EnumFacing side) {
        LinkedHashSet<IActionInternalSided> actions = new LinkedHashSet<IActionInternalSided>();
        for (IActionProvider provider : actionProviders) {
            provider.addInternalSidedActions(actions, container, side);
        }
        return new ArrayList<IActionInternalSided>(actions);
    }

    public static IParameterReader getParameterReader(String kind) {
        return parameters.get(kind);
    }

    static {
        StatementManager.registerParameter(StatementParameterItemStack::new);
    }

    @FunctionalInterface
    public static interface IParamReaderBuf {
        public IStatementParameter readFromBuf(PacketBuffer var1) throws IOException;
    }

    @FunctionalInterface
    public static interface IParameterReader {
        public IStatementParameter readFromNbt(NBTTagCompound var1);
    }
}

