/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MjCapabilityHelper
implements ICapabilityProvider {
    @Nonnull
    private final IMjConnector connector;
    @Nullable
    private final IMjReceiver receiver;
    @Nullable
    private final IMjRedstoneReceiver rsReceiver;
    @Nullable
    private final IMjReadable readable;
    @Nullable
    private final IMjPassiveProvider provider;

    public MjCapabilityHelper(@Nonnull IMjConnector mj) {
        this.connector = mj;
        this.receiver = mj instanceof IMjReceiver ? (IMjReceiver)mj : null;
        this.rsReceiver = mj instanceof IMjRedstoneReceiver ? (IMjRedstoneReceiver)mj : null;
        this.readable = mj instanceof IMjReadable ? (IMjReadable)mj : null;
        this.provider = mj instanceof IMjPassiveProvider ? (IMjPassiveProvider)mj : null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == MjAPI.CAP_CONNECTOR) {
            return (T)MjAPI.CAP_CONNECTOR.cast((Object)this.connector);
        }
        if (capability == MjAPI.CAP_RECEIVER) {
            return (T)MjAPI.CAP_RECEIVER.cast((Object)this.receiver);
        }
        if (capability == MjAPI.CAP_REDSTONE_RECEIVER) {
            return (T)MjAPI.CAP_REDSTONE_RECEIVER.cast((Object)this.rsReceiver);
        }
        if (capability == MjAPI.CAP_READABLE) {
            return (T)MjAPI.CAP_READABLE.cast((Object)this.readable);
        }
        if (capability == MjAPI.CAP_PASSIVE_PROVIDER) {
            return (T)MjAPI.CAP_PASSIVE_PROVIDER.cast((Object)this.provider);
        }
        return null;
    }
}

