/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common.nbt;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import pl.asie.foamfix.common.nbt.FoamNBTTagCompound;

public class FoamNBTTagCompoundMap
implements Map<String, NBTBase> {
    private final FoamNBTTagCompound delegate;

    FoamNBTTagCompoundMap(FoamNBTTagCompound delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.ffGetTag((String)key) == null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NBTBase get(Object key) {
        return this.delegate.ffGetTag((String)key);
    }

    @Override
    public NBTBase put(String key, NBTBase value) {
        return this.delegate.ffPutTag(key, value);
    }

    @Override
    public NBTBase remove(Object key) {
        return this.delegate.ffRemove((String)key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends NBTBase> map) {
        for (Map.Entry<? extends String, ? extends NBTBase> entry : map.entrySet()) {
        }
    }

    @Override
    public void clear() {
        this.delegate.ffClear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.delegate.data.length);
        for (int i = 0; i < this.delegate.data.length; i += 2) {
            Object key = this.delegate.data[i];
            if (key == null) continue;
            keys.add((String)key);
        }
        return keys;
    }

    @Override
    public Collection<NBTBase> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, NBTBase>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.delegate.data.length; i += 2) {
            Object key = this.delegate.data[i];
            if (key == null) continue;
            Object value = this.delegate.data[i + 1];
            if (Objects.equals(other.get(key), value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.delegate.data.length; i += 2) {
            Object key = this.delegate.data[i];
            if (key == null) continue;
            Object value = this.delegate.data[i + 1];
            hash += key.hashCode() + (value != null ? value.hashCode() : 0);
        }
        return hash;
    }
}

