/*
 * Decompiled with CFR 0.152.
 */
package com.matt_r__.ConfigChecker;

import com.matt_r__.ConfigChecker.Main;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import util.Config;

@net.minecraftforge.common.config.Config(modid="concheckrmd")
public class ModConfig {
    @Config.Name(value="Customisable Chat Greeting Message")
    @Config.Comment(value={"A customisable message that will appear in chat when a world is loaded. This is useful for displaying credits."})
    public static final CustomGreetingMessage customg = new CustomGreetingMessage();
    @Config.RequiresMcRestart
    @Config.Name(value="Customisable Start Message")
    @Config.Comment(value={"Customisable message that will appear each time the game starts. This is useful for displaying credits."})
    public static final CustomMessageBox custommb = new CustomMessageBox();
    @Config.RequiresMcRestart
    @Config.Name(value="Customisable First Start Message")
    @Config.Comment(value={"A customisable message that will only appear when the game is started for the first time. This is useful for displaying intructions."})
    public static final FirstLaunchMessageBox customfirststartmb = new FirstLaunchMessageBox();
    @Config.RequiresMcRestart
    @Config.Name(value="Open A Website when the Game Starts")
    @Config.Comment(value={"The browser will open a webpage when the game starts. This is useful for providing support and displaying credits."})
    public static final DisplayWebpage webpage = new DisplayWebpage();
    @Config.RequiresMcRestart
    @Config.Name(value="Amount of RAM Recommended for Game to Start")
    @Config.Comment(value={"Set a recommended amount of RAM that is recommended for the modpack to run. If this recommendation is not met then a warning will be displayed when the game is started."})
    public static final RamRecommendationLaunch ramlaunch = new RamRecommendationLaunch();
    @Config.Name(value="Recommended RAM Chat Message")
    @Config.Comment(value={"Set a recommended amount of RAM that is recommended for the modpack to run. If this recommendation is not met then a warning will be displayed in chat when a world is loaded."})
    public static final RamRecommendationChat ramgame = new RamRecommendationChat();
    @Config.RequiresMcRestart
    @Config.Name(value="Amount of RAM Required for Game to Start")
    @Config.Comment(value={"Set a required amount of RAM that is required for the modpack to run. If this requirement is not met then an error will be displayed when the game is started and the game will close."})
    public static final RamRequired reqram = new RamRequired();
    @Config.RequiresMcRestart
    @Config.Name(value="game launch time limit")
    @Config.Comment(value={"Set the maximum time the game can spend booting. If the game exceeds this time limit then then an error will be displayed when the game is started and the game will close."})
    public static final GameLaunchTimeout launchtimeout = new GameLaunchTimeout();
    @Config.RequiresMcRestart
    @Config.Name(value="File Validation")
    @Config.Comment(value={"Run checks on configuration files to ensure they are up to date and have not been modified. If files are not valid then then a warning will be displayed when the game is started."})
    public static final FileChecking filechecking = new FileChecking();
    @Config.Comment(value={"Used by the mod to check compatiblity. DO NOT CHANGE ME."})
    @Config.Name(value="CONFIG VERSION")
    @Config.RangeInt(min=0, max=20)
    public static Integer zversion = 3;

    public static void updatemanually() {
        ConfigManager.sync((String)"concheckrmd", (Config.Type)Config.Type.INSTANCE);
        Main.LoadConfig();
    }

    @Mod.EventBusSubscriber(modid="concheckrmd")
    private static class Handler {
        private Handler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (!Config.lockconfig) {
                if (event.getModID().equals("concheckrmd")) {
                    ConfigManager.sync((String)"concheckrmd", (Config.Type)Config.Type.INSTANCE);
                    Main.LoadConfig();
                }
            } else {
                JFrame jf = new JFrame();
                jf.setAlwaysOnTop(true);
                JOptionPane.showMessageDialog(jf, "The modpack creator has disabled editing of this config file.");
            }
        }
    }

    public static class RamRequired {
        @Config.Comment(value={"The amount of RAM required for the game to run."})
        @Config.Name(value="1) Ram Required (IN MB)")
        @Config.RangeInt(min=128, max=51200)
        public Integer requiredraminmb = 1024;
        @Config.Comment(value={"If the player has less than the required amount of RAM assigned to the modpack then they will be alerted as the game starts and the game will close."})
        @Config.Name(value="2) Check RAM meets requirement?")
        public boolean checkrequiredram = false;
        @Config.Comment(value={"Will the window show on top of all other windows? I highly recommend this is left as true."})
        @Config.Name(value="3) Display message box topmost?")
        public boolean ramreqmessageboxtopmost = true;
        @Config.Comment(value={"Customise the text that appears in the error message. Will display custom message instead of the default text."})
        @Config.Name(value="4) Display custom text in messagebox?")
        public boolean customrequiredtext = false;
        @Config.Comment(value={"The custom message to be displayed in chat if you have set the previous setting to 'True'. Will display custom message instead of the default text."})
        @Config.Name(value="5) Custom Chat Message")
        public String requiredramcustomtext = "You need more RAM. The game will close.";
    }

    public static class RamRecommendationChat {
        @Config.Comment(value={"The amount of RAM recommended for stable gameplay."})
        @Config.Name(value="1) Ram Recommended (IN MB)")
        @Config.RangeInt(min=128, max=51200)
        public Integer chatrecommendedraminmb = 2048;
        @Config.Comment(value={"If the player has less than the recommended amount of RAM assigned to the modpack then a warning will be displayed in chat when a world is loaded."})
        @Config.Name(value="2) Check RAM meets recommendation?")
        public boolean chatcheckrecommendedram = true;
        @Config.Comment(value={"Customise the text that appears in the warning message. Will display custom message instead of the default text."})
        @Config.Name(value="3) Customise low RAM Warning?")
        public boolean chatcustomrecommendedtext = false;
        @Config.Comment(value={"The custom message to be displayed in chat if you have set the previous setting to 'True'. Will display custom message instead of the default text."})
        @Config.Name(value="4) Custom Message")
        public String chatramcustomtext = "[WARNING] You may expierence bad performance due to a shortage of RAM.";
    }

    public static class RamRecommendationLaunch {
        @Config.Comment(value={"The amount of RAM recommended for stable gameplay."})
        @Config.Name(value="1) Ram Recommended (IN MB)")
        @Config.RangeInt(min=128, max=51200)
        public Integer launchrecommendedraminmb = 2048;
        @Config.Comment(value={"If the player has less than the recommended amount of RAM assigned to the modpack then a warning will be displayed when the game is started."})
        @Config.Name(value="2) Check RAM meets recommendation?")
        public boolean launchcheckrecommendedram = true;
        @Config.Comment(value={"Will the window show on top of all other windows? I highly recommend this is left as true."})
        @Config.Name(value="3) Display message box topmost?")
        public boolean launchdisplayrammessageboxtopmost = true;
        @Config.Comment(value={"Customise the text that appears in the warning message. Will display custom message instead of the default text."})
        @Config.Name(value="4) Customise low RAM Warning?")
        public boolean launchcustomrecommendedtext = false;
        @Config.Comment(value={"The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text."})
        @Config.Name(value="5) Custom Message")
        public String messageboxtext = "You should add more RAM to expierence better performance.";
    }

    public static class GameLaunchTimeout {
        @Config.Comment(value={"The maximum amount of time the game will be allowed to spend booting."})
        @Config.Name(value="1) Launch Timeout (IN SECONDS)")
        @Config.RangeInt(min=5, max=5400)
        public Integer launchtimeoutinseconds = 30;
        @Config.Comment(value={"If the game exceeds the launch timeout then a messagebox will be displayed and the game will close."})
        @Config.Name(value="2) Check game meets launch timeout?")
        public boolean checklaunchtimeout = false;
        @Config.Comment(value={"Will the window show on top of all other windows? I highly recommend this is left as true."})
        @Config.Name(value="3) Display message box topmost?")
        public boolean launchtimeoutmessageboxtopmost = true;
        @Config.Comment(value={"Customise the text that appears in the error message. Will display custom message instead of the default text."})
        @Config.Name(value="4) Display custom text in error message?")
        public boolean displaycustomlaunchtimeoutmessagebox = false;
        @Config.Comment(value={"The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text."})
        @Config.Name(value="5) Custom Message")
        public String customlaunchtimeoutmessageboxtext = "The game has taken too long too start to start this modpack. This is probably due to insufficient system resources. The game will now close.";
    }

    public static class DisplayWebpage {
        @Config.Comment(value={"A webpage will be displayed when the game starts. This is useful for modpack support."})
        @Config.Name(value="1) Display Website when game starts?")
        public boolean displaywebsite = false;
        @Config.Comment(value={"The URL of the website that will be displayed. This can be formatted like: http://google.com, www.google.com or google.com."})
        @Config.Name(value="2) Website URL")
        public String websiteurl = "minecraft.curseforge.com/projects/config-checker";
    }

    public static class FirstLaunchMessageBox {
        @Config.Comment(value={"A message box that will be displayed when the game is started for the first time. This is useful for displaying intructions."})
        @Config.Name(value="1) Display message box?")
        public boolean displaymessagebox = false;
        @Config.Comment(value={"Will the window show on top of all other windows? Recommended to keep set to True."})
        @Config.Name(value="2) Display message box topmost?")
        public boolean displaymessageboxtopmost = true;
        @Config.Comment(value={"The text that will be displayed in the message box."})
        @Config.Name(value="3) Message Box Text")
        public String messageboxtext = "Hello Modpack Users! ";
    }

    public static class CustomMessageBox {
        @Config.Comment(value={"Customisable message that will appear each time the game starts. This is useful for displaying credits."})
        @Config.Name(value="1) Display message box?")
        public boolean displaymessagebox = false;
        @Config.Comment(value={"Will the window show on top of all other windows? Recommended to keep set to True."})
        @Config.Name(value="2) Display message box topmost?")
        public boolean displaymessageboxtopmost = true;
        @Config.Comment(value={"The text that will be displayed in the message box."})
        @Config.Name(value="3) Message Box Text")
        public String messageboxtext = "Hello Modpack Users! Made by matt1235r";
    }

    public static class CustomGreetingMessage {
        @Config.Comment(value={"A customisable message that will be displayed in chat when a world is loaded."})
        @Config.Name(value="1) Display Chat Greeting Message?")
        public boolean displaychatgreeting = false;
        @Config.Comment(value={"The text to be displayed in chat."})
        @Config.Name(value="3) Greeting Message Color")
        public TextFormattingColor greetingmessagecolor = TextFormattingColor.Purple;
        @Config.Comment(value={"The text to be displayed in chat."})
        @Config.Name(value="2) Greeting Message Text")
        public String greetingmessagetext = "Hello there! Welcome to my modpack.";
    }

    public static class FileHash1 {
        @Config.Comment(value={"If the target file hash is not the same as the target hash then a warning will be displayed. "})
        @Config.Name(value="1) Check File Hash?")
        public Boolean checkfilehash1 = false;
        @Config.Comment(value={"The file path to the target file. This is the file that the game will validate."})
        @Config.Name(value="2) File Path")
        public String filepath1 = "config/concheckrmd.cfg";
        @Config.Comment(value={"The hash algorithm to use. Supports MD5, SHA1, SHA256 and SHA512. Make sure that the target hash is entered in this format."})
        @Config.Name(value="3) Hash Algorithm")
        public HashEnum filehash1 = HashEnum.MD5;
        @Config.Comment(value={"This is the expected result when hashing the target file. This can be obtained by using a file hashing tool online. If the target hash differs from the target file hash then the game detects the file has been modified."})
        @Config.Name(value="4) Target Hash")
        public String filehashtarget1 = "E2AD5E7E16787E6C4C6949A1322B1E27";
        @Config.Comment(value={"Will the window show on top of all other windows? I highly recommend this is left as true."})
        @Config.Name(value="5) Display message box topmost?")
        public boolean messageboxtopmost = true;
        @Config.Comment(value={"Customise the text that appears in the warning message. Will display custom message instead of the default text."})
        @Config.Name(value="6) Display custom text in message box?")
        public boolean displaycustommessagebox = false;
        @Config.Comment(value={"The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text."})
        @Config.Name(value="7) Custom Message")
        public String custommessageboxtext = "A configuration file has been modified. Please restore this file to the original version.";

        static enum HashEnum {
            MD5,
            SHA1,
            SHA256,
            SHA512;

        }
    }

    public static class FileDate1 {
        @Config.Comment(value={"If the target file last modified date is not the same as the specified minimum date then a warning will be displayed."})
        @Config.Name(value="1) Check File Date?")
        public Boolean checkfiledate1 = false;
        @Config.Comment(value={"The file path to the target file. This is the file that the game will validate."})
        @Config.Name(value="2) File Path")
        public String filepath1 = "config/concheckrmd.cfg";
        @Config.Comment(value={"The dateTime format string to use. Will support all java dateTime strings. Make sure that the minimum is entered in this format. Configured to accept GB date strings by default. See CurseForge page for more details."})
        @Config.Name(value="3) DateTime Format String")
        public String datetimeformatstring1 = "dd/MM/yyyy";
        @Config.Comment(value={"The oldest the file is permitted to be. This will be compared to the target files 'Last Modified' date. With the default DateTime format string 'dd/MM/yyyy' the date will need to be entered in GB format. So the 5th April 2018 will be entered as 5/4/2018."})
        @Config.Name(value="4) File Date")
        public String mindatetime = "05/05/2018";
        @Config.Comment(value={"Customise the text that appears in the warning message. Will display custom message instead of the default text."})
        @Config.Name(value="6) Check File is newer or older?")
        public GreaterLesserEnum datetimenewerorolder = GreaterLesserEnum.FileOlder;
        @Config.Comment(value={"Will the window show on top of all other windows? I highly recommend this is left as true."})
        @Config.Name(value="6) Display message box topmost?")
        public boolean messageboxtopmost = true;
        @Config.Comment(value={"Customise the text that appears in the warning message. Will display custom message instead of the default text."})
        @Config.Name(value="7) Display custom text in message box?")
        public boolean displaycustommessagebox = false;
        @Config.Comment(value={"The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text."})
        @Config.Name(value="8) Custom Message")
        public String custommessageboxtext = "An updated quest file has been released. Visit the modpack page to download the update.";

        static enum GreaterLesserEnum {
            FileNewer,
            FileOlder;

        }
    }

    public static class FileChecking {
        @Config.Comment(value={"Will display all file checking related errors. Useful to check that file checking has been configured correctly but should be turned off before modpack is released."})
        @Config.Name(value="Activate Debug Mode?")
        public Boolean filecheckdebug = false;
        @Config.Name(value="Check File Date")
        @Config.Comment(value={"Check that a specified file is newer than a certain date. Useful to make sure quest books are up to date."})
        public FileDate1 filedate1 = new FileDate1();
        @Config.Name(value="Check File Hash")
        @Config.Comment(value={"Check that a specified file has not been modified. Useful to make sure configuration files have not been altered."})
        public FileHash1 filehash1 = new FileHash1();
    }

    public static enum TextFormattingColor {
        Blue,
        Green,
        Red,
        Aqua,
        Yellow,
        White,
        Black,
        Grey,
        Purple,
        Dark_Blue,
        Dark_Green,
        Dark_Red,
        Dark_Purple;

    }
}

