/*
 * Decompiled with CFR 0.152.
 */
package com.matt_r__.ConfigChecker;

import com.matt_r__.ConfigChecker.ApprovedModChecker;
import com.matt_r__.ConfigChecker.Event;
import com.matt_r__.ConfigChecker.MessageClass;
import com.matt_r__.ConfigChecker.ModConfig;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;
import util.Config;

@Mod(modid="concheckrmd", name="Config Checker", version="1.9.5", acceptedMinecraftVersions="[1.12, 1.12.2]", dependencies="before:*")
public class Main {
    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.printf("\n=========================================================================================\n\n[MODPACK CONFIGURATION CHECKER] NO DISPLAY DETECTED\n\n Modpack Configuration Checker can not check configuration in this enviroment. \n\n=========================================================================================\n", new Object[0]);
        } else {
            Main.LoadConfig();
            this.runChecks();
        }
    }

    @SideOnly(value=Side.SERVER)
    @Mod.EventHandler
    public void preInitServer(FMLPreInitializationEvent event) {
        System.out.printf("\n=========================================================================================\n\n[MODPACK CONFIGURATION CHECKER] SERVER DETECTED\n\n Modpack Configuration Checker can not check configuration in this enviroment. \n\n=========================================================================================\n", new Object[0]);
    }

    public void runChecks() {
        Main.LoadConfig();
        Config.gamebooting = true;
        ApprovedModChecker.StartChecks();
        this.filedatecheck();
        this.meetsrequiredram();
        this.meetsrecommendedram();
        this.launchwebpage();
        this.displaycustommessage();
        MinecraftForge.EVENT_BUS.register((Object)new Event());
        this.gamelaunchtimout();
    }

    public static void LoadConfig() {
        Configuration config = new Configuration(new File("concheckrmd"));
        config.load();
        Config.ramrecommendedinmbonload = ModConfig.ramlaunch.launchrecommendedraminmb;
        Config.checkRecommendedRAM = ModConfig.ramlaunch.launchcheckrecommendedram;
        Config.RecommendedRAMPopupTopmost = ModConfig.ramlaunch.launchdisplayrammessageboxtopmost;
        Config.DisplayCustomMessageBoxRecommendations = ModConfig.ramlaunch.launchcustomrecommendedtext;
        Config.CustomRAMRecommendationsMessageBox = ModConfig.ramlaunch.messageboxtext;
        Config.ramrecommendedinmbingame = ModConfig.ramgame.chatrecommendedraminmb;
        Config.showrecommendedramingame = ModConfig.ramgame.chatcheckrecommendedram;
        Config.showrecommendedramingamecustommessage = ModConfig.ramgame.chatcustomrecommendedtext;
        Config.recommendedramingamecustommessage = ModConfig.ramgame.chatramcustomtext;
        Config.ramrequiredinmb = ModConfig.reqram.requiredraminmb;
        Config.checkRequiredRAM = ModConfig.reqram.checkrequiredram;
        Config.RequiredRAMPopupTopmost = ModConfig.reqram.ramreqmessageboxtopmost;
        Config.DisplayCustomMessageBoxRequirements = ModConfig.reqram.customrequiredtext;
        Config.CustomRAMRequirementsMessageBox = ModConfig.reqram.requiredramcustomtext;
        Config.displaygreetingmessageingame = ModConfig.customg.displaychatgreeting;
        Config.greetingmessagetext = ModConfig.customg.greetingmessagetext;
        Config.greetingmessagecolor = Main.parseGreetingColor();
        Config.launchtimeoutinseconds = ModConfig.launchtimeout.launchtimeoutinseconds;
        Config.checklaunchtimeout = ModConfig.launchtimeout.checklaunchtimeout;
        Config.launchtimeoutmessageboxtopmost = ModConfig.launchtimeout.launchtimeoutmessageboxtopmost;
        Config.displaycustomlaunchtimeoutmessagebox = ModConfig.launchtimeout.displaycustomlaunchtimeoutmessagebox;
        Config.customlaunchtimeoutmessageboxtext = ModConfig.launchtimeout.customlaunchtimeoutmessageboxtext;
        Config.filecheckdebugmode = ModConfig.filechecking.filecheckdebug;
        Config.checkfiledate1 = ModConfig.filechecking.filedate1.checkfiledate1;
        Config.datetimeformatstring1 = ModConfig.filechecking.filedate1.datetimeformatstring1;
        Config.datetimefilepath1 = ModConfig.filechecking.filedate1.filepath1;
        Config.minimumdatetime1 = ModConfig.filechecking.filedate1.mindatetime;
        Config.filedatetopmost1 = ModConfig.filechecking.filedate1.messageboxtopmost;
        Config.custommessagefiledate1 = ModConfig.filechecking.filedate1.displaycustommessagebox;
        Config.custommessagefiledate1text = ModConfig.filechecking.filedate1.custommessageboxtext;
        Config.datetimechecknewerorolder1 = ModConfig.filechecking.filedate1.datetimenewerorolder.toString();
        Config.checkfilehash1 = ModConfig.filechecking.filehash1.checkfilehash1;
        Config.hashalgorithm1 = ModConfig.filechecking.filehash1.filehash1.toString();
        Config.hashfilepath1 = ModConfig.filechecking.filehash1.filepath1;
        Config.hashvalue1 = ModConfig.filechecking.filehash1.filehashtarget1;
        Config.hashtopmost1 = ModConfig.filechecking.filehash1.messageboxtopmost;
        Config.custommessagefilehash1 = ModConfig.filechecking.filehash1.displaycustommessagebox;
        Config.custommessagefilehashtext1 = ModConfig.filechecking.filehash1.custommessageboxtext;
        Config.webpageURL = ModConfig.webpage.websiteurl;
        Config.launchwebpage = ModConfig.webpage.displaywebsite;
        Config.displaylaunchmessage = ModConfig.custommb.displaymessagebox;
        Config.launchmessagetext = ModConfig.custommb.messageboxtext;
        Config.launchmessagetopmost = ModConfig.custommb.displaymessageboxtopmost;
        Config.displayfirstlaunchmessage = ModConfig.customfirststartmb.displaymessagebox;
        Config.firstlaunchmessagetext = ModConfig.customfirststartmb.messageboxtext;
        Config.firstlaunchmessagetopmost = ModConfig.customfirststartmb.displaymessageboxtopmost;
        if (new File("config/concheckrmd.lock").exists()) {
            Config.lockconfig = true;
        }
        config.save();
    }

    public void filedatecheck() {
        JFrame topframe = new JFrame();
        topframe.setAlwaysOnTop(true);
        if (Config.checkfiledate1.booleanValue()) {
            if (new File(Config.datetimefilepath1).exists()) {
                this.filedatecheck1();
            } else if (Config.filecheckdebugmode) {
                JOptionPane.showMessageDialog(topframe, "File: " + new File(Config.datetimefilepath1).getName() + " does not exist. Unable to check the file version.", "File does not exist", 2);
            }
        }
        if (Config.checkfilehash1.booleanValue()) {
            if (new File(Config.hashfilepath1).exists()) {
                this.filehashcheck1();
            } else if (Config.filecheckdebugmode) {
                JOptionPane.showMessageDialog(topframe, "File: " + new File(Config.hashfilepath1).getName() + " does not exist. Unable to check the file hash.", "File does not exist", 2);
            }
        }
    }

    public void filedatecheck1() {
        JFrame topframe = new JFrame();
        topframe.setAlwaysOnTop(true);
        try {
            int dialogResult;
            JFrame jf;
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(Config.datetimeformatstring1);
            }
            catch (Exception e) {
                if (Config.filecheckdebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error parsing date format string: " + Config.datetimeformatstring1 + ". Date format strings should follow a structure similar to 'dd/MM/yyyy', 'MM/dd/yy' etc.", "Error parsing date format string", 2);
                }
                return;
            }
            Calendar reqcal = Calendar.getInstance();
            try {
                reqcal.setTimeInMillis(sdf.parse(Config.minimumdatetime1).getTime());
            }
            catch (Exception e) {
                if (Config.filecheckdebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error parsing minimum date: " + Config.minimumdatetime1 + ". This date should follow the format of the date string: " + Config.datetimeformatstring1, "Error parsing date format string", 2);
                }
                return;
            }
            Calendar filecal = Calendar.getInstance();
            try {
                FileReader fileReader = new FileReader(Config.datetimefilepath1);
                fileReader.read();
                fileReader.close();
                filecal.setTimeInMillis(new File(Config.datetimefilepath1).lastModified());
            }
            catch (Exception e) {
                if (Config.filecheckdebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error detecting last modified date of file: " + new File(Config.datetimefilepath1).getName() + ". This is probably due to insufficient access rights on the file. ", "Error detecting last modified", 2);
                }
                return;
            }
            if (filecal.compareTo(reqcal) == -1 && Config.datetimechecknewerorolder1 == "FileOlder") {
                jf = new JFrame();
                if (Config.filedatetopmost1.booleanValue()) {
                    jf.setAlwaysOnTop(true);
                }
                if ((dialogResult = Config.custommessagefiledate1 != false ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", Config.custommessagefiledate1text, "", "", 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the following file is out of date and should be updated.\r\n\r\nPlease contact the modpack author to download an updated version.\r\n\r\nOutdated File: " + FilenameUtils.getName((String)Config.datetimefilepath1), "", "", 0)) == 1) {
                    FMLCommonHandler.instance().exitJava(1, false);
                }
            }
            if (filecal.compareTo(reqcal) == 1 && Config.datetimechecknewerorolder1 == "FileNewer") {
                jf = new JFrame();
                if (Config.filedatetopmost1.booleanValue()) {
                    jf.setAlwaysOnTop(true);
                }
                if ((dialogResult = Config.custommessagefiledate1 != false ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", Config.custommessagefiledate1text, "", "", 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the following file has been modified too recently is not compatible with this version.\r\n\r\nPlease contact the modpack author to download an older version.\r\n\r\nIncompatible File: " + FilenameUtils.getName((String)Config.datetimefilepath1), "", "", 0)) == 1) {
                    FMLCommonHandler.instance().exitJava(1, false);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(topframe, "Something went wrong while checking file date. Error Message says: " + e.getMessage(), "Error detecting last modified", 2);
        }
    }

    public void filehashcheck1() {
        block14: {
            JFrame topframe = new JFrame();
            topframe.setAlwaysOnTop(true);
            try {
                String currenthash;
                block13: {
                    try {
                        FileReader fileReader = new FileReader(Config.hashfilepath1);
                        fileReader.read();
                        fileReader.close();
                        if (Config.hashalgorithm1 == "MD5") {
                            currenthash = Main.toHex(Hash.MD5.checksum(new File(Config.hashfilepath1)));
                            break block13;
                        }
                        if (Config.hashalgorithm1 == "SHA1") {
                            currenthash = Main.toHex(Hash.SHA1.checksum(new File(Config.hashfilepath1)));
                            break block13;
                        }
                        if (Config.hashalgorithm1 == "SHA256") {
                            currenthash = Main.toHex(Hash.SHA256.checksum(new File(Config.hashfilepath1)));
                            break block13;
                        }
                        if (Config.hashalgorithm1 == "SHA512") {
                            currenthash = Main.toHex(Hash.SHA512.checksum(new File(Config.hashfilepath1)));
                            break block13;
                        }
                        if (Config.filecheckdebugmode) {
                            JOptionPane.showMessageDialog(topframe, "Something went wrong while determining the file hash algorithm to use, unable to find: " + Config.hashalgorithm1, "Error detecting hash algorithm", 2);
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (Config.filecheckdebugmode) {
                            JOptionPane.showMessageDialog(topframe, "Error detecting hash of file: " + new File(Config.hashfilepath1).getName() + ". This is probably due to insufficient access rights on the file.", "Error detecting hash", 2);
                        }
                        return;
                    }
                }
                if (!currenthash.toUpperCase().equals(Config.hashvalue1.toUpperCase())) {
                    int dialogResult;
                    JFrame jf = new JFrame();
                    if (Config.hashtopmost1.booleanValue()) {
                        jf.setAlwaysOnTop(true);
                    }
                    if ((dialogResult = Config.custommessagefilehash1 != false ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", Config.custommessagefilehashtext1, "", "", 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the following file has been modified in a way that is not supported by the modpack author.\n\nPlease revert the changes to this file, or download a new version.\n\n\nModified File: " + FilenameUtils.getName((String)Config.hashfilepath1), "", "", 0)) == 1) {
                        FMLCommonHandler.instance().exitJava(1, false);
                    }
                }
            }
            catch (Exception e) {
                if (!Config.filecheckdebugmode) break block14;
                JOptionPane.showMessageDialog(topframe, "Something went wrong while checking file hash. Error Message says: " + e.getMessage(), "Error detecting file hash", 2);
            }
        }
    }

    private static String toHex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public void gamelaunchtimout() {
        if (Config.checklaunchtimeout) {
            Timer timer = new Timer();
            final JFrame jf = new JFrame();
            long launchtimeout = TimeUnit.SECONDS.toMillis(Config.launchtimeoutinseconds);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Config.gamebooting) {
                        if (Config.launchtimeoutmessageboxtopmost) {
                            jf.setAlwaysOnTop(true);
                        }
                        if (Config.displaycustomlaunchtimeoutmessagebox) {
                            new MessageClass().PopulateMessage(jf, "Message from Modpack Author", Config.customlaunchtimeoutmessageboxtext, "", "", 1);
                        } else {
                            new MessageClass().PopulateMessage(jf, "Message from Modpack Author", "Modpack Configuration Checker has detected that the game has taken too long to start.\r\n\r\nThis may be due to this computer not being powerful enough to run this modpack, or the game may not be configured correctly.\r\n\r\nPlease contact the modpack author for assistance.", "", "", 1);
                        }
                        FMLCommonHandler.instance().exitJava(1, false);
                    }
                }
            }, launchtimeout);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String calculateTime(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days == 1L) {
            sb.append(days);
            sb.append(" day ");
        } else if (days != 0L) {
            sb.append(days);
            sb.append(" days ");
        }
        if (hours == 1L) {
            sb.append(hours);
            sb.append(" hour ");
        } else if (hours != 0L) {
            sb.append(hours);
            sb.append(" hours ");
        }
        if (minutes == 1L) {
            sb.append(minutes);
            sb.append(" minute ");
        } else if (minutes != 0L) {
            sb.append(minutes);
            sb.append(" minutes ");
        }
        if (seconds == 1L) {
            sb.append(seconds);
            sb.append(" second ");
        } else if (seconds != 0L) {
            sb.append(seconds);
            sb.append(" seconds ");
        }
        return sb.toString();
    }

    public void launchwebpage() {
        if (Config.launchwebpage) {
            Desktop desktop = Desktop.getDesktop();
            try {
                if (Config.webpageURL.startsWith("http") || Config.webpageURL.startsWith("https")) {
                    desktop.browse(URI.create(Config.webpageURL));
                } else {
                    desktop.browse(URI.create("http://" + Config.webpageURL));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JFrame jf = new JFrame();
                jf.setAlwaysOnTop(true);
                JOptionPane.showMessageDialog(jf, "Error opening webpage. The error is: " + e.getMessage(), "Error Opening Webpage", 0);
            }
        }
    }

    public void displaycustommessage() {
        if (Config.displaylaunchmessage) {
            JFrame jf = new JFrame();
            if (Config.launchmessagetopmost) {
                jf.setAlwaysOnTop(true);
            }
            new MessageClass().PopulateMessage(jf, "Message from Modpack Author", Config.launchmessagetext, "", "", 2);
        }
    }

    public void meetsrecommendedram() {
        int currentraminmb;
        if (Config.checkRecommendedRAM && Config.ramrecommendedinmbonload > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.coulddowithmoreram();
        }
    }

    public void coulddowithmoreram() {
        int dialogResult;
        long RamRecommendedinbytes = Config.ramrecommendedinmbonload * 1024;
        JFrame jf = new JFrame();
        if (Config.RecommendedRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if ((dialogResult = Config.DisplayCustomMessageBoxRecommendations ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", Config.CustomRAMRecommendationsMessageBox, Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRecommendedinbytes * 1024L, true), 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that you have not assigned the recommended amount of memory to this modpack.\r\n\r\nNot meeting the memory requirements can result in degraded performance, resulting in freezing and crashes.\r\n\r\nIt is recommended that you exit the game and assign more memory to this modpack now.", Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRecommendedinbytes * 1024L, true), 0)) == 1) {
            FMLCommonHandler.instance().exitJava(0, false);
        }
    }

    public void meetsrequiredram() {
        int currentraminmb;
        if (Config.checkRequiredRAM && Config.ramrequiredinmb > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.needmoreram();
        }
    }

    public void needmoreram() {
        long RamRequiredinbytes = Config.ramrequiredinmb * 1024;
        JFrame jf = new JFrame();
        if (Config.RequiredRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if (Config.DisplayCustomMessageBoxRequirements) {
            new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", Config.CustomRAMRequirementsMessageBox, Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRequiredinbytes * 1024L, true), 1);
        } else {
            new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that you have not assigned the required amount of memory to this modpack.\r\n\r\nNot meeting the memory requirements will result in poor performance, resulting in freezing and crashes.\r\n\r\nTo play this modpack you must exit the game and assign more memory to this modpack now.", Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRequiredinbytes * 1024L, true), 1);
        }
        FMLCommonHandler.instance().exitJava(1, false);
    }

    private static TextFormatting parseGreetingColor() {
        TextFormatting chatformat;
        switch (ModConfig.customg.greetingmessagecolor) {
            case Blue: {
                chatformat = TextFormatting.BLUE;
                break;
            }
            case Green: {
                chatformat = TextFormatting.GREEN;
                break;
            }
            case Red: {
                chatformat = TextFormatting.RED;
                break;
            }
            case Aqua: {
                chatformat = TextFormatting.AQUA;
                break;
            }
            case Yellow: {
                chatformat = TextFormatting.YELLOW;
                break;
            }
            case White: {
                chatformat = TextFormatting.WHITE;
                break;
            }
            case Black: {
                chatformat = TextFormatting.BLACK;
                break;
            }
            case Grey: {
                chatformat = TextFormatting.GRAY;
                break;
            }
            case Purple: {
                chatformat = TextFormatting.LIGHT_PURPLE;
                break;
            }
            case Dark_Blue: {
                chatformat = TextFormatting.DARK_BLUE;
                break;
            }
            case Dark_Green: {
                chatformat = TextFormatting.DARK_GREEN;
                break;
            }
            case Dark_Red: {
                chatformat = TextFormatting.DARK_RED;
                break;
            }
            case Dark_Purple: {
                chatformat = TextFormatting.DARK_PURPLE;
                break;
            }
            default: {
                chatformat = TextFormatting.LIGHT_PURPLE;
            }
        }
        return chatformat;
    }

    public static enum Hash {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA512("SHA-512");

        private String name;

        private Hash(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] checksum(File input) {
            try (FileInputStream in = new FileInputStream(input);){
                int length;
                MessageDigest digest = MessageDigest.getInstance(this.getName());
                byte[] block = new byte[4096];
                while ((length = ((InputStream)in).read(block)) > 0) {
                    digest.update(block, 0, length);
                }
                byte[] byArray = digest.digest();
                return byArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static enum TextFormattingColor {
        Blue,
        Green,
        Red,
        Aqua,
        Yellow,
        White,
        Black,
        Grey,
        Purple,
        Dark_Blue,
        Dark_Green,
        Dark_Red,
        Dark_Purple;

    }
}

