/*
 * Decompiled with CFR 0.152.
 */
package com.matt_r__.ConfigChecker;

import com.matt_r__.ConfigChecker.MessageClass;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.swing.JFrame;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ApprovedModChecker {
    static List<String> allowedMods;
    static String[] fileExtentions;

    public static void StartChecks() {
        try {
            if (new File("approvedmods.locked").exists()) {
                String content = new String(Files.readAllBytes(Paths.get("approvedmods.locked", new String[0])));
                allowedMods = Arrays.asList(ApprovedModChecker.decodeString(content).split("\\r?\\n"));
                ApprovedModChecker.GetMods();
            } else if (new File("approvedmods").exists()) {
                String content = new String(Files.readAllBytes(Paths.get("approvedmods", new String[0])));
                allowedMods = Arrays.asList(content.split("\\r?\\n"));
                ApprovedModChecker.GetMods();
            } else if (new File("config//MCC Extras//approvedmods.locked").exists()) {
                String content = new String(Files.readAllBytes(Paths.get("config//MCC Extras//approvedmods.locked", new String[0])));
                allowedMods = Arrays.asList(ApprovedModChecker.decodeString(content).split("\\r?\\n"));
                ApprovedModChecker.GetMods();
            } else if (new File("config//MCC Extras//approvedmods").exists()) {
                String content = new String(Files.readAllBytes(Paths.get("config//MCC Extras//approvedmods", new String[0])));
                allowedMods = Arrays.asList(content.split("\\r?\\n"));
                ApprovedModChecker.GetMods();
            }
        }
        catch (IllegalArgumentException ex) {
            JFrame jf = new JFrame();
            jf.setAlwaysOnTop(true);
            new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the modpacks approved mods file has been tampered with and is now invalid.\r\n\r\nPlease restore this file to it's unmodified state or contact the modpack author for assistance.", "", "", 1);
            FMLCommonHandler.instance().exitJava(0, false);
        }
        catch (Exception e) {
            JFrame jf = new JFrame();
            jf.setAlwaysOnTop(true);
            new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has encountered an error while checking the modpacks approved mod list.\r\n\r\nThe game is unable to launch without passing this check. Please contact the modpack author for assistance.\r\n\r\nError Message: " + e.getMessage(), "", "", 1);
            FMLCommonHandler.instance().exitJava(0, false);
        }
    }

    private static String encodeString(String input) {
        return Base64.getEncoder().encodeToString(input.getBytes());
    }

    private static String decodeString(String input) {
        return new String(Base64.getDecoder().decode(input));
    }

    private static void GetMods() {
        for (File file : Objects.requireNonNull(new File("Mods").listFiles())) {
            if (file.isDirectory()) continue;
            if (allowedMods.contains(file.getName())) {
                System.out.println("[APPROVED] " + file.getName());
                continue;
            }
            ApprovedModChecker.InvalidModFound(file.getName());
            System.out.println("[REJECTED] " + file.getName());
        }
    }

    private static void InvalidModFound(String name) {
        JFrame jf = new JFrame();
        jf.setAlwaysOnTop(true);
        new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the following mod is not approved by the modpack author.\r\n\r\nPlease delete this mod or contact the modpack author for assistance.\r\n\r\nRejected Mod: " + name, "", "", 1);
        FMLCommonHandler.instance().exitJava(0, false);
    }

    static {
        fileExtentions = new String[]{".jar", ".zip", ".litemod"};
    }
}

