/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.core.IModelManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelProviderGermling
implements IGermlingModelProvider {
    private final String name;
    private final ILeafSpriteProvider leafSpriteProvider;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation germlingModel;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation pollenModel;

    public ModelProviderGermling(String uid, ILeafSpriteProvider leafSpriteProvider) {
        String modelName = uid.substring("forestry.".length());
        this.name = StringUtil.camelCaseToUnderscores(modelName);
        this.leafSpriteProvider = leafSpriteProvider;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager, EnumGermlingType type) {
        if (type == EnumGermlingType.SAPLING) {
            this.germlingModel = manager.getModelLocation("germlings/sapling." + this.name);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:germlings/sapling." + this.name)});
        } else if (type == EnumGermlingType.POLLEN) {
            this.pollenModel = manager.getModelLocation("pollen");
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:pollen")});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(EnumGermlingType type) {
        if (type == EnumGermlingType.POLLEN) {
            return this.pollenModel;
        }
        return this.germlingModel;
    }

    @Override
    public int getSpriteColor(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.POLLEN) {
            return this.leafSpriteProvider.getColor(false);
        }
        return 0xFFFFFF;
    }
}

