/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import forestry.api.core.BiomeHelper;
import forestry.api.core.ForestryAPI;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumTemperature {
    NONE("None", "habitats/ocean", 0x808080),
    ICY("Icy", "habitats/snow", 0xAAFFF0),
    COLD("Cold", "habitats/taiga", 7527927),
    NORMAL("Normal", "habitats/plains", 16764947),
    WARM("Warm", "habitats/jungle", 16484900),
    HOT("Hot", "habitats/desert", 14029881),
    HELLISH("Hellish", "habitats/nether", 8454957);

    public static EnumTemperature[] VALUES;
    public final String name;
    public final String iconIndex;
    public final int color;

    private EnumTemperature(String name, String iconIndex, int color) {
        this.name = name;
        this.iconIndex = iconIndex;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return ForestryAPI.textureManager.getDefault(this.iconIndex);
    }

    public static EnumTemperature getFromValue(float rawTemp) {
        if (rawTemp > 1.0f) {
            return HOT;
        }
        if (rawTemp > 0.85f) {
            return WARM;
        }
        if (rawTemp > 0.35f) {
            return NORMAL;
        }
        if (rawTemp > 0.0f) {
            return COLD;
        }
        return ICY;
    }

    public static EnumTemperature getFromBiome(Biome biome) {
        if (BiomeHelper.isBiomeHellish(biome)) {
            return HELLISH;
        }
        return EnumTemperature.getFromValue(biome.func_185353_n());
    }

    @Deprecated
    public static EnumTemperature getFromBiome(Biome biome, World world, BlockPos pos) {
        return EnumTemperature.getFromBiome(biome, pos);
    }

    public static EnumTemperature getFromBiome(Biome biome, BlockPos pos) {
        if (BiomeHelper.isBiomeHellish(biome)) {
            return HELLISH;
        }
        float temperature = biome.func_180626_a(pos);
        return EnumTemperature.getFromValue(temperature);
    }

    static {
        VALUES = EnumTemperature.values();
    }
}

