/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.iface.IPurificationAsh;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.helper.PurificationHelper;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TilePurificationAltar
extends TileInventory
implements ITickable {
    public AreaDescriptor purityArea = new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11);
    public double totalPurity = 0.0;
    public double maxPurity = 0.0;
    public double purityRate = 0.0;

    public TilePurificationAltar() {
        super(1, "purificationAltar");
    }

    public void func_73660_a() {
        if (this.totalPurity <= 0.0) {
            ItemStack stack = this.func_70301_a(0);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IPurificationAsh) {
                this.totalPurity = ((IPurificationAsh)stack.func_77973_b()).getTotalPurity(stack);
                this.maxPurity = ((IPurificationAsh)stack.func_77973_b()).getMaxPurity(stack);
                this.purityRate = ((IPurificationAsh)stack.func_77973_b()).getPurityRate(stack);
            }
        } else {
            return;
        }
        AxisAlignedBB aabb = this.purityArea.getAABB(this.func_174877_v());
        List animalList = this.func_145831_w().func_72872_a(EntityAnimal.class, aabb);
        if (animalList.isEmpty()) {
            return;
        }
        boolean hasPerformed = false;
        for (EntityAnimal animal : animalList) {
            double added = PurificationHelper.addPurity(animal, Math.min(this.purityRate, this.totalPurity), this.maxPurity);
            if (!(added > 0.0)) continue;
            this.totalPurity -= this.purityRate;
            hasPerformed = true;
        }
        if (hasPerformed && this.func_145831_w().field_73012_v.nextInt(4) == 0 && this.func_145831_w() instanceof WorldServer) {
            WorldServer server = (WorldServer)this.func_145831_w();
            server.func_175739_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.02, 0.03, 0.02, 0.0, new int[0]);
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.totalPurity = tag.func_74769_h("totalPurity");
        this.maxPurity = tag.func_74769_h("maxPurity");
        this.purityRate = tag.func_74769_h("purityRate");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74780_a("totalPurity", this.totalPurity);
        tag.func_74780_a("maxPurity", this.maxPurity);
        tag.func_74780_a("purityRate", this.purityRate);
        return tag;
    }
}

