/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.ai;

import WayofTime.bloodmagic.entity.mob.EntityCorruptedChicken;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityAIAttackStealthMelee
extends EntityAIBase {
    protected final int attackInterval = 20;
    protected EntityCorruptedChicken chicken;
    protected int attackTick;
    World worldObj;
    double speedTowardsTarget;
    boolean longMemory;
    Path entityPathEntity;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public EntityAIAttackStealthMelee(EntityCorruptedChicken creature, double speedIn, boolean useLongMemory) {
        this.chicken = creature;
        this.worldObj = creature.func_130014_f_();
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.chicken.attackStateMachine != 1) {
            return false;
        }
        EntityLivingBase entitylivingbase = this.chicken.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.entityPathEntity = this.chicken.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.delayCounter = 4 + this.chicken.func_70681_au().nextInt(7);
                return this.entityPathEntity != null;
            }
            return true;
        }
        this.entityPathEntity = this.chicken.func_70661_as().func_75494_a((Entity)entitylivingbase);
        return this.entityPathEntity != null;
    }

    public boolean func_75253_b() {
        return this.chicken.attackStateMachine == 1 && super.func_75253_b();
    }

    public void func_75251_c() {
        if (this.chicken.attackStateMachine == 1) {
            this.chicken.attackStateMachine = 0;
        }
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.chicken.func_70638_az();
        this.chicken.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        double d0 = this.chicken.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        --this.delayCounter;
        if ((this.longMemory || this.chicken.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.chicken.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.field_70161_v;
            this.delayCounter = 4 + this.chicken.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.chicken.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.chicken.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.chicken.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.attackEntity(entitylivingbase, d0);
    }

    protected void attackEntity(EntityLivingBase attacked, double distance) {
        double d0 = this.getAttackReachSqr(attacked);
        if (distance <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            this.chicken.func_184609_a(EnumHand.MAIN_HAND);
            this.chicken.func_70652_k((Entity)attacked);
            this.chicken.attackStateMachine = 2;
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.chicken.field_70130_N * 2.0f * this.chicken.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }
}

