/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.awt.Color;
import net.minecraft.util.math.MathHelper;

public class ColorHelper {
    public static int fixColor(int rgb) {
        int color = rgb;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        return color;
    }

    public static Color getColor(int rgb) {
        return new Color(ColorHelper.fixColor(rgb));
    }

    public static int getRed(int rgb) {
        return ColorHelper.getColor(rgb).getRed();
    }

    public static int getGreen(int rgb) {
        return ColorHelper.getColor(rgb).getGreen();
    }

    public static int getBlue(int rgb) {
        return ColorHelper.getColor(rgb).getBlue();
    }

    public static int blend(int color1, int color2, float blendRatio) {
        blendRatio = MathHelper.func_76131_a((float)blendRatio, (float)0.0f, (float)1.0f);
        int alpha1 = color1 >> 24 & 0xFF;
        int red1 = (color1 & 0xFF0000) >> 16;
        int green1 = (color1 & 0xFF00) >> 8;
        int blue1 = color1 & 0xFF;
        int alpha2 = color2 >> 24 & 0xFF;
        int red2 = (color2 & 0xFF0000) >> 16;
        int green2 = (color2 & 0xFF00) >> 8;
        int blue2 = color2 & 0xFF;
        int alpha = Math.max(alpha1, alpha2);
        int red = (int)((float)red1 + (float)(red2 - red1) * blendRatio);
        int green = (int)((float)green1 + (float)(green2 - green1) * blendRatio);
        int blue = (int)((float)blue1 + (float)(blue2 - blue1) * blendRatio);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

