/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public final class WorldHelper {
    public static int getChunkXFromBlock(int blockX) {
        return blockX >> 4;
    }

    public static int getChunkXFromBlock(BlockPos position) {
        return position.func_177958_n() >> 4;
    }

    public static int getChunkZFromBlock(int blockZ) {
        return blockZ >> 4;
    }

    public static int getChunkZFromBlock(BlockPos position) {
        return position.func_177952_p() >> 4;
    }

    public static void notifyBlockUpdate(World world, BlockPos position, IBlockState oldState, IBlockState newState) {
        if (null == oldState) {
            oldState = world.func_180495_p(position);
        }
        if (null == newState) {
            newState = oldState;
        }
        world.func_184138_a(position, oldState, newState, 3);
    }

    private WorldHelper() {
    }

    public static long getChunkXZHashFromBlock(int blockX, int blockZ) {
        return ChunkPos.func_77272_a((int)WorldHelper.getChunkXFromBlock(blockX), (int)WorldHelper.getChunkZFromBlock(blockZ));
    }

    public static long getChunkXZHashFromBlock(BlockPos position) {
        return ChunkPos.func_77272_a((int)WorldHelper.getChunkXFromBlock(position), (int)WorldHelper.getChunkZFromBlock(position));
    }

    @Deprecated
    public static boolean blockChunkExists(IChunkProvider chunkProvider, BlockPos position) {
        return null != chunkProvider.func_186026_b(WorldHelper.getChunkXFromBlock(position), WorldHelper.getChunkZFromBlock(position));
    }
}

