/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.source;

import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class RadiationSource
implements IRadiationSource {
    private double radiationLevel = 0.0;
    private double radiationBuffer = 0.0;
    private double scrubbingFraction = 0.0;
    private double effectiveScrubberCount = 0.0;

    public RadiationSource(double startRadiation) {
        this.radiationLevel = startRadiation;
    }

    @Override
    public NBTTagCompound writeNBT(IRadiationSource instance, EnumFacing side, NBTTagCompound nbt) {
        nbt.func_74780_a("radiationLevel", this.getRadiationLevel());
        nbt.func_74780_a("radiationBuffer", this.getRadiationBuffer());
        nbt.func_74780_a("scrubbingFraction", this.scrubbingFraction);
        nbt.func_74780_a("effectiveScrubberCount", this.effectiveScrubberCount);
        return nbt;
    }

    @Override
    public void readNBT(IRadiationSource instance, EnumFacing side, NBTTagCompound nbt) {
        this.setRadiationLevel(nbt.func_74769_h("radiationLevel"));
        this.setRadiationBuffer(nbt.func_74769_h("radiationBuffer"));
        this.scrubbingFraction = nbt.func_74769_h("scrubbingFraction");
        this.effectiveScrubberCount = nbt.func_74769_h("effectiveScrubberCount");
    }

    @Override
    public double getRadiationLevel() {
        return this.radiationLevel;
    }

    @Override
    public void setRadiationLevel(double newRads) {
        this.radiationLevel = Math.max(newRads, 0.0);
    }

    @Override
    public double getRadiationBuffer() {
        return this.radiationBuffer;
    }

    @Override
    public void setRadiationBuffer(double newBuffer) {
        this.radiationBuffer = newBuffer;
    }

    @Override
    public double getScrubbingFraction() {
        return this.scrubbingFraction;
    }

    @Override
    public void setScrubbingFraction(double newFraction) {
        this.scrubbingFraction = MathHelper.func_151237_a((double)newFraction, (double)0.0, (double)1.0);
    }

    @Override
    public double getEffectiveScrubberCount() {
        return this.effectiveScrubberCount;
    }

    @Override
    public void setEffectiveScrubberCount(double newScrubberCount) {
        this.effectiveScrubberCount = Math.max(0.0, newScrubberCount);
    }
}

