/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.mapgen;

import java.util.Random;
import mcjty.lib.varia.MathTools;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenCanyons {
    private final GenericChunkGenerator provider;
    private int range = 8;
    private Random rand = new Random();
    private float[] field_75046_d = new float[1024];

    public MapGenCanyons(GenericChunkGenerator provider) {
        this.provider = provider;
    }

    private void func_151540_a(long seed, int p_151540_3_, int p_151540_4_, ChunkPrimer primer, double p_151540_6_, double p_151540_8_, double p_151540_10_, float p_151540_12_, float p_151540_13_, float p_151540_14_, int p_151540_15_, int p_151540_16_, double p_151540_17_) {
        IBlockState baseBlock = this.provider.dimensionInformation.getCanyonBlock();
        Random random = new Random(seed);
        double d4 = p_151540_3_ * 16 + 8;
        double d5 = p_151540_4_ * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (p_151540_16_ <= 0) {
            int j1 = this.range * 16 - 16;
            p_151540_16_ = j1 - random.nextInt(j1 / 4);
        }
        boolean flag1 = false;
        if (p_151540_15_ == -1) {
            p_151540_15_ = p_151540_16_ / 2;
            flag1 = true;
        }
        float f5 = 1.0f;
        for (int k1 = 0; k1 < 256; ++k1) {
            if (k1 == 0 || random.nextInt(3) == 0) {
                f5 = 1.0f + random.nextFloat() * random.nextFloat() * 1.0f;
            }
            this.field_75046_d[k1] = f5 * f5;
        }
        while (p_151540_15_ < p_151540_16_) {
            double d12 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)p_151540_15_ * (float)Math.PI / (float)p_151540_16_)) * p_151540_12_ * 1.0f);
            double d6 = d12 * p_151540_17_;
            d12 *= (double)random.nextFloat() * 0.25 + 0.75;
            d6 *= (double)random.nextFloat() * 0.25 + 0.75;
            float f6 = MathHelper.func_76134_b((float)p_151540_14_);
            float f7 = MathHelper.func_76126_a((float)p_151540_14_);
            p_151540_6_ += (double)(MathHelper.func_76134_b((float)p_151540_13_) * f6);
            p_151540_8_ += (double)f7;
            p_151540_10_ += (double)(MathHelper.func_76126_a((float)p_151540_13_) * f6);
            p_151540_14_ *= 0.7f;
            p_151540_14_ += f4 * 0.05f;
            p_151540_13_ += f3 * 0.05f;
            f4 *= 0.8f;
            f3 *= 0.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (flag1 || random.nextInt(4) != 0) {
                double d7 = p_151540_6_ - d4;
                double d8 = p_151540_10_ - d5;
                double d9 = p_151540_16_ - p_151540_15_;
                double d10 = p_151540_12_ + 2.0f + 16.0f;
                if (d7 * d7 + d8 * d8 - d9 * d9 > d10 * d10) {
                    return;
                }
                if (p_151540_6_ >= d4 - 16.0 - d12 * 2.0 && p_151540_10_ >= d5 - 16.0 - d12 * 2.0 && p_151540_6_ <= d4 + 16.0 + d12 * 2.0 && p_151540_10_ <= d5 + 16.0 + d12 * 2.0) {
                    int i4 = MathTools.floor((double)(p_151540_6_ - d12)) - p_151540_3_ * 16 - 1;
                    int l1 = MathTools.floor((double)(p_151540_6_ + d12)) - p_151540_3_ * 16 + 1;
                    int j4 = MathTools.floor((double)(p_151540_8_ - d6)) - 1;
                    int i2 = MathTools.floor((double)(p_151540_8_ + d6)) + 1;
                    int k4 = MathTools.floor((double)(p_151540_10_ - d12)) - p_151540_4_ * 16 - 1;
                    int j2 = MathTools.floor((double)(p_151540_10_ + d12)) - p_151540_4_ * 16 + 1;
                    if (i4 < 0) {
                        i4 = 0;
                    }
                    if (l1 > 16) {
                        l1 = 16;
                    }
                    if (j4 < 1) {
                        j4 = 1;
                    }
                    if (i2 > 248) {
                        i2 = 248;
                    }
                    if (k4 < 0) {
                        k4 = 0;
                    }
                    if (j2 > 16) {
                        j2 = 16;
                    }
                    for (int k2 = i4; k2 < l1; ++k2) {
                        double d13 = ((double)(k2 + p_151540_3_ * 16) + 0.5 - p_151540_6_) / d12;
                        for (int j3 = k4; j3 < j2; ++j3) {
                            double d14 = ((double)(j3 + p_151540_4_ * 16) + 0.5 - p_151540_10_) / d12;
                            int k3 = (k2 * 16 + j3) * 256 + i2;
                            if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                            for (int l3 = i2 - 1; l3 >= j4; --l3) {
                                IBlockState block;
                                double d11 = ((double)l3 + 0.5 - p_151540_8_) / d6;
                                if ((d13 * d13 + d14 * d14) * (double)this.field_75046_d[l3] + d11 * d11 / 6.0 < 1.0 && ((block = BaseTerrainGenerator.getBlockState(primer, k3)).func_177230_c() == Blocks.field_150350_a || block == null)) {
                                    BaseTerrainGenerator.setBlockState(primer, k3, baseBlock);
                                }
                                --k3;
                            }
                        }
                    }
                    if (flag1) break;
                }
            }
            ++p_151540_15_;
        }
    }

    public void generate(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        int k = this.range;
        this.rand.setSeed(world.func_72905_C());
        long l = this.rand.nextLong();
        long i1 = this.rand.nextLong();
        for (int cx = chunkX - k; cx <= chunkX + k; ++cx) {
            for (int cz = chunkZ - k; cz <= chunkZ + k; ++cz) {
                long l1 = (long)cx * l;
                long i2 = (long)cz * i1;
                this.rand.setSeed(l1 ^ i2 ^ world.func_72905_C());
                this.fillChunk(cx, cz, chunkX, chunkZ, primer);
            }
        }
    }

    private void fillChunk(int cx, int cz, int chunkX, int chunkZ, ChunkPrimer primer) {
        if (this.rand.nextInt(50) == 0) {
            double x = cx * 16 + this.rand.nextInt(16);
            double y = this.rand.nextInt(this.rand.nextInt(40) + 8) + 20;
            double z = cz * 16 + this.rand.nextInt(16);
            int b0 = 1;
            for (int i1 = 0; i1 < b0; ++i1) {
                float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = (this.rand.nextFloat() * 2.0f + this.rand.nextFloat()) * 2.0f;
                this.func_151540_a(this.rand.nextLong(), chunkX, chunkZ, primer, x, y, z, f2, f, f1, 0, 0, 3.0);
            }
        }
    }
}

