/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.MathTools;
import mcjty.rftoolsdim.config.DimletRules;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.world.GenericWorldProvider;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.items.PhasedFieldGeneratorItem;
import mcjty.rftoolsdim.network.DimensionSyncPacket;
import mcjty.rftoolsdim.network.PacketRegisterDimensions;
import mcjty.rftoolsdim.network.PacketSyncDimensionInfo;
import mcjty.rftoolsdim.network.PacketSyncRules;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RfToolsDimensionManager
extends WorldSavedData {
    public static final String DIMMANAGER_NAME = "RFToolsDimensionManager";
    private static RfToolsDimensionManager instance = null;
    private static RfToolsDimensionManager clientInstance = null;
    private final Map<Integer, DimensionDescriptor> dimensions = new HashMap<Integer, DimensionDescriptor>();
    private final Map<DimensionDescriptor, Integer> dimensionToID = new HashMap<DimensionDescriptor, Integer>();
    private final Map<Integer, DimensionInformation> dimensionInformation = new HashMap<Integer, DimensionInformation>();
    private final Set<Integer> reclaimedIds = new HashSet<Integer>();

    @SideOnly(value=Side.CLIENT)
    public void syncFromServer(Map<Integer, DimensionDescriptor> dims, Map<Integer, DimensionInformation> dimInfo) {
        for (Map.Entry<Integer, DimensionDescriptor> entry : dims.entrySet()) {
            int id = entry.getKey();
            DimensionDescriptor descriptor = entry.getValue();
            if (this.dimensions.containsKey(id)) {
                this.dimensionToID.remove(this.dimensions.get(id));
            }
            this.dimensions.put(id, descriptor);
            this.dimensionToID.put(descriptor, id);
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        GenericWorldProvider provider = world != null && world.field_73011_w instanceof GenericWorldProvider ? (GenericWorldProvider)world.field_73011_w : null;
        for (Map.Entry<Integer, DimensionInformation> entry : dimInfo.entrySet()) {
            int id = entry.getKey();
            DimensionInformation info = entry.getValue();
            this.dimensionInformation.put(id, info);
            if (provider == null || provider.getDimension() != id) continue;
            provider.setDimensionInformation(info);
        }
    }

    public RfToolsDimensionManager(String identifier) {
        super(identifier);
    }

    public static void clearInstance() {
        if (instance != null) {
            RfToolsDimensionManager.instance.dimensions.clear();
            RfToolsDimensionManager.instance.dimensionToID.clear();
            RfToolsDimensionManager.instance.dimensionInformation.clear();
            RfToolsDimensionManager.instance.reclaimedIds.clear();
            instance = null;
        }
    }

    public static void cleanupDimensionInformation() {
        if (instance != null) {
            Logging.log((String)"Cleaning up RFTools dimensions");
            RfToolsDimensionManager.unregisterDimensions();
            instance.getDimensions().clear();
            RfToolsDimensionManager.instance.dimensionToID.clear();
            RfToolsDimensionManager.instance.dimensionInformation.clear();
            RfToolsDimensionManager.instance.reclaimedIds.clear();
            instance = null;
        }
    }

    public static void unregisterDimensions() {
        for (Map.Entry<Integer, DimensionDescriptor> me : instance.getDimensions().entrySet()) {
            int id = me.getKey();
            if (DimensionManager.isDimensionRegistered((int)id)) {
                Logging.log((String)("    Unregister dimension: " + id));
                try {
                    DimensionManager.unregisterDimension((int)id);
                }
                catch (Exception e) {
                    Logging.log((String)("        Could not unregister dimension: " + id));
                }
                continue;
            }
            Logging.log((String)("    Already unregistered! Dimension: " + id));
        }
    }

    public void save(World world) {
        world.func_175693_T().func_75745_a(DIMMANAGER_NAME, (WorldSavedData)this);
        this.func_76185_a();
        this.syncDimInfoToClients(world);
    }

    public void reclaimId(int id) {
        this.reclaimedIds.add(id);
    }

    public static void freezeDimension(World world) {
        ArrayList<BlockPos> pfgList = new ArrayList<BlockPos>();
        int radius = PowerConfiguration.phasedFieldGeneratorRange;
        if (radius > 0) {
            for (EntityPlayer player : world.field_73010_i) {
                DimensionInformation information;
                int cost = 0;
                if (PowerConfiguration.dimensionDifficulty != -1 && (cost = (information = ((GenericWorldProvider)world.field_73011_w).getDimensionInformation()).getActualRfCost()) == 0) {
                    DimensionDescriptor descriptor = information.getDescriptor();
                    cost = descriptor.getRfMaintainCost();
                }
                if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, false, cost)) continue;
                pfgList.add(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v));
            }
        }
        ArrayList<Entity> tokeep = new ArrayList<Entity>();
        tokeep.addAll(world.field_73010_i);
        for (BlockPos coordinate : pfgList) {
            RfToolsDimensionManager.getEntitiesInSphere(world, coordinate, (float)radius, tokeep);
        }
        world.field_72996_f.clear();
        world.field_72996_f.addAll(tokeep);
        world.field_147482_g.clear();
    }

    private static void getEntitiesInSphere(World world, BlockPos c, float radius, List<Entity> tokeep) {
        int i = MathTools.floor((double)((double)((float)c.func_177958_n() - radius) / 16.0));
        int j = MathTools.floor((double)((double)((float)(c.func_177958_n() + 1) + radius) / 16.0));
        int k = MathTools.floor((double)((double)((float)c.func_177952_p() - radius) / 16.0));
        int l = MathTools.floor((double)((double)((float)(c.func_177952_p() + 1) + radius) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (world.func_72863_F().func_186026_b(i1, j1) == null) continue;
                Chunk chunk = world.func_72964_e(i1, j1);
                RfToolsDimensionManager.getEntitiesInSphere(chunk, c, radius, tokeep);
            }
        }
    }

    private static void getEntitiesInSphere(Chunk chunk, BlockPos c, float radius, List<Entity> entities) {
        float squaredRange = radius * radius;
        int i = MathTools.floor((double)((double)((float)c.func_177956_o() - radius) / 16.0));
        int j = MathTools.floor((double)((double)((float)(c.func_177956_o() + 1) + radius) / 16.0));
        int n = i < 0 ? 0 : (i = i > chunk.func_177429_s().length - 1 ? chunk.func_177429_s().length - 1 : i);
        j = j < 0 ? 0 : (j > chunk.func_177429_s().length - 1 ? chunk.func_177429_s().length - 1 : j);
        block0: for (int k = i; k <= j; ++k) {
            ClassInheritanceMultiMap entityList = chunk.func_177429_s()[k];
            for (Entity entity : entityList) {
                float sqdist;
                if (entity instanceof EntityPlayer || !((sqdist = RfToolsDimensionManager.squaredDistance(c, new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v))) < squaredRange)) continue;
                entities.add(entity);
                continue block0;
            }
        }
    }

    public static float squaredDistance(BlockPos p1, BlockPos c) {
        return (c.func_177958_n() - p1.func_177958_n()) * (c.func_177958_n() - p1.func_177958_n()) + (c.func_177956_o() - p1.func_177956_o()) * (c.func_177956_o() - p1.func_177956_o()) + (c.func_177952_p() - p1.func_177952_p()) * (c.func_177952_p() - p1.func_177952_p());
    }

    public static void unfreezeDimension(World world) {
        WorldServer worldServer = (WorldServer)world;
        for (Chunk chunk : worldServer.func_72863_F().func_189548_a()) {
            RfToolsDimensionManager.unfreezeChunk(chunk);
        }
    }

    public static void unfreezeChunk(Chunk chunk) {
        chunk.func_177412_p().func_147448_a(chunk.func_177434_r().values());
        for (ClassInheritanceMultiMap entityList : chunk.func_177429_s()) {
            chunk.func_177412_p().field_72996_f.addAll(entityList);
        }
    }

    public static boolean checkValidPhasedFieldGenerator(EntityPlayer player, boolean consume, int tickCost) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            int toConsume;
            PhasedFieldGeneratorItem pfg;
            int energyStored;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot.func_190926_b() || slot.func_77973_b() != ModItems.phasedFieldGeneratorItem || (energyStored = (pfg = (PhasedFieldGeneratorItem)slot.func_77973_b()).getEnergyStored(slot)) < (toConsume = GeneralConfiguration.enableDynamicPhaseCost ? (int)((float)(10 * tickCost) * GeneralConfiguration.dynamicPhaseCostAmount) : 10 * PowerConfiguration.PHASEDFIELD_CONSUMEPERTICK)) continue;
            if (consume) {
                pfg.extractEnergy(slot, toConsume, false);
            }
            return true;
        }
        return false;
    }

    public void syncDimletRules(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            Logging.log((String)"Send dimlet rules to the client");
            RFToolsDimMessages.INSTANCE.sendTo((IMessage)new PacketSyncRules(DimletRules.getRules()), (EntityPlayerMP)player);
        }
    }

    public void syncDimInfoToClients(World world) {
        if (!world.field_72995_K) {
            Logging.log((String)"Sync dimension info to clients!");
            RFToolsDimMessages.INSTANCE.sendToAll((IMessage)new PacketSyncDimensionInfo(this.dimensions, this.dimensionInformation));
        }
    }

    public DimensionSyncPacket makeDimensionSyncPacket() {
        return new DimensionSyncPacket(this.dimensions, this.dimensionInformation);
    }

    public Map<Integer, DimensionDescriptor> getDimensions() {
        return this.dimensions;
    }

    public void registerDimensions() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Integer, DimensionDescriptor> me : this.dimensions.entrySet()) {
            int id = me.getKey();
            builder.append(id);
            builder.append(' ');
            this.registerDimensionToServerAndClient(id);
        }
        Logging.log((String)("Registering RFTools dimensions: " + builder.toString()));
    }

    private void registerDimensionToServerAndClient(int id) {
        File chunkDir;
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.registerDimension((int)id, (DimensionType)ModDimensions.rftoolsType);
        }
        if (DimensionManager.getWorld((int)id) == null && ForgeChunkManager.savedWorldHasForcedChunkTickets((File)(chunkDir = new File(DimensionManager.getCurrentSaveRootDirectory(), DimensionManager.createProviderFor((int)id).getSaveFolder())))) {
            DimensionManager.initDimension((int)id);
        }
        RFToolsDimMessages.INSTANCE.sendToAll((IMessage)new PacketRegisterDimensions(id));
    }

    public static RfToolsDimensionManager getDimensionManagerClient() {
        if (clientInstance == null) {
            clientInstance = new RfToolsDimensionManager(DIMMANAGER_NAME);
        }
        return clientInstance;
    }

    public static RfToolsDimensionManager getDimensionManagerClientNullable(World world) {
        return clientInstance;
    }

    public static RfToolsDimensionManager getDimensionManager(World world) {
        if (instance != null) {
            return instance;
        }
        instance = (RfToolsDimensionManager)world.func_175693_T().func_75742_a(RfToolsDimensionManager.class, DIMMANAGER_NAME);
        if (instance == null) {
            instance = new RfToolsDimensionManager(DIMMANAGER_NAME);
        }
        return instance;
    }

    public DimensionDescriptor getDimensionDescriptor(int id) {
        return this.dimensions.get(id);
    }

    public Integer getDimensionID(DimensionDescriptor descriptor) {
        return this.dimensionToID.get(descriptor);
    }

    public DimensionInformation getDimensionInformation(int id) {
        return this.dimensionInformation.get(id);
    }

    public static World getWorldForDimension(World world, int id) {
        WorldServer w = DimensionManager.getWorld((int)id);
        if (w == null) {
            w = world.func_73046_m().func_71218_a(id);
        }
        return w;
    }

    public void removeDimension(int id) {
        DimensionDescriptor descriptor = this.dimensions.get(id);
        this.dimensions.remove(id);
        this.dimensionToID.remove(descriptor);
        this.dimensionInformation.remove(id);
        if (DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.unregisterDimension((int)id);
        }
    }

    public void recoverDimension(World world, int id, DimensionDescriptor descriptor, String name, String playerName, UUID player) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            this.registerDimensionToServerAndClient(id);
        }
        DimensionInformation dimensionInfo = new DimensionInformation(name, descriptor, world, playerName, player);
        this.dimensions.put(id, descriptor);
        this.dimensionToID.put(descriptor, id);
        this.dimensionInformation.put(id, dimensionInfo);
        this.save(world);
        this.touchSpawnChunk(world, id);
    }

    public int countOwnedDimensions(UUID player) {
        int cnt = 0;
        for (DimensionInformation information : this.dimensionInformation.values()) {
            if (!player.equals(information.getOwner())) continue;
            ++cnt;
        }
        return cnt;
    }

    public int createNewDimension(World world, DimensionDescriptor descriptor, String name, String playerName, UUID player) {
        int id = 0;
        while (!this.reclaimedIds.isEmpty()) {
            int rid = this.reclaimedIds.iterator().next();
            this.reclaimedIds.remove(rid);
            if (DimensionManager.isDimensionRegistered((int)rid)) continue;
            id = rid;
            break;
        }
        if (id == 0) {
            id = DimensionManager.getNextFreeDimId();
        }
        this.registerDimensionToServerAndClient(id);
        Logging.log((String)("id = " + id + " for " + name + ", descriptor = " + descriptor.getDescriptionString()));
        this.dimensions.put(id, descriptor);
        this.dimensionToID.put(descriptor, id);
        try {
            DimensionInformation dimensionInfo = new DimensionInformation(name, descriptor, world, playerName, player);
            this.dimensionInformation.put(id, dimensionInfo);
        }
        catch (Exception e) {
            Logging.logError((String)"Something went wrong during creation of the dimension!");
            e.printStackTrace();
        }
        this.save(world);
        this.touchSpawnChunk(world, id);
        return id;
    }

    private void touchSpawnChunk(World world, int id) {
        WorldServer worldServerForDimension = world.func_73046_m().func_71218_a(id);
        ChunkProviderServer providerServer = worldServerForDimension.func_72863_F();
        if (!providerServer.func_73149_a(0, 0)) {
            try {
                providerServer.func_186025_d(0, 0);
                providerServer.field_186029_c.func_185931_b(0, 0);
            }
            catch (Exception e) {
                Logging.logError((String)"Something went wrong during creation of the dimension!");
                e.printStackTrace();
            }
        }
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        int[] lstIds;
        this.dimensions.clear();
        this.dimensionToID.clear();
        this.dimensionInformation.clear();
        this.reclaimedIds.clear();
        NBTTagList lst = tagCompound.func_150295_c("dimensions", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("id");
            DimensionDescriptor descriptor = new DimensionDescriptor(tc);
            this.dimensions.put(id, descriptor);
            this.dimensionToID.put(descriptor, id);
            DimensionInformation dimensionInfo = new DimensionInformation(descriptor, tc);
            this.dimensionInformation.put(id, dimensionInfo);
        }
        for (int id : lstIds = tagCompound.func_74759_k("reclaimedIds")) {
            this.reclaimedIds.add(id);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, DimensionDescriptor> me : this.dimensions.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            Integer id = me.getKey();
            tc.func_74768_a("id", id.intValue());
            me.getValue().writeToNBT(tc);
            DimensionInformation dimensionInfo = this.dimensionInformation.get(id);
            dimensionInfo.writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("dimensions", (NBTBase)lst);
        ArrayList<Integer> ids = new ArrayList<Integer>(this.reclaimedIds);
        int[] lstIds = new int[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            lstIds[i] = (Integer)ids.get(i);
        }
        tagCompound.func_74783_a("reclaimedIds", lstIds);
        return tagCompound;
    }
}

