/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.client;

import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualAltar;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class RitualStartMessage
extends AbstractMessage.AbstractClientMessage<RitualStartMessage> {
    private BlockPos pos;
    private String name;
    private int sacrifice;

    public RitualStartMessage() {
    }

    public RitualStartMessage(BlockPos pos, String name, int sacrifice) {
        this.pos = pos;
        this.name = name;
        this.sacrifice = sacrifice;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.sacrifice = buffer.func_150792_a();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_179255_a(this.pos);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.func_150787_b(this.sacrifice);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        TileEntity te;
        NecronomiconRitual ritual = null;
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().equals(this.name)) continue;
            ritual = r;
            break;
        }
        if ((te = player.field_70170_p.func_175625_s(this.pos)) instanceof IRitualAltar) {
            IRitualAltar altar = (IRitualAltar)te;
            altar.setRitualFields(ritual, (EntityLiving)player.field_70170_p.func_73045_a(this.sacrifice));
        }
    }
}

