/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.client;

import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionEntry;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionHandler;
import com.shinoow.abyssalcraft.api.event.ACEvents;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class DisruptionMessage
extends AbstractMessage.AbstractClientMessage<DisruptionMessage> {
    private String deity;
    private String name;
    private BlockPos pos;

    public DisruptionMessage() {
    }

    public DisruptionMessage(EnergyEnum.DeityType deity, String name, BlockPos pos) {
        this.deity = deity != null ? deity.toString() : "";
        this.name = name;
        this.pos = pos;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.deity = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.pos = buffer.func_179259_c();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.deity);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.func_179255_a(this.pos);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        List players = player.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.pos).func_72314_b(16.0, 16.0, 16.0));
        DisruptionEntry disruption = DisruptionHandler.instance().disruptionFromName(this.name);
        if (!MinecraftForge.EVENT_BUS.post((Event)new ACEvents.DisruptionEvent(!this.deity.isEmpty() ? EnergyEnum.DeityType.valueOf(this.deity) : null, player.field_70170_p, this.pos, players, disruption))) {
            disruption.disrupt(player.field_70170_p, this.pos, players);
        }
    }
}

