/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.handlers;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.transfer.ItemTransferConfiguration;
import com.shinoow.abyssalcraft.api.transfer.caps.IItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapabilityProvider;
import com.shinoow.abyssalcraft.common.entity.EntitySpiritItem;
import com.shinoow.abyssalcraft.init.InitHandler;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ItemTransferEventHandler {
    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<TileEntity> event) {
        ResourceLocation rl = TileEntity.func_190559_a(((TileEntity)event.getObject()).getClass());
        if (rl != null && !InitHandler.INSTANCE.isTileBlackListed(rl.toString())) {
            event.addCapability(new ResourceLocation("abyssalcraft", "itemtransfer"), (ICapabilityProvider)new ItemTransferCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.type == TickEvent.Type.WORLD && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (world.func_82737_E() % 20L != 0L) {
                return;
            }
            ArrayList list = new ArrayList(world.field_147482_g);
            list.stream().filter(t -> world.func_175667_e(t.func_174877_v())).filter(this::hasCap).filter(ItemTransferEventHandler::hasInventory).forEach(tile -> {
                IItemTransferCapability cap = ItemTransferCapability.getCap(tile);
                for (ItemTransferConfiguration cfg : cap.getTransferConfigurations()) {
                    IItemHandler exitInv;
                    BlockPos exitPos;
                    TileEntity te;
                    IItemHandler inventory = ItemTransferEventHandler.getInventory(tile, cfg.getExitFacing());
                    if (inventory == null) continue;
                    boolean hasFilter = !cfg.getFilter().isEmpty() && cfg.getFilter().stream().anyMatch(i -> !i.func_190926_b());
                    ItemStack stack = ItemStack.field_190927_a;
                    int slot = -1;
                    for (int i2 = 0; i2 < inventory.getSlots(); ++i2) {
                        stack = inventory.getStackInSlot(i2);
                        if (stack.func_190926_b() || hasFilter && !this.isInFilter(cfg.getFilter(), stack, cfg.filterByNBT())) continue;
                        stack = inventory.extractItem(i2, 1, true);
                        slot = i2;
                        break;
                    }
                    if (stack.func_190926_b() || slot <= -1 || (te = world.func_175625_s(exitPos = cfg.getRoute()[cfg.getRoute().length - 1])) == null || (exitInv = ItemTransferEventHandler.getInventory(te, cfg.getEntryFacing())) == null || !ItemHandlerHelper.insertItem((IItemHandler)exitInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    stack = inventory.extractItem(slot, 1, false);
                    BlockPos pos = tile.func_174877_v();
                    EntitySpiritItem spirit = new EntitySpiritItem(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
                    spirit.setRoute(cfg.getRoute());
                    spirit.setFacing(cfg.getEntryFacing());
                    world.func_72838_d((Entity)spirit);
                }
            });
        }
    }

    public static IItemHandler getInventory(TileEntity te, EnumFacing face) {
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        }
        if (te instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)te, face);
        }
        if (te instanceof IInventory) {
            return new InvWrapper((IInventory)te);
        }
        return null;
    }

    public static boolean hasInventory(TileEntity te) {
        return ItemTransferEventHandler.getInventory(te, EnumFacing.DOWN) != null;
    }

    private boolean hasCap(TileEntity te) {
        if (te.hasCapability(ItemTransferCapabilityProvider.ITEM_TRANSFER_CAP, null)) {
            IItemTransferCapability cap = ItemTransferCapability.getCap(te);
            return cap != null && cap.isRunning();
        }
        return false;
    }

    private boolean isInFilter(NonNullList<ItemStack> filter, ItemStack stack, boolean nbt) {
        for (ItemStack stack1 : filter) {
            if (!APIUtils.areStacksEqual(stack, stack1, nbt)) continue;
            return true;
        }
        return false;
    }
}

