/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity.ai;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.BlockACStone;
import com.shinoow.abyssalcraft.common.entity.EntityLesserShoggoth;
import com.shinoow.abyssalcraft.common.world.gen.WorldGenShoggothMonolith;
import com.shinoow.abyssalcraft.lib.ACConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAILesserShoggothBuildMonolith
extends EntityAIBase {
    private EntityLesserShoggoth shoggoth;
    private double locationX;
    private double locationY;
    private double locationZ;
    private final World world;
    private List<EntityLesserShoggoth> shoggoths;
    private int attemptTimer;

    public EntityAILesserShoggothBuildMonolith(EntityLesserShoggoth shoggoth) {
        this.shoggoth = shoggoth;
        this.world = shoggoth.field_70170_p;
        this.shoggoths = new ArrayList<EntityLesserShoggoth>();
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (ACConfig.monolithBuildingCooldown == 0) {
            return false;
        }
        if (this.shoggoth.func_70631_g_()) {
            return false;
        }
        if (this.shoggoth.isAssisting || this.shoggoth.isBuilding) {
            return false;
        }
        if (this.shoggoth.getMonolithTimer() < ACConfig.monolithBuildingCooldown) {
            return false;
        }
        if (this.world.func_175647_a(this.shoggoth.getClass(), this.shoggoth.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), e -> !e.equals(this.shoggoth) && !e.isAssisting && !e.isBuilding).size() < 3) {
            return false;
        }
        Vec3d vec3d = this.findPossibleLocation();
        if (vec3d == null) {
            return false;
        }
        List list = this.world.func_175647_a(this.shoggoth.getClass(), this.shoggoth.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), e -> !e.equals(this.shoggoth) && !e.isAssisting && !e.isBuilding);
        for (EntityLesserShoggoth shoggoth1 : list) {
            if (this.shoggoths.size() == 3) break;
            if (!(shoggoth1.func_70032_d((Entity)this.shoggoth) <= 12.0f)) continue;
            shoggoth1.reduceMonolithTimer();
            shoggoth1.isAssisting = true;
            this.shoggoths.add(shoggoth1);
        }
        if (this.shoggoths.size() != 3) {
            return false;
        }
        this.shoggoth.isBuilding = true;
        this.locationX = vec3d.field_72450_a;
        this.locationY = vec3d.field_72448_b;
        this.locationZ = vec3d.field_72449_c;
        return true;
    }

    public boolean func_75253_b() {
        if (!this.shoggoth.isBuilding) {
            return false;
        }
        if (this.attemptTimer >= 0) {
            return this.shoggoth.func_70011_f(this.locationX, this.locationY, this.locationZ) > 8.0 || !this.allShoggothsNearby();
        }
        return false;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        this.attemptTimer = 400;
        this.shoggoth.func_70661_as().func_75492_a(this.locationX + (double)(this.shoggoth.func_70681_au().nextBoolean() ? 3 : -3), this.locationY, this.locationZ + (double)(this.shoggoth.func_70681_au().nextBoolean() ? 3 : -3), 0.38);
        this.shoggoths.get(0).func_70661_as().func_75492_a(this.locationX - 3.0, this.locationY, this.locationZ - 3.0, 0.38);
        this.shoggoths.get(1).func_70661_as().func_75492_a(this.locationX + 3.0, this.locationY, this.locationZ + 3.0, 0.38);
        this.shoggoths.get(2).func_70661_as().func_75492_a(this.locationX + 3.0, this.locationY, this.locationZ - 3.0, 0.38);
    }

    public void func_75246_d() {
        --this.attemptTimer;
        if (this.shoggoth.func_70011_f(this.locationX, this.locationY, this.locationZ) <= 8.0 && this.allShoggothsNearby()) {
            this.shoggoth.resetMonolithTimer();
            for (EntityLesserShoggoth shoggoth : this.world.func_72872_a(this.shoggoth.getClass(), this.shoggoth.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0))) {
                if (!(shoggoth.func_70011_f(this.locationX, this.locationY, this.locationZ) <= 5.0)) continue;
                shoggoth.func_70661_as().func_75492_a(this.locationX + (double)(shoggoth.func_70681_au().nextBoolean() ? 7 : -7), shoggoth.field_70163_u, this.locationZ + (double)(shoggoth.func_70681_au().nextBoolean() ? 7 : -7), (double)0.7f);
            }
            if (!this.world.field_72995_K) {
                BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.locationX), MathHelper.func_76128_c((double)this.locationY), MathHelper.func_76128_c((double)this.locationZ));
                if (this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == ACBlocks.shoggoth_ooze) {
                    pos = pos.func_177977_b();
                }
                new WorldGenShoggothMonolith().func_180709_b(this.world, this.shoggoth.func_70681_au(), pos);
            }
            this.shoggoth.isBuilding = false;
        }
    }

    public void func_75251_c() {
        for (EntityLesserShoggoth shoggoth1 : this.shoggoths) {
            shoggoth1.isAssisting = false;
            shoggoth1.isBuilding = false;
        }
        this.shoggoths.clear();
        this.shoggoth.isAssisting = false;
        this.shoggoth.isBuilding = false;
        this.locationZ = 0.0;
        this.locationY = 0.0;
        this.locationX = 0.0;
    }

    private boolean allShoggothsNearby() {
        boolean temp = true;
        for (EntityLesserShoggoth shoggoth1 : this.shoggoths) {
            if (!(shoggoth1.func_70011_f(this.shoggoth.field_70165_t, this.shoggoth.field_70163_u, this.shoggoth.field_70161_v) > 8.0)) continue;
            temp = false;
        }
        return temp;
    }

    @Nullable
    private Vec3d findPossibleLocation() {
        Random random = this.shoggoth.func_70681_au();
        BlockPos blockpos = new BlockPos(this.shoggoth.field_70165_t, this.shoggoth.func_174813_aQ().field_72338_b, this.shoggoth.field_70161_v);
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.world.func_175623_d(blockpos1.func_177984_a()) || !this.world.func_175623_d(blockpos1.func_177981_b(1)) || !this.world.func_180495_p(blockpos1).func_177230_c().func_176200_f((IBlockAccess)this.world, blockpos1) || this.world.func_180495_p(blockpos1.func_177977_b()) == ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.MONOLITH_STONE)) || this.world.func_175623_d(blockpos1.func_177977_b()) || !this.world.func_180495_p(blockpos1.func_177977_b()).isSideSolid((IBlockAccess)this.world, blockpos1.func_177977_b(), EnumFacing.UP) || this.world.func_180495_p(blockpos1.func_177977_b()) == ACBlocks.shoggoth_biomass.func_176223_P()) continue;
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)blockpos1.func_177978_c().func_177976_e().func_177977_b(), (BlockPos)blockpos1.func_177968_d().func_177974_f().func_177984_a())) {
                if (this.world.func_180495_p(pos).func_177230_c() != ACBlocks.shoggoth_ooze) continue;
                return new Vec3d((Vec3i)pos);
            }
            return new Vec3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
        }
        return null;
    }
}

