/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.IOmotholEntity;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.entity.EntityGatekeeperMinion;
import com.shinoow.abyssalcraft.common.entity.ai.EntityAIWorship;
import com.shinoow.abyssalcraft.common.items.ItemDrainStaff;
import com.shinoow.abyssalcraft.common.items.ItemNecronomicon;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRemnant
extends EntityMob
implements IMerchant,
IOmotholEntity {
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(EntityRemnant.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityPlayer tradingPlayer;
    private MerchantRecipeList tradingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private int timer;
    private float field_82191_bN;
    public static final Map<Item, Tuple<Integer, Integer>> itemSellingList = new HashMap<Item, Tuple<Integer, Integer>>();
    public static final Map<Item, Tuple<Integer, Integer>> coinSellingList = new HashMap<Item, Tuple<Integer, Integer>>();

    public EntityRemnant(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.35, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityRemnant.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGatekeeperMinion.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWorship((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.2);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.func_184609_a(EnumHand.MAIN_HAND);
        this.func_184609_a(EnumHand.OFF_HAND);
        boolean flag = super.func_70652_k(par1Entity);
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 3.0f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    if (this.tradingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.tradingList) {
                            if (!merchantrecipe.func_82784_g() || merchantrecipe.func_77397_d().func_77973_b() == ACItems.configurator_shard) continue;
                            merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                        }
                    }
                    this.addDefaultEquipmentAndRecipies(1);
                    this.needsInitilization = false;
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer par1EntityPlayer, EnumHand hand) {
        if (this.func_70089_S() && !par1EntityPlayer.func_70093_af() && !this.isAngry()) {
            if (this.ownsTheirBook(par1EntityPlayer)) {
                if (!this.isTrading()) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70932_a_(par1EntityPlayer);
                        par1EntityPlayer.func_180472_a((IMerchant)this);
                        return true;
                    }
                } else if (!this.tradingPlayer.func_110124_au().equals(par1EntityPlayer.func_110124_au())) {
                    par1EntityPlayer.func_145747_a((ITextComponent)new TextComponentString(this.func_70005_c_() + ": " + I18n.func_74838_a((String)"message.remnant.busy")));
                }
            } else {
                this.insult(par1EntityPlayer);
                return true;
            }
        }
        return super.func_184645_a(par1EntityPlayer, hand);
    }

    private boolean ownsTheirBook(EntityPlayer player) {
        return player.field_71071_by.field_70462_a.stream().anyMatch(is -> is.func_77973_b() instanceof ItemNecronomicon && ((ItemNecronomicon)is.func_77973_b()).isOwner(player, (ItemStack)is));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)0);
    }

    private void insult(EntityPlayer player) {
        List players;
        int insultNum = this.field_70170_p.field_73012_v.nextInt(3);
        String insult = this.func_70005_c_() + ": " + String.format(this.getInsult(insultNum), player.func_70005_c_());
        String translated = this.func_70005_c_() + ": " + String.format(I18n.func_74838_a((String)("message.remnant.insult." + insultNum)), player.func_70005_c_());
        if (this.field_70170_p.field_72995_K && (players = this.field_70170_p.func_72872_a(EntityPlayer.class, player.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0))) != null) {
            for (EntityPlayer player1 : players) {
                if (EntityUtil.hasNecronomicon(player1)) {
                    player1.func_145747_a((ITextComponent)new TextComponentString(translated));
                    continue;
                }
                player1.func_145747_a((ITextComponent)new TextComponentString(insult));
            }
        }
    }

    private String getInsult(int num) {
        switch (num) {
            case 0: {
                return "%s, Aklo g'ai ftrr nfto lagln f'tifh mtli ot aishgft 'ai.";
            }
            case 1: {
                return "%s ukhoyah g'ka-dish-tu.";
            }
            case 2: {
                return "%s go-tha ukhoyah Necronomicon g'mnahn'.";
            }
        }
        return this.getInsult(0);
    }

    public void enrage(boolean call, EntityLivingBase enemy) {
        this.func_70624_b(enemy);
        this.enrage(call);
    }

    public void enrage(boolean call) {
        if (call) {
            List friends = this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
            if (friends != null) {
                Iterator iter = friends.iterator();
                while (iter.hasNext()) {
                    ((EntityRemnant)iter.next()).enrage(false, this.func_70638_az());
                }
            }
            this.func_184185_a(ACSounds.remnant_scream, 3.0f, 1.0f);
        }
        this.setAngry();
        this.setAttackAI();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
            if (this.func_70638_az() != par1DamageSource.func_76346_g()) {
                this.func_70624_b((EntityLivingBase)par1DamageSource.func_76346_g());
                this.enrage(true, this.func_70638_az());
            }
            if (!this.isAngry()) {
                this.enrage(true);
            } else {
                this.enrage(this.field_70146_Z.nextInt(10) == 0);
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAngry()) {
            this.setAttackAI();
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 0;
            }
        }
        if (!this.isAngry()) {
            this.clearAttackAI();
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Profession", this.getProfession());
        par1NBTTagCompound.func_74768_a("Money", this.wealth);
        par1NBTTagCompound.func_74768_a("AngerTimer", this.timer);
        if (this.tradingList != null) {
            par1NBTTagCompound.func_74782_a("Offers", (NBTBase)this.tradingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setProfession(par1NBTTagCompound.func_74762_e("Profession"));
        this.wealth = par1NBTTagCompound.func_74762_e("Money");
        this.timer = par1NBTTagCompound.func_74762_e("AngerTimer");
        if (par1NBTTagCompound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound1 = par1NBTTagCompound.func_74775_l("Offers");
            this.tradingList = new MerchantRecipeList(nbttagcompound1);
            this.tradingList.removeIf(r -> r.func_77397_d().func_190926_b());
        }
    }

    public boolean isAngry() {
        return this.timer > 0;
    }

    public void setAngry() {
        this.timer = 600;
    }

    private void clearAttackAI() {
        EntityAINearestAttackableTarget ai;
        if (this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if ((ai = this.fetchAI()) == null) {
            return;
        }
        this.field_70715_bh.func_85156_a((EntityAIBase)ai);
        if (this.field_70715_bh.field_75782_a.size() > 1) {
            this.clearAttackAI();
        }
    }

    private void setAttackAI() {
        if (this.func_70638_az() != null) {
            Class<?> temp = this.func_70638_az().getClass();
            EntityAINearestAttackableTarget ai = this.fetchAI();
            if (ai != null) {
                if (temp != ReflectionHelper.findField(ai.getClass(), (String[])new String[]{"targetClass", "field_75307_b"}).getDeclaringClass()) {
                    this.field_70715_bh.func_85156_a((EntityAIBase)ai);
                    this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, temp, true));
                }
            } else {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, temp, true));
            }
        }
    }

    private EntityAINearestAttackableTarget fetchAI() {
        for (EntityAITasks.EntityAITaskEntry entry : this.field_70715_bh.field_75782_a) {
            if (!(entry.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
            return (EntityAINearestAttackableTarget)entry.field_75733_a;
        }
        return null;
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getProfession()) {
            case 0: {
                return ACLoot.ENTITY_REMNANT;
            }
            case 1: {
                return ACLoot.ENTITY_REMNANT_LIBRARIAN;
            }
            case 2: {
                return ACLoot.ENTITY_REMNANT_PRIEST;
            }
            case 3: {
                return ACLoot.ENTITY_REMNANT_BLACKSMITH;
            }
            case 4: {
                return ACLoot.ENTITY_REMNANT_BUTCHER;
            }
            case 5: {
                return ACLoot.ENTITY_REMNANT_BANKER;
            }
            case 6: {
                return ACLoot.ENTITY_REMNANT_MASTER_BLACKSMITH;
            }
        }
        return ACLoot.ENTITY_REMNANT;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.getProfession() == 2 && this.field_70146_Z.nextBoolean() ? ACSounds.remnant_priest_chant : null;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.shadow_death;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void setProfession(int par1) {
        this.field_70180_af.func_187227_b(PROFESSION, (Object)par1);
    }

    public int getProfession() {
        return (Integer)this.field_70180_af.func_187225_a(PROFESSION);
    }

    public void func_70932_a_(EntityPlayer var1) {
        this.tradingPlayer = var1;
    }

    public EntityPlayer func_70931_l_() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer var1) {
        if (this.tradingList == null) {
            this.addDefaultEquipmentAndRecipies(1);
        }
        return this.tradingList;
    }

    private float adjustProbability(float par1) {
        float f1 = par1 + this.field_82191_bN;
        return f1 > 0.9f ? 0.9f - (f1 - 0.9f) : f1;
    }

    private void addDefaultEquipmentAndRecipies(int par1) {
        this.field_82191_bN = this.tradingList != null ? MathHelper.func_76129_c((float)this.tradingList.size()) * 0.2f : 0.0f;
        MerchantRecipeList list = new MerchantRecipeList();
        switch (this.getProfession()) {
            case 0: {
                EntityRemnant.addItemTrade(list, Items.field_151015_O, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityRemnant.addItemTrade(list, Item.func_150898_a((Block)Blocks.field_150325_L), this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, Items.field_151076_bf, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, Items.field_179566_aV, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityRemnant.addCoinTrade(list, Items.field_151025_P, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityRemnant.addCoinTrade(list, Items.field_151127_ba, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Items.field_151034_e, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Items.field_151106_aX, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, (Item)Items.field_151097_aZ, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Items.field_151033_d, this.field_70146_Z, this.adjustProbability(0.3f));
                if (ACConfig.foodstuff) {
                    EntityRemnant.addCoinTrade(list, ACItems.fish_on_a_plate, this.field_70146_Z, this.adjustProbability(0.3f));
                }
                EntityRemnant.addCoinTrade(list, Items.field_151032_g, this.field_70146_Z, this.adjustProbability(0.5f));
                if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.5f))) break;
                list.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150351_n, 10), new ItemStack(ACItems.elder_engraved_coin), new ItemStack(Items.field_151145_ak, 4 + this.field_70146_Z.nextInt(2), 0)));
                break;
            }
            case 1: {
                int k;
                EntityRemnant.addItemTrade(list, Items.field_151121_aF, this.field_70146_Z, this.adjustProbability(0.8f));
                EntityRemnant.addItemTrade(list, Items.field_151122_aG, this.field_70146_Z, this.adjustProbability(0.8f));
                EntityRemnant.addItemTrade(list, Items.field_151164_bB, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Item.func_150898_a((Block)Blocks.field_150342_X), this.field_70146_Z, this.adjustProbability(0.8f));
                EntityRemnant.addCoinTrade(list, Item.func_150898_a((Block)Blocks.field_150359_w), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, Items.field_151111_aL, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, Items.field_151113_aN, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.necronomicon, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, ACItems.abyssal_wasteland_necronomicon, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.dreadlands_necronomicon, this.field_70146_Z, this.adjustProbability(0.1f));
                if (this.field_70146_Z.nextFloat() < this.adjustProbability(0.1f)) {
                    k = 3 * (this.field_70146_Z.nextInt(10) + 1) + 1;
                    list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(ACItems.elder_engraved_coin, k), new ItemStack(ACItems.scroll, 1, 0)));
                }
                if (this.field_70146_Z.nextFloat() < this.adjustProbability(0.1f)) {
                    k = 3 * (this.field_70146_Z.nextInt(10) + 1) + 1;
                    list.add((Object)new MerchantRecipe(new ItemStack(ACItems.scroll, 1, 0), new ItemStack(ACItems.elder_engraved_coin, k), new ItemStack(ACItems.scroll, 1, 1)));
                }
                if (this.field_70146_Z.nextFloat() < this.adjustProbability(0.1f)) {
                    k = 3 * (this.field_70146_Z.nextInt(10) + 1) + 1;
                    list.add((Object)new MerchantRecipe(new ItemStack(ACItems.scroll, 1, 1), new ItemStack(ACItems.elder_engraved_coin, k), new ItemStack(ACItems.scroll, 1, 2)));
                }
                if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.07f))) break;
                Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(this.field_70146_Z);
                int i1 = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
                ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i1));
                k = 2 + this.field_70146_Z.nextInt(5 + i1 * 10) + 3 * i1;
                list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(ACItems.elder_engraved_coin, k), itemstack));
                break;
            }
            case 2: {
                Item[] aitem;
                int k;
                EntityRemnant.addCoinTrade(list, Items.field_151061_bv, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Items.field_151062_by, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, Items.field_151137_ax, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityRemnant.addCoinTrade(list, Item.func_150898_a((Block)Blocks.field_150426_aN), this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addItemTrade(list, Items.field_151078_bh, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, ACItems.coralium_plagued_flesh, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, ACItems.dread_fragment, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, ACItems.omothol_flesh, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, ACItems.rotten_anti_flesh, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, ACItems.ritual_charm, this.field_70146_Z, this.adjustProbability(0.4f));
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.cthulhu_charm, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.hastur_charm, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.jzahar_charm, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.azathoth_charm, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.nyarlathotep_charm, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.yog_sothoth_charm, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.shub_niggurath_charm, 1);
                EntityRemnant.addCoinTrade(list, ACItems.staff_of_rending, this.field_70146_Z, this.adjustProbability(0.1f));
                if (this.field_70146_Z.nextFloat() < this.adjustProbability(0.1f)) {
                    list.add((Object)new MerchantRecipe(new ItemStack(ACItems.scroll, 1, 3), ACItems.liquid_antimatter_bucket_stack, new ItemStack(ACItems.unique_scroll, 1, 0)));
                }
                if (this.field_70146_Z.nextFloat() < this.adjustProbability(0.1f)) {
                    list.add((Object)new MerchantRecipe(new ItemStack(ACItems.scroll, 1, 3), new ItemStack(ACItems.oblivion_catalyst), new ItemStack(ACItems.unique_scroll, 1, 1)));
                }
                Item[] aitem1 = aitem = new Item[]{ACItems.ethaxium_sword, ACItems.ethaxium_chestplate, ACItems.ethaxium_axe, ACItems.ethaxium_pickaxe, ACItems.ethaxium_shovel};
                int j = aitem.length;
                for (k = 0; k < j; ++k) {
                    Item item = aitem1[k];
                    if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.05f))) continue;
                    list.add((Object)new MerchantRecipe(new ItemStack(item, 1, 0), new ItemStack(ACItems.elder_engraved_coin, 2 + this.field_70146_Z.nextInt(3), 0), EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)new ItemStack(item, 1, 0), (int)(5 + this.field_70146_Z.nextInt(15)), (boolean)true)));
                }
                break;
            }
            case 3: {
                EntityRemnant.addItemTrade(list, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, ACItems.abyssalnite_ingot, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, ACItems.refined_coralium_ingot, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, ACItems.dreadium_ingot, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, ACItems.ethaxium_ingot, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_sword, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_axe, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_pickaxe, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_shovel, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_hoe, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_boots, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_helmet, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_chestplate, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_leggings, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.blank_engraving, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 0), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 1), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 2), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 3), this.field_70146_Z, this.adjustProbability(0.2f));
                break;
            }
            case 4: {
                EntityRemnant.addItemTrade(list, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, Items.field_151147_al, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, Items.field_151082_bd, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, Items.field_151076_bf, this.field_70146_Z, this.adjustProbability(0.5f));
                if (ACConfig.foodstuff) {
                    EntityRemnant.addCoinTrade(list, ACItems.washcloth, this.field_70146_Z, this.adjustProbability(0.4f));
                    EntityRemnant.addCoinTrade(list, ACItems.mre, this.field_70146_Z, this.adjustProbability(0.1f));
                    EntityRemnant.addCoinTrade(list, ACItems.pork_on_a_plate, this.field_70146_Z, this.adjustProbability(0.3f));
                    EntityRemnant.addCoinTrade(list, ACItems.beef_on_a_plate, this.field_70146_Z, this.adjustProbability(0.3f));
                    EntityRemnant.addCoinTrade(list, ACItems.chicken_on_a_plate, this.field_70146_Z, this.adjustProbability(0.3f));
                    break;
                }
                EntityRemnant.addCoinTrade(list, Items.field_151106_aX, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityRemnant.addCoinTrade(list, Items.field_151150_bK, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, Items.field_151158_bO, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Items.field_179560_bq, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, Items.field_151105_aU, this.field_70146_Z, this.adjustProbability(0.3f));
                break;
            }
            case 5: {
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.cthulhu_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.hastur_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.jzahar_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.azathoth_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.nyarlathotep_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.yog_sothoth_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 8, ACItems.shub_niggurath_engraved_coin, 1);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.cthulhu_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.hastur_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.jzahar_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.azathoth_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.nyarlathotep_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.yog_sothoth_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 16, ACItems.shub_niggurath_engraved_coin, 2);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.cthulhu_engraved_coin, 3);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.hastur_engraved_coin, 3);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.jzahar_engraved_coin, 3);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.azathoth_engraved_coin, 3);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.nyarlathotep_engraved_coin, 3);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.yog_sothoth_engraved_coin, 3);
                this.addCoinTrade(list, ACItems.elder_engraved_coin, 24, ACItems.shub_niggurath_engraved_coin, 3);
                break;
            }
            case 6: {
                EntityRemnant.addItemTrade(list, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityRemnant.addItemTrade(list, ACItems.abyssalnite_ingot, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, ACItems.refined_coralium_ingot, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, ACItems.dreadium_ingot, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addItemTrade(list, ACItems.ethaxium_ingot, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_sword, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_axe, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_pickaxe, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_shovel, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_hoe, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.plated_coralium_boots, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.dreadium_samurai_boots, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.plated_coralium_helmet, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.dreadium_samurai_helmet, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.plated_coralium_chestplate, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.dreadium_samurai_chestplate, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.plated_coralium_leggings, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.dreadium_samurai_leggings, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_boots, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_helmet, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_chestplate, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.ethaxium_leggings, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.cthulhu_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.hastur_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.jzahar_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.azathoth_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.nyarlathotep_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.yog_sothoth_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, ACItems.shub_niggurath_engraving, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 0), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 1), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 2), this.field_70146_Z, this.adjustProbability(0.2f));
                EntityRemnant.addCoinTrade(list, new ItemStack(ACItems.configurator_shard, 1, 3), this.field_70146_Z, this.adjustProbability(0.2f));
            }
        }
        if (list.isEmpty()) {
            EntityRemnant.addItemTrade(list, Items.field_151043_k, this.field_70146_Z, 1.0f);
        }
        Collections.shuffle(list);
        if (this.tradingList == null) {
            this.tradingList = new MerchantRecipeList();
        }
        for (int l = 0; l < par1 && l < list.size(); ++l) {
            this.addToListWithCheck(this.tradingList, (MerchantRecipe)list.get(l));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList var1) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public void func_70933_a(MerchantRecipe var1) {
        var1.func_77399_f();
        if (var1.func_77397_d().func_77973_b() instanceof ItemTool || var1.func_77397_d().func_77973_b() instanceof ItemArmor) {
            var1.func_77399_f();
            var1.func_77399_f();
            var1.func_77399_f();
        }
        if (var1.func_77397_d().func_77973_b() == ACItems.configurator_shard) {
            var1.func_77399_f();
        }
        if (var1.func_77394_a().func_77973_b() instanceof ItemNecronomicon || var1.func_77394_a().func_77973_b() instanceof ItemDrainStaff) {
            var1.func_82785_h();
        }
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(ACSounds.remnant_yes, this.func_70599_aP(), this.func_70647_i());
        if (this.hasSameIDsAs(var1, (MerchantRecipe)this.tradingList.get(this.tradingList.size() - 1))) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
        }
        if (APIUtils.isCoin(var1.func_77394_a())) {
            this.wealth += var1.func_77394_a().func_190916_E();
        }
    }

    private void addToListWithCheck(MerchantRecipeList list, MerchantRecipe recipe) {
        if (recipe.func_77397_d().func_190926_b()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MerchantRecipe merchantrecipe1 = (MerchantRecipe)list.get(i);
            if (!this.hasSameIDsAs(recipe, merchantrecipe1)) continue;
            if (this.hasSameItemsAs(recipe, merchantrecipe1)) {
                list.set(i, (Object)recipe);
            }
            return;
        }
        list.add((Object)recipe);
    }

    private boolean hasSameIDsAs(MerchantRecipe r1, MerchantRecipe r2) {
        return r1.func_77394_a().func_77973_b() == r2.func_77394_a().func_77973_b() && r1.func_77397_d().func_77973_b() == r2.func_77397_d().func_77973_b() ? r1.func_77396_b().func_190926_b() && r2.func_77396_b().func_190926_b() || !r1.func_77396_b().func_190926_b() && !r2.func_77396_b().func_190926_b() && r1.func_77396_b().func_77973_b() == r2.func_77396_b().func_77973_b() : false;
    }

    private boolean hasSameItemsAs(MerchantRecipe r1, MerchantRecipe r2) {
        return this.hasSameIDsAs(r1, r2) && (r1.func_77394_a().func_190916_E() < r2.func_77394_a().func_190916_E() || !r1.func_77396_b().func_190926_b() && r1.func_77396_b().func_190916_E() < r2.func_77396_b().func_190916_E());
    }

    public static void addItemTrade(MerchantRecipeList list, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            list.add((Object)new MerchantRecipe(EntityRemnant.getItemStackWithQuantity(item, rand), ACItems.elder_engraved_coin));
        }
    }

    private static ItemStack getItemStackWithQuantity(Item item, Random rand) {
        return new ItemStack(item, EntityRemnant.getQuantity(item, rand), 0);
    }

    private static int getQuantity(Item item, Random rand) {
        Tuple<Integer, Integer> tuple = itemSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + rand.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }

    public static void addCoinTrade(MerchantRecipeList list, Item item, Random rand, float probability) {
        EntityRemnant.addCoinTrade(list, new ItemStack(item), rand, probability);
    }

    public static void addCoinTrade(MerchantRecipeList list, ItemStack stack, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = EntityRemnant.getRarity(stack.func_77973_b(), rand);
            if (i < 0) {
                itemstack = new ItemStack(ACItems.elder_engraved_coin, 1, 0);
                itemstack1 = stack;
                itemstack1.func_190920_e(i);
            } else {
                itemstack = new ItemStack(ACItems.elder_engraved_coin, i, 0);
                itemstack1 = stack;
                itemstack1.func_190920_e(1);
            }
            if (stack.func_77973_b() == ACItems.configurator_shard) {
                list.add((Object)new MerchantRecipe(itemstack, ItemStack.field_190927_a, itemstack1, 0, 1));
            } else {
                list.add((Object)new MerchantRecipe(itemstack, itemstack1));
            }
        }
    }

    private static int getRarity(Item par1, Random par2) {
        Tuple<Integer, Integer> tuple = coinSellingList.get(par1);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + par2.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            if (!par1ItemStack.func_190926_b()) {
                this.func_184185_a(ACSounds.remnant_yes, this.func_70599_aP(), this.func_70647_i());
            } else {
                this.func_184185_a(ACSounds.remnant_no, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public void addCoinTrade(MerchantRecipeList list, Item buy, int q1, Item sell, int q2) {
        this.addCoinTrade(list, new ItemStack(buy, q1), new ItemStack(sell, q2));
    }

    public void addCoinTrade(MerchantRecipeList list, Item buy1, int q1, Item buy2, int q2, Item sell, int q3) {
        this.addCoinTrade(list, new ItemStack(buy1, q1), new ItemStack(buy2, q2), new ItemStack(sell, q3));
    }

    public void addCoinTrade(MerchantRecipeList list, ItemStack buy, ItemStack sell) {
        this.addCoinTrade(list, buy, ItemStack.field_190927_a, sell);
    }

    public void addCoinTrade(MerchantRecipeList list, ItemStack buy1, ItemStack buy2, ItemStack sell) {
        list.add((Object)new MerchantRecipe(buy1, buy2, sell));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        Calendar calendar;
        data = super.func_180482_a(difficulty, data);
        this.applyRandomTrade(this.field_70170_p.field_73012_v);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        return data;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.9f;
    }

    public void applyRandomTrade(Random rand) {
        int trade = rand.nextInt(7);
        this.setProfession(trade);
    }

    static {
        itemSellingList.put(Items.field_151044_h, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)24));
        itemSellingList.put(ACItems.abyssalnite_ingot, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        itemSellingList.put(ACItems.refined_coralium_ingot, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        itemSellingList.put(ACItems.dreadium_ingot, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        itemSellingList.put(ACItems.ethaxium_ingot, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        itemSellingList.put(Items.field_151121_aF, (Tuple<Integer, Integer>)new Tuple((Object)24, (Object)36));
        itemSellingList.put(Items.field_151122_aG, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)13));
        itemSellingList.put(Items.field_151164_bB, (Tuple<Integer, Integer>)new Tuple((Object)1, (Object)1));
        itemSellingList.put(Items.field_151079_bi, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        itemSellingList.put(Items.field_151061_bv, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)3));
        itemSellingList.put(Items.field_151147_al, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        itemSellingList.put(Items.field_151082_bd, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        itemSellingList.put(Items.field_151076_bf, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        itemSellingList.put(Items.field_179566_aV, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)13));
        itemSellingList.put(Items.field_151014_N, (Tuple<Integer, Integer>)new Tuple((Object)34, (Object)48));
        itemSellingList.put(Items.field_151081_bc, (Tuple<Integer, Integer>)new Tuple((Object)30, (Object)38));
        itemSellingList.put(Items.field_151080_bb, (Tuple<Integer, Integer>)new Tuple((Object)30, (Object)38));
        itemSellingList.put(Items.field_151015_O, (Tuple<Integer, Integer>)new Tuple((Object)18, (Object)22));
        itemSellingList.put(Item.func_150898_a((Block)Blocks.field_150325_L), (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)22));
        itemSellingList.put(Items.field_151078_bh, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)28));
        itemSellingList.put(ACItems.coralium_plagued_flesh, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)28));
        itemSellingList.put(ACItems.dread_fragment, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)28));
        itemSellingList.put(ACItems.omothol_flesh, (Tuple<Integer, Integer>)new Tuple((Object)32, (Object)60));
        itemSellingList.put(ACItems.rotten_anti_flesh, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)14));
        coinSellingList.put(Items.field_151033_d, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        coinSellingList.put((Item)Items.field_151097_aZ, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        coinSellingList.put(ACItems.ethaxium_sword, (Tuple<Integer, Integer>)new Tuple((Object)12, (Object)14));
        coinSellingList.put(ACItems.ethaxium_axe, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)12));
        coinSellingList.put(ACItems.ethaxium_pickaxe, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        coinSellingList.put(ACItems.ethaxium_shovel, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        coinSellingList.put(ACItems.ethaxium_hoe, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        coinSellingList.put(ACItems.ethaxium_boots, (Tuple<Integer, Integer>)new Tuple((Object)5, (Object)7));
        coinSellingList.put(ACItems.ethaxium_helmet, (Tuple<Integer, Integer>)new Tuple((Object)5, (Object)7));
        coinSellingList.put(ACItems.ethaxium_chestplate, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)15));
        coinSellingList.put(ACItems.ethaxium_leggings, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)11));
        coinSellingList.put(Items.field_151025_P, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-2));
        coinSellingList.put(Items.field_151127_ba, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-4));
        coinSellingList.put(Items.field_151034_e, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-4));
        coinSellingList.put(Items.field_151106_aX, (Tuple<Integer, Integer>)new Tuple((Object)-10, (Object)-7));
        coinSellingList.put(Item.func_150898_a((Block)Blocks.field_150359_w), (Tuple<Integer, Integer>)new Tuple((Object)-5, (Object)-3));
        coinSellingList.put(Item.func_150898_a((Block)Blocks.field_150342_X), (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        coinSellingList.put(ACItems.washcloth, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        coinSellingList.put(ACItems.mre, (Tuple<Integer, Integer>)new Tuple((Object)6, (Object)8));
        coinSellingList.put(Items.field_151062_by, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-1));
        coinSellingList.put(Items.field_151137_ax, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-1));
        coinSellingList.put(Items.field_151111_aL, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        coinSellingList.put(Items.field_151113_aN, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        coinSellingList.put(ACItems.necronomicon, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        coinSellingList.put(ACItems.abyssal_wasteland_necronomicon, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        coinSellingList.put(ACItems.dreadlands_necronomicon, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        coinSellingList.put(Item.func_150898_a((Block)Blocks.field_150426_aN), (Tuple<Integer, Integer>)new Tuple((Object)-3, (Object)-1));
        coinSellingList.put(ACItems.pork_on_a_plate, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        coinSellingList.put(ACItems.beef_on_a_plate, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        coinSellingList.put(ACItems.chicken_on_a_plate, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        coinSellingList.put(ACItems.fish_on_a_plate, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        coinSellingList.put(Items.field_151077_bg, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-6));
        coinSellingList.put(Items.field_151061_bv, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)11));
        coinSellingList.put(Items.field_151032_g, (Tuple<Integer, Integer>)new Tuple((Object)-12, (Object)-8));
        coinSellingList.put(ACItems.plated_coralium_boots, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        coinSellingList.put(ACItems.dreadium_samurai_boots, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        coinSellingList.put(ACItems.plated_coralium_helmet, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        coinSellingList.put(ACItems.dreadium_samurai_helmet, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        coinSellingList.put(ACItems.plated_coralium_chestplate, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)14));
        coinSellingList.put(ACItems.dreadium_samurai_chestplate, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)19));
        coinSellingList.put(ACItems.plated_coralium_leggings, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        coinSellingList.put(ACItems.dreadium_samurai_leggings, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)14));
        coinSellingList.put(ACItems.staff_of_rending, (Tuple<Integer, Integer>)new Tuple((Object)20, (Object)25));
        coinSellingList.put(ACItems.configurator_shard, (Tuple<Integer, Integer>)new Tuple((Object)64, (Object)64));
    }
}

