/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.transfer.caps;

import com.shinoow.abyssalcraft.api.transfer.ItemTransferConfiguration;
import com.shinoow.abyssalcraft.api.transfer.caps.IItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapabilityProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class ItemTransferCapability
implements IItemTransferCapability {
    private List<ItemTransferConfiguration> configurations = new ArrayList<ItemTransferConfiguration>();
    private boolean isRunning;

    public static IItemTransferCapability getCap(TileEntity tile) {
        return (IItemTransferCapability)tile.getCapability(ItemTransferCapabilityProvider.ITEM_TRANSFER_CAP, null);
    }

    @Override
    public void addTransferConfiguration(ItemTransferConfiguration config) {
        if (!this.configurations.stream().anyMatch(c -> c.equals(config))) {
            this.configurations.add(config);
        }
    }

    @Override
    public List<ItemTransferConfiguration> getTransferConfigurations() {
        return this.configurations;
    }

    @Override
    public void clearConfigurations() {
        this.configurations.clear();
    }

    @Override
    public void setRunning(boolean state) {
        this.isRunning = state;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void copy(IItemTransferCapability cap) {
        this.configurations = cap.getTransferConfigurations();
    }
}

