/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.util.WootMob;
import ipsis.woot.util.WootMobName;
import ipsis.woot.util.WootMobNameBuilder;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;

public class WootMobBuilder {
    private static final String NBT_WOOT_MOB_DISPLAY_NAME = "wootMobDisplayName";
    private static final String NBT_WOOT_MOB_DEATHS = "wootMobDeaths";

    @Nonnull
    public static WootMob create(String name, String displayName) {
        WootMobName wootMobName = WootMobNameBuilder.create(name);
        return new WootMob(wootMobName, displayName);
    }

    @Nonnull
    public static WootMob create(@Nonnull EntityLiving entityLiving) {
        WootMobName wootMobName = WootMobNameBuilder.create(entityLiving);
        return new WootMob(wootMobName, entityLiving.func_70005_c_());
    }

    public static void writeToNBT(WootMob wootMob, NBTTagCompound tagCompound) {
        if (!wootMob.isValid()) {
            return;
        }
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a(NBT_WOOT_MOB_DISPLAY_NAME, wootMob.getDisplayName());
        tagCompound.func_74768_a(NBT_WOOT_MOB_DEATHS, wootMob.getDeaths());
        WootMobNameBuilder.writeToNBT(wootMob.getWootMobName(), tagCompound);
    }

    @Nonnull
    public static WootMob create(NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74764_b(NBT_WOOT_MOB_DISPLAY_NAME) || !tagCompound.func_74764_b(NBT_WOOT_MOB_DEATHS)) {
            return new WootMob();
        }
        return new WootMob(WootMobNameBuilder.create(tagCompound), tagCompound.func_74779_i(NBT_WOOT_MOB_DISPLAY_NAME), tagCompound.func_74762_e(NBT_WOOT_MOB_DEATHS));
    }
}

