/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.power.calculation.upgrades;

import ipsis.Woot;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.power.calculation.upgrades.BloodMagicAltar;
import ipsis.woot.power.calculation.upgrades.BloodMagicCrystal;
import ipsis.woot.power.calculation.upgrades.BloodMagicTank;
import ipsis.woot.power.calculation.upgrades.Decapitate;
import ipsis.woot.power.calculation.upgrades.Efficiency;
import ipsis.woot.power.calculation.upgrades.EvilCraftBlood;
import ipsis.woot.power.calculation.upgrades.IUpgradePowerCalculator;
import ipsis.woot.power.calculation.upgrades.Looting;
import ipsis.woot.power.calculation.upgrades.Mass;
import ipsis.woot.power.calculation.upgrades.Rate;
import ipsis.woot.power.calculation.upgrades.Xp;
import ipsis.woot.util.DebugSetup;
import java.util.ArrayList;
import java.util.List;

public class CalculatorRepository {
    private List<IUpgradePowerCalculator> calculators = new ArrayList<IUpgradePowerCalculator>();

    public CalculatorRepository() {
        this.calculators.add(new Decapitate());
        this.calculators.add(new Efficiency());
        this.calculators.add(new Looting());
        this.calculators.add(new Mass());
        this.calculators.add(new Rate());
        this.calculators.add(new Xp());
        this.calculators.add(new BloodMagicAltar());
        this.calculators.add(new BloodMagicTank());
        this.calculators.add(new BloodMagicCrystal());
        this.calculators.add(new EvilCraftBlood());
    }

    public List<IUpgradePowerCalculator> getAllCalculators() {
        return this.calculators;
    }

    public List<IUpgradePowerCalculator> getActiveCalculators(IFarmSetup iFarmSetup) {
        ArrayList<IUpgradePowerCalculator> calculatorList = new ArrayList<IUpgradePowerCalculator>();
        for (IUpgradePowerCalculator c : this.calculators) {
            if (!c.isActive(iFarmSetup)) continue;
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "getActiveCalculators", "added:" + c);
            calculatorList.add(c);
        }
        return calculatorList;
    }
}

