/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farmstructure;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactoryHeart;
import ipsis.woot.farmblocks.IFactoryGlue;
import ipsis.woot.farmblocks.IFactoryGlueProvider;
import ipsis.woot.farmblocks.IFarmBlockMaster;
import ipsis.woot.farming.ITickTracker;
import ipsis.woot.farmstructure.FarmScanner2;
import ipsis.woot.farmstructure.FarmSetup;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.farmstructure.IFarmStructure;
import ipsis.woot.farmstructure.ScannedFarm2;
import ipsis.woot.farmstructure.ScannedFarmUpgrade;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.EnumFarmUpgrade;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmBuilder
implements IFarmStructure {
    private boolean farmDirty = false;
    private boolean proxyDirty = false;
    private World world;
    private BlockPos origin;
    private boolean changed = false;
    private ScannedFarm2 currFarm;

    private void disconnectOldFarm(@Nullable ScannedFarm2 oldFarm, ScannedFarm2 newFarm) {
        if (oldFarm == null) {
            return;
        }
        HashSet<BlockPos> oldBlocks = new HashSet<BlockPos>();
        oldBlocks.addAll(oldFarm.base.getBlocks());
        oldBlocks.add(oldFarm.controller.getBlocks());
        oldBlocks.addAll(oldFarm.upgrades.getBlocks());
        oldBlocks.addAll(oldFarm.remote.getBlocks());
        HashSet<BlockPos> newBlocks = new HashSet<BlockPos>();
        if (newFarm != null) {
            newBlocks.addAll(newFarm.base.getBlocks());
            newBlocks.add(newFarm.controller.getBlocks());
            newBlocks.addAll(newFarm.upgrades.getBlocks());
            newBlocks.addAll(newFarm.remote.getBlocks());
        }
        oldBlocks.removeAll(newBlocks);
        for (BlockPos pos : oldBlocks) {
            TileEntity te;
            if (!this.world.func_175667_e(pos) || !((te = this.world.func_175625_s(pos)) instanceof IFactoryGlueProvider)) continue;
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_CLIENT_SYNC, "clearMaster", pos);
            ((IFactoryGlueProvider)te).getIFactoryGlue().clearMaster();
        }
    }

    private void connectNewFarm(ScannedFarm2 oldFarm, ScannedFarm2 newFarm) {
        IFarmBlockMaster master = (IFarmBlockMaster)this.world.func_175625_s(this.origin);
        HashSet<BlockPos> oldBlocks = new HashSet<BlockPos>();
        if (oldFarm != null) {
            oldBlocks.addAll(oldFarm.base.getBlocks());
            oldBlocks.add(oldFarm.controller.getBlocks());
            oldBlocks.addAll(oldFarm.upgrades.getBlocks());
            oldBlocks.addAll(oldFarm.remote.getBlocks());
        }
        HashSet<BlockPos> newBlocks = new HashSet<BlockPos>();
        newBlocks.addAll(newFarm.base.getBlocks());
        newBlocks.add(newFarm.controller.getBlocks());
        newBlocks.addAll(newFarm.upgrades.getBlocks());
        newBlocks.addAll(newFarm.remote.getBlocks());
        newBlocks.removeAll(oldBlocks);
        for (BlockPos pos : newBlocks) {
            if (!this.world.func_175667_e(pos)) continue;
            TileEntity te = this.world.func_175625_s(pos);
            if (te instanceof IFactoryGlueProvider && ((IFactoryGlueProvider)te).getIFactoryGlue().getType() == IFactoryGlue.FactoryBlockType.UPGRADE) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_BUILD, "connectNewFarm: connecting upgrade", "");
            }
            if (!(te instanceof IFactoryGlueProvider)) continue;
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_CLIENT_SYNC, "setMaster", pos);
            ((IFactoryGlueProvider)te).getIFactoryGlue().setMaster(master);
        }
    }

    @Nullable
    private ScannedFarm2 scanFarm() {
        FarmScanner2 farmScanner = new FarmScanner2();
        EnumFacing facing = (EnumFacing)this.world.func_180495_p(this.origin).func_177229_b((IProperty)BlockMobFactoryHeart.FACING);
        ScannedFarm2 scannedFarm = farmScanner.scanFarm(this.world, this.origin, facing);
        if (!scannedFarm.isValidStructure() || !scannedFarm.isValidCofiguration(this.world)) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_BUILD, "scanFullFarm: invalid farm", "");
            return null;
        }
        return scannedFarm;
    }

    private void handleDirtyFarm() {
        ScannedFarm2 scannedFarm = this.scanFarm();
        if (this.currFarm != null || scannedFarm != null) {
            if (this.currFarm == null && scannedFarm != null) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_BUILD, "handleDirtyFarm: new farm", "");
                this.connectNewFarm(this.currFarm, scannedFarm);
                this.currFarm = scannedFarm;
                this.changed = true;
            } else if (this.currFarm != null && scannedFarm == null) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_BUILD, "handleDirtyFarm: goodbye farm", "");
                this.disconnectOldFarm(this.currFarm, scannedFarm);
                this.currFarm = null;
            } else if (this.currFarm != null && scannedFarm != null && !ScannedFarm2.areFarmsEqual(this.currFarm, scannedFarm)) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_BUILD, "handleDirtyFarm: changed farm", "");
                this.disconnectOldFarm(this.currFarm, scannedFarm);
                this.connectNewFarm(this.currFarm, scannedFarm);
                this.currFarm = scannedFarm;
                this.changed = true;
            }
        }
    }

    private void handleDirtyProxy() {
        this.handleDirtyFarm();
    }

    @Override
    public void setStructureDirty() {
        this.farmDirty = true;
    }

    @Override
    public void setUpgradeDirty() {
        this.setStructureDirty();
    }

    @Override
    public IFarmStructure setWorld(@Nonnull World world) {
        this.world = world;
        return this;
    }

    @Override
    public IFarmStructure setPosition(BlockPos origin) {
        this.origin = origin;
        return this;
    }

    @Override
    public void tick(ITickTracker tickTracker) {
        if (tickTracker.hasStructureTickExpired()) {
            if (this.farmDirty) {
                this.handleDirtyFarm();
                tickTracker.resetStructureTickCount();
                this.farmDirty = false;
            } else if (this.proxyDirty) {
                this.handleDirtyProxy();
                tickTracker.resetStructureTickCount();
                this.proxyDirty = false;
            }
        }
    }

    @Override
    public IFarmSetup createSetup() {
        FarmSetup farmSetup = new FarmSetup(this.world, this.currFarm.controller.wootMob);
        farmSetup.setFarmTier(this.currFarm.base.tier);
        for (ScannedFarmUpgrade.Upgrade u : this.currFarm.upgrades.getUpgrades()) {
            farmSetup.setUpgradeLevel(u.upgrade, u.upgradeTier);
        }
        int level = farmSetup.getUpgradeLevel(EnumFarmUpgrade.LOOTING);
        if (level == 1) {
            farmSetup.setEnchantKey(EnumEnchantKey.LOOTING_I);
        } else if (level == 2) {
            farmSetup.setEnchantKey(EnumEnchantKey.LOOTING_II);
        } else if (level == 3) {
            farmSetup.setEnchantKey(EnumEnchantKey.LOOTING_III);
        }
        farmSetup.setFacing((EnumFacing)this.world.func_180495_p(this.origin).func_177229_b((IProperty)BlockMobFactoryHeart.FACING));
        farmSetup.setPowerCellBlockPos(this.currFarm.remote.getPowerPos());
        farmSetup.setExportBlockPos(this.currFarm.remote.getExportPos());
        farmSetup.setImportBlockPos(this.currFarm.remote.getImportPos());
        return farmSetup;
    }

    @Override
    public boolean isFormed() {
        return this.currFarm != null;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void clearChanged() {
        this.changed = false;
    }

    @Override
    public void fullDisconnect() {
        if (this.currFarm == null) {
            return;
        }
        HashSet<BlockPos> oldBlocks = new HashSet<BlockPos>();
        oldBlocks.addAll(this.currFarm.base.getBlocks());
        oldBlocks.add(this.currFarm.controller.getBlocks());
        oldBlocks.addAll(this.currFarm.upgrades.getBlocks());
        oldBlocks.addAll(this.currFarm.remote.getBlocks());
        for (BlockPos pos : oldBlocks) {
            TileEntity te;
            if (!this.world.func_175667_e(pos) || !((te = this.world.func_175625_s(pos)) instanceof IFactoryGlueProvider)) continue;
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.FARM_CLIENT_SYNC, "clearMaster", pos);
            ((IFactoryGlueProvider)te).getIFactoryGlue().clearMaster();
        }
    }
}

