/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farming;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.farming.IRecipeProgressTracker;
import ipsis.woot.farming.PowerRecipe;
import ipsis.woot.power.storage.IPowerStation;
import net.minecraft.util.math.MathHelper;

public class SimpleRecipeProgressTracker
implements IRecipeProgressTracker {
    private IPowerStation powerStation;
    private PowerRecipe powerRecipe;
    private long consumedPower = 0L;

    @Override
    public void tick() {
        int consumed = this.powerStation.consume(this.powerRecipe.getPowerPerTick());
        if (Woot.wootConfiguration.getBoolean(EnumConfigKey.STRICT_POWER)) {
            if (consumed >= this.powerRecipe.getPowerPerTick()) {
                this.consumedPower += (long)consumed;
            }
        } else {
            this.consumedPower += (long)consumed;
        }
    }

    @Override
    public boolean isComplete() {
        return this.consumedPower >= this.powerRecipe.getTotalPower();
    }

    @Override
    public int getProgress() {
        int p = (int)(100.0 / (double)this.powerRecipe.getTotalPower() * (double)this.consumedPower);
        return MathHelper.func_76125_a((int)p, (int)0, (int)100);
    }

    @Override
    public void reset() {
        this.consumedPower = 0L;
    }

    @Override
    public void setPowerRecipe(PowerRecipe powerRecipe) {
        this.powerRecipe = powerRecipe;
        this.consumedPower = 0L;
    }

    @Override
    public void setPowerStation(IPowerStation powerStation) {
        this.powerStation = powerStation;
    }

    @Override
    public long getConsumedPower() {
        return this.consumedPower;
    }

    @Override
    public void setConsumedPower(long power) {
        this.consumedPower = power;
    }
}

