/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.configuration.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.Woot;
import ipsis.woot.oss.FileUtils;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.JsonHelper;
import ipsis.woot.util.WootMobName;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

public class CustomDropsLoader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final int VERSION = 1;

    public void loadConfig() {
        try {
            String configText = FileUtils.copyConfigFileFromJar("custom_drops.json", false);
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193837_a((Gson)GSON, (String)configText, JsonObject.class, (boolean)false);
            this.parseConfig(jsonObject);
        }
        catch (Exception e) {
            LogHelper.error("Could not load custom loot config from " + FileUtils.getConfigFile("custom_drops.json").getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void parseConfig(JsonObject json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        int version = JsonUtils.func_151208_a((JsonObject)json, (String)"version", (int)-1);
        if (version == -1 || version != 1) {
            throw new JsonSyntaxException("Invalid version");
        }
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"mobs")) {
            this.parseMob(ele);
        }
    }

    private void parseMob(JsonElement ele) {
        if (ele == null || !ele.isJsonObject()) {
            throw new JsonSyntaxException("Mobs must be an objects");
        }
        JsonObject mobObject = (JsonObject)ele;
        WootMobName wootMobName = JsonHelper.getWootMobName(mobObject);
        if (wootMobName.isValid()) {
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)mobObject, (String)"drops")) {
                if (ele2 == null || !ele.isJsonObject()) {
                    throw new JsonSyntaxException("Drops must be objects");
                }
                JsonObject dropObject = (JsonObject)ele2;
                ItemStack itemStack = JsonHelper.getItemStack(dropObject.getAsJsonObject("drop"));
                if (itemStack.func_190926_b()) {
                    LogHelper.info("Ignoring invalid itemstack");
                    continue;
                }
                JsonArray sizesArray = JsonUtils.func_151214_t((JsonObject)dropObject, (String)"sizes");
                if (sizesArray.size() != 4) {
                    throw new JsonSyntaxException("Sizes must contain 4 entries");
                }
                ArrayList<Integer> sizes = new ArrayList<Integer>(4);
                for (JsonElement jsonElement : sizesArray) {
                    sizes.add(jsonElement.getAsInt());
                }
                JsonArray chancesArray = JsonUtils.func_151214_t((JsonObject)dropObject, (String)"chances");
                if (chancesArray.size() != 4) {
                    throw new JsonSyntaxException("Chances must contain 4 entries");
                }
                ArrayList<Integer> chances = new ArrayList<Integer>(4);
                for (JsonElement jsonElement : chancesArray) {
                    chances.add(jsonElement.getAsInt());
                }
                Woot.customDropsRepository.addDrop(wootMobName, itemStack, chances, sizes);
            }
        }
    }
}

