/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks;

import java.util.ArrayList;
import mod.flatcoloredblocks.CreativeTab;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.BlockHSVConfiguration;
import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.block.ItemBlockFlatColored;
import mod.flatcoloredblocks.client.ClientSide;
import mod.flatcoloredblocks.client.DummyClientSide;
import mod.flatcoloredblocks.client.IClientSide;
import mod.flatcoloredblocks.commands.ExportFCBlockList;
import mod.flatcoloredblocks.config.ModConfig;
import mod.flatcoloredblocks.craftingitem.FlatColoredBlockRecipe;
import mod.flatcoloredblocks.craftingitem.ItemColoredBlockCrafter;
import mod.flatcoloredblocks.gui.GuiScreenStartup;
import mod.flatcoloredblocks.gui.ModGuiRouter;
import mod.flatcoloredblocks.integration.IntegerationJEI;
import mod.flatcoloredblocks.network.NetworkRouter;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(name="FlatColoredBlocks", modid="flatcoloredblocks", acceptedMinecraftVersions="[1.12]", version="mc1.12-6.8", dependencies="required-after:forge@[14.21.1.2387,)", guiFactory="mod.flatcoloredblocks.gui.ConfigGuiFactory")
public class FlatColoredBlocks {
    public static FlatColoredBlocks instance;
    public static final String MODNAME = "FlatColoredBlocks";
    public static final String MODID = "flatcoloredblocks";
    public static final String VERSION = "mc1.12-6.8";
    public static final String DEPENDENCIES = "required-after:forge@[14.21.1.2387,)";
    public CreativeTab creativeTab;
    public ModConfig config;
    public ItemColoredBlockCrafter itemColoredBlockCrafting;
    public final IntegerationJEI jei = new IntegerationJEI();
    private IClientSide clientSide;
    public BlockHSVConfiguration normal;
    public BlockHSVConfiguration transparent;
    public BlockHSVConfiguration glowing;
    ArrayList<BlockFlatColored> blocks = new ArrayList();
    ArrayList<ItemBlockFlatColored> items = new ArrayList();

    public FlatColoredBlocks() {
        instance = this;
    }

    public int getFullNumberOfShades() {
        return this.normal.getNumberOfShades() + this.transparent.getNumberOfShades() * FlatColoredBlocks.instance.config.TRANSPARENCY_SHADES + this.glowing.getNumberOfShades() * FlatColoredBlocks.instance.config.GLOWING_SHADES;
    }

    public int getFullNumberOfBlocks() {
        return this.normal.getNumberOfBlocks() + this.transparent.getNumberOfBlocks() * FlatColoredBlocks.instance.config.TRANSPARENCY_SHADES + this.glowing.getNumberOfBlocks() * FlatColoredBlocks.instance.config.GLOWING_SHADES;
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        this.config = new ModConfig(event.getSuggestedConfigurationFile());
        this.initHSVFromConfiguration(this.config);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.clientSide = ClientSide.instance;
            ClientCommandHandler.instance.func_71560_a((ICommand)new ExportFCBlockList());
        } else {
            this.clientSide = new DummyClientSide();
        }
        this.initVersionChecker();
        this.creativeTab = new CreativeTab();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.initRegistration();
        this.clientSide.preinit();
    }

    public void initHSVFromConfiguration(ModConfig config) {
        this.normal = new BlockHSVConfiguration(EnumFlatBlockType.NORMAL, config);
        this.transparent = new BlockHSVConfiguration(EnumFlatBlockType.TRANSPARENT, config);
        this.glowing = new BlockHSVConfiguration(EnumFlatBlockType.GLOWING, config);
    }

    void initRegistration() {
        BlockHSVConfiguration[] configs;
        this.items.clear();
        this.blocks.clear();
        this.itemColoredBlockCrafting = new ItemColoredBlockCrafter();
        this.itemColoredBlockCrafting.setRegistryName(MODID, "coloredcraftingitem");
        for (BlockHSVConfiguration hsvconfig : configs = new BlockHSVConfiguration[]{this.normal, this.transparent, this.glowing}) {
            for (int v = 0; v < hsvconfig.MAX_SHADE_VARIANT; ++v) {
                for (int x = 0; x < hsvconfig.getNumberOfBlocks(); ++x) {
                    int offset = x * 16;
                    BlockFlatColored cb = BlockFlatColored.construct(hsvconfig, offset, v);
                    ItemBlockFlatColored cbi = new ItemBlockFlatColored(cb);
                    String regName = hsvconfig.getBlockName(v) + x;
                    cb.setRegistryName(MODID, regName);
                    cbi.setRegistryName(MODID, regName);
                    this.blocks.add(cb);
                    this.items.add(cbi);
                    if (this.config.ShowBlocksInJEI) continue;
                    this.jei.blackListBlock((Item)cbi);
                }
            }
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> registry) {
        for (BlockFlatColored block : this.blocks) {
            registry.getRegistry().register((IForgeRegistryEntry)block);
            this.clientSide.configureBlockRender(block, null);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> registry) {
        registry.getRegistry().register((IForgeRegistryEntry)this.itemColoredBlockCrafting);
        this.clientSide.configureCraftingRender(this.itemColoredBlockCrafting);
        for (ItemBlockFlatColored item : this.items) {
            registry.getRegistry().register((IForgeRegistryEntry)item);
            this.clientSide.configureBlockRender(null, item);
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> registry) {
        if (this.config.allowCraftingTable) {
            registry.getRegistry().register((IForgeRegistryEntry)new FlatColoredBlockRecipe());
        }
    }

    private void initVersionChecker() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "flat-colored-blocks");
        compound.func_74778_a("curseFilenameParser", "flatcoloredblocks-[].jar");
        FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        this.clientSide.init();
        NetworkRouter.instance = new NetworkRouter();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ModGuiRouter());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void openMainMenu(GuiOpenEvent event) {
        if (this.config.LAST_MAX_SHADES != instance.getFullNumberOfShades() && event.getGui() != null && event.getGui().getClass() == GuiMainMenu.class) {
            event.setGui((GuiScreen)new GuiScreenStartup());
        }
    }
}

