/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.items.ItemPhoenixDown;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;

public class ItemAngelicFeather
extends ItemBase {
    public ItemAngelicFeather() {
        super("angelic_feather");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(EntityPlayer player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.field_76379_h && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, ModItems.angelicFeather) && player.field_70143_R > 0.0f;
            }

            @Override
            public boolean apply(EntityPlayer player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)Settings.Items.AngelicFeather.hungerCostPercent / 100.0f);
                player.func_71020_j(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    ItemAngelicFeather(String name) {
        super(name);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        int potency;
        int n = potency = this instanceof ItemPhoenixDown ? Settings.Items.PhoenixDown.leapingPotency : Settings.Items.AngelicFeather.leapingPotency;
        if (potency == 0) {
            return;
        }
        --potency;
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 2, potency, true, false));
        }
    }
}

