/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.factories;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.crafting.AlkahestryTomeIngredient;
import xreliquary.init.ModItems;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemAlkahestryTome;
import xreliquary.reference.Settings;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AlkahestryCraftingRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for alkahestry crafting recipe");
        }
        if (ingredients.size() > 1) {
            throw new JsonParseException("Too many ingredients for alkahestry crafting recipe");
        }
        int resultCount = JsonUtils.func_151203_m((JsonObject)json, (String)"result_count");
        int chargeNeeded = JsonUtils.func_151203_m((JsonObject)json, (String)"charge");
        ItemStack result = ((Ingredient)ingredients.get(0)).func_193365_a()[0].func_77946_l();
        result.func_190920_e(resultCount);
        return new AlkahestryCraftingRecipe(new ResourceLocation("xreliquary", "alkahestry_crafting"), (Ingredient)ingredients.get(0), result, resultCount, chargeNeeded);
    }

    public static class AlkahestryCraftingRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private final int chargeNeeded;
        private final ResourceLocation group;
        private final NonNullList<Ingredient> ingredients;
        private final Ingredient input;
        private final ItemStack result;
        private final int resultCount;

        public Ingredient getInput() {
            return this.input;
        }

        public int getResultCount() {
            return this.resultCount;
        }

        public int getChargeNeeded() {
            return this.chargeNeeded;
        }

        public AlkahestryCraftingRecipe(ResourceLocation group, Ingredient input, ItemStack result, int resultCount, int chargeNeeded) {
            this.group = group;
            this.result = result;
            this.resultCount = resultCount;
            this.chargeNeeded = chargeNeeded;
            this.input = input;
            ItemStack tome = new ItemStack((Item)ModItems.alkahestryTome);
            ItemAlkahestryTome.setCharge(tome, Settings.Items.AlkahestryTome.chargeLimit);
            this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{input, new AlkahestryTomeIngredient(tome, chargeNeeded)});
            XRRecipes.craftingRecipes.add(this);
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList remainingItems = super.func_179532_b(inv);
            this.addTomeWithUsedCharge((NonNullList<ItemStack>)remainingItems, inv);
            return remainingItems;
        }

        public NonNullList<Ingredient> func_192400_c() {
            return this.ingredients;
        }

        public String func_193358_e() {
            return this.group.toString();
        }

        private void addTomeWithUsedCharge(NonNullList<ItemStack> remainingItems, InventoryCrafting inv) {
            for (int slot = 0; slot < remainingItems.size(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack.func_77973_b() != ModItems.alkahestryTome) continue;
                ItemStack tome = stack.func_77946_l();
                ModItems.alkahestryTome.useCharge(tome, this.chargeNeeded);
                remainingItems.set(slot, (Object)tome);
                break;
            }
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            NonNullList required = NonNullList.func_191196_a();
            required.addAll(this.ingredients);
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack slot = inv.func_70301_a(x);
                if (slot.func_190926_b()) continue;
                boolean inRecipe = false;
                Iterator req = required.iterator();
                while (req.hasNext()) {
                    if (!((Ingredient)req.next()).apply(slot)) continue;
                    inRecipe = true;
                    req.remove();
                    break;
                }
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty();
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack.func_190926_b() || stack.func_77973_b() == ModItems.alkahestryTome) continue;
                ItemStack result = stack.func_77946_l();
                result.func_190920_e(this.resultCount);
                return result;
            }
            return ItemStack.field_190927_a;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 2;
        }

        public ItemStack func_77571_b() {
            return this.result;
        }
    }
}

