/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.waila.provider;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.compat.waila.provider.CachedBodyDataProvider;
import xreliquary.init.ModBlocks;
import xreliquary.util.LanguageHelper;
import xreliquary.util.potions.XRPotionHelper;

public class DataProviderCauldron
extends CachedBodyDataProvider {
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return new ItemStack((Block)ModBlocks.apothecaryCauldron);
    }

    @Override
    public List<String> getWailaBodyToCache(ItemStack itemStack, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ArrayList<String> currenttip = new ArrayList<String>();
        if (!(accessor.getBlock() instanceof BlockApothecaryCauldron) || !(accessor.getTileEntity() instanceof TileEntityCauldron)) {
            return currenttip;
        }
        TileEntityCauldron cauldron = (TileEntityCauldron)accessor.getTileEntity();
        if (cauldron == null || cauldron.effects.isEmpty()) {
            return currenttip;
        }
        if (!cauldron.hasNetherwart) {
            currenttip.add(TextFormatting.RED + LanguageHelper.getLocalization("waila.xreliquary.cauldron.missing_netherwart", new Object[0]) + TextFormatting.RESET);
        }
        if (!cauldron.hasGunpowder && cauldron.hasDragonBreath) {
            currenttip.add(TextFormatting.RED + LanguageHelper.getLocalization("waila.xreliquary.cauldron.missing_gunpowder", new Object[0]) + TextFormatting.RESET);
        }
        StringBuilder ingredients = new StringBuilder();
        if (cauldron.redstoneCount > 0) {
            ingredients.append(cauldron.redstoneCount);
            ingredients.append("x");
            ingredients.append(new ItemStack(Items.field_151137_ax).func_82833_r());
            ingredients.append(" ");
        }
        if (cauldron.glowstoneCount > 0) {
            ingredients.append(cauldron.glowstoneCount);
            ingredients.append("x");
            ingredients.append(new ItemStack(Items.field_151114_aO).func_82833_r());
        }
        currenttip.add(ingredients.toString());
        if (cauldron.hasDragonBreath) {
            currenttip.add(TextFormatting.WHITE.toString() + cauldron.getLiquidLevel() + "x" + LanguageHelper.getLocalization("waila.xreliquary.cauldron.lingering", new Object[0]) + TextFormatting.RESET);
        } else if (cauldron.hasGunpowder) {
            currenttip.add(TextFormatting.WHITE.toString() + cauldron.getLiquidLevel() + "x" + LanguageHelper.getLocalization("waila.xreliquary.cauldron.splash", new Object[0]) + TextFormatting.RESET);
        } else {
            currenttip.add(TextFormatting.WHITE.toString() + cauldron.getLiquidLevel() + "x" + LanguageHelper.getLocalization("waila.xreliquary.cauldron.potion", new Object[0]) + TextFormatting.RESET);
        }
        XRPotionHelper.addPotionTooltip(cauldron.effects, currenttip, false, false);
        return currenttip;
    }
}

