/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.ByteBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.ByteMergeSort;
import org.magicwerk.brownies.collections.primitive.ByteGapList;
import org.magicwerk.brownies.collections.primitive.IByteList;

public class ByteBigList
extends IByteList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final ByteBigList EMPTY = ByteBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private ByteBlockNode rootNode;
    private ByteBlockNode currNode;
    private int currByteBlockStart;
    private int currByteBlockEnd;
    private int currModify;

    public static IByteList of(byte[] values2) {
        return new ImmutableByteListArrayPrimitive(values2);
    }

    public static IByteList of(Byte[] values2) {
        return new ImmutableByteListArrayWrapper(values2);
    }

    public static IByteList of(List<Byte> values2) {
        return new ImmutableByteListList(values2);
    }

    public static ByteBigList EMPTY() {
        return EMPTY;
    }

    protected ByteBigList(boolean copy2, ByteBigList that) {
        if (copy2) {
            this.blockSize = that.blockSize;
            this.currByteBlockStart = that.currByteBlockStart;
            this.currByteBlockEnd = that.currByteBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static ByteBigList create() {
        return new ByteBigList();
    }

    public static ByteBigList create(Collection<Byte> coll) {
        return new ByteBigList(coll);
    }

    public static ByteBigList create(byte ... elems) {
        ByteBigList list2 = new ByteBigList();
        for (byte elem : elems) {
            list2.add(elem);
        }
        return list2;
    }

    public ByteBigList() {
        this(1000);
    }

    public ByteBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public ByteBigList(Collection<Byte> coll) {
        if (coll instanceof ByteBigList) {
            this.doAssign((ByteBigList)((Object)coll));
            this.doClone((ByteBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addByteBlock(0, new ByteBlock());
            for (Object obj : coll.toArray()) {
                this.add((Byte)obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private ByteBigList(int blockSize, int firstByteBlockSize) {
        this.doInit(blockSize, firstByteBlockSize);
    }

    private void doInit(int blockSize, int firstByteBlockSize) {
        this.blockSize = blockSize;
        ByteBlock block = firstByteBlockSize <= 1 ? new ByteBlock() : new ByteBlock(firstByteBlockSize);
        this.addByteBlock(0, block);
    }

    @Override
    public ByteBigList copy() {
        return (ByteBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IByteList that) {
        ByteBigList list2 = (ByteBigList)that;
        this.blockSize = list2.blockSize;
        this.currByteBlockEnd = list2.currByteBlockEnd;
        this.currByteBlockStart = list2.currByteBlockStart;
        this.currNode = list2.currNode;
        this.rootNode = list2.rootNode;
        this.size = list2.size;
    }

    @Override
    protected void doClone(IByteList that) {
        ByteBigList bigList = (ByteBigList)that;
        bigList.releaseByteBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private ByteBlockNode copy(ByteBlockNode node) {
        ByteBlockNode newNode = node.min();
        int index = newNode.block.size();
        ByteBlockNode newRoot = new ByteBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public byte getDefaultElem() {
        return 0;
    }

    protected void finalize() {
        ByteBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected byte doGet(int index) {
        int pos2 = this.getByteBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos2);
    }

    @Override
    protected byte doSet(int index, byte elem) {
        int pos2 = this.getByteBlockIndex(index, true, 0);
        byte oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    @Override
    protected byte doReSet(int index, byte elem) {
        int pos2 = this.getByteBlockIndex(index, true, 0);
        byte oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    private void releaseByteBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getByteBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currByteBlockStart && (index < this.currByteBlockEnd || index == this.currByteBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setByteBlock(new ByteBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currByteBlockStart;
            }
            this.releaseByteBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currByteBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currByteBlockEnd = this.size;
                this.currByteBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                ByteBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currByteBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currByteBlockEnd = this.currNode.block.size();
                this.currByteBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetByteBlock(index, modify);
        }
        assert (index >= this.currByteBlockStart && index <= this.currByteBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setByteBlock(new ByteBlock(this.currNode.block));
        }
        return index - this.currByteBlockStart;
    }

    private boolean isOnlyRootByteBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetByteBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currByteBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                ByteBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currByteBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currByteBlockEnd) {
                    if (modify == 0) break;
                    ByteBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currByteBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            ByteBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currByteBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currByteBlockStart = this.currByteBlockEnd - this.currNode.block.size();
    }

    private void addByteBlock(int index, ByteBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new ByteBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, byte element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos2 = this.getByteBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos2, element);
            ++this.currByteBlockEnd;
        } else {
            ByteBlock newByteBlock = new ByteBlock(this.blockSize);
            if (index == this.size) {
                ByteBlockNode lastNode;
                newByteBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addByteBlock(this.size + 1, newByteBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currByteBlockStart = this.currByteBlockEnd++;
            } else if (index == 0) {
                ByteBlockNode firstNode;
                newByteBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addByteBlock(1, newByteBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currByteBlockStart = 0;
                this.currByteBlockEnd = 1;
            } else {
                int nextByteBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextByteBlockLen;
                ByteGapList.transferRemove(this.currNode.block, blockLen, nextByteBlockLen, newByteBlock, 0, 0);
                this.modify(this.currNode, -nextByteBlockLen - 1);
                this.addByteBlock(this.currByteBlockEnd - nextByteBlockLen, newByteBlock);
                if (pos2 < blockLen) {
                    this.currNode.block.doAdd(pos2, element);
                    this.currByteBlockEnd = this.currByteBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos2 - blockLen, element);
                    this.currByteBlockStart += blockLen;
                    ++this.currByteBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(ByteBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseByteBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            ByteBlockNode p;
            ByteBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            ByteBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            ByteBlockNode parent2;
            node.relPos += modify;
            ByteBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent2 = node.parent) != null) {
                ByteBlockNode p;
                assert (parent2.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent2.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent2;
                    if (parentLeft != pLeft) {
                        parent2.relPos = parent2.relPos > 0 ? (parent2.relPos += modify) : (parent2.relPos -= modify);
                    }
                    parent2 = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private ByteBlockNode doRemove(ByteBlockNode node) {
        ByteBlockNode newNode;
        ByteBlockNode p = node.parent;
        ByteBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IByteList list2) {
        if (list2.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list2.size() == 1) {
            return this.doAdd(index, list2.get(0));
        }
        int addPos = this.getByteBlockIndex(index, true, 0);
        ByteBlock addByteBlock = this.currNode.block;
        int space = this.blockSize - addByteBlock.size();
        int addLen = list2.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list2);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currByteBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                ByteBlock nextByteBlock = new ByteBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextByteBlock.add(i, list2.get(done + i));
                }
                this.addByteBlock(this.size + (done += add), nextByteBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currByteBlockEnd = this.size;
            this.currByteBlockStart = this.currByteBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                ByteBlock nextByteBlock = new ByteBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextByteBlock.add(i, list2.get(addLen - done - add + i));
                }
                done += add;
                this.addByteBlock(0, nextByteBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currByteBlockStart = 0;
            this.currByteBlockEnd = this.currNode.block.size();
        } else {
            ByteGapList sublist;
            int add;
            ByteGapList list22 = ByteGapList.create();
            list22.addAll(list2);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list22.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currByteBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list22.size();
            int numByteBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numByteBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numByteBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list22.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numByteBlocks;
                this.size += add;
                this.currByteBlockEnd += add;
            } else if (has > should) {
                ByteBlock nextByteBlock = new ByteBlock(this.blockSize);
                int move = has - should;
                nextByteBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currByteBlockEnd -= move;
                should = numElems / --numByteBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                ByteGapList sublist2 = list22.getAll(0, add2);
                nextByteBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextByteBlock.size() == should);
                numElems -= should;
                --numByteBlocks;
                this.size += add2;
                this.addByteBlock(this.currByteBlockEnd, nextByteBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextByteBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currByteBlockStart = this.currByteBlockEnd;
                this.currByteBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numByteBlocks;
            }
            while (numByteBlocks > 0) {
                add = numElems / numByteBlocks;
                assert (add > 0);
                sublist = list22.getAll(listPos, add);
                listPos += add;
                ByteBlock nextByteBlock = new ByteBlock();
                nextByteBlock.addAll(sublist);
                assert (nextByteBlock.size() == add);
                numElems -= add;
                this.addByteBlock(this.currByteBlockEnd, nextByteBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextByteBlock);
                assert (this.currNode.block.size() == add);
                this.currByteBlockStart = this.currByteBlockEnd;
                this.currByteBlockEnd += add;
                this.size += add;
                --numByteBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currByteBlockStart = 0;
        this.currByteBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getByteBlockIndex(index, true, 0);
        ByteBlockNode startNode = this.currNode;
        int endPos = this.getByteBlockIndex(index + len - 1, true, 0);
        ByteBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getByteBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                ByteBlockNode oldCurrNode = this.currNode;
                this.releaseByteBlock();
                ByteBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currByteBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getByteBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseByteBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getByteBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    ByteBlockNode oldCurrNode = this.currNode;
                    this.releaseByteBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseByteBlock();
            this.getByteBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(ByteBlockNode node) {
        if (node == null) {
            return;
        }
        int minByteBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minByteBlockSize) {
            return;
        }
        ByteBlockNode oldCurrNode = node;
        ByteBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minByteBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getByteBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add((byte)0);
            }
            ByteGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseByteBlock();
            this.doRemove(oldCurrNode);
        } else {
            ByteBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minByteBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, (byte)0);
                }
                ByteGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseByteBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected byte doRemove(int index) {
        int pos2 = this.getByteBlockIndex(index, true, -1);
        byte oldElem = this.currNode.block.doRemove(pos2);
        --this.currByteBlockEnd;
        int minByteBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minByteBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootByteBlock()) {
                    ByteBlockNode oldCurrNode = this.currNode;
                    this.releaseByteBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public ByteBigList unmodifiableList() {
        return new ImmutableByteBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootByteBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootByteBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            ByteBigList newList = new ByteBigList(this.blockSize);
            ByteBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IByteList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new ByteBigList(this.blockSize);
        }
        return new ByteBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootByteBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            ByteMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, byte key) {
        this.checkRange(index, len);
        if (this.isOnlyRootByteBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return ByteBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size2 = this.size();
        oos.writeInt(size2);
        for (int i = 0; i < size2; ++i) {
            oos.writeByte(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size2 = ois.readInt();
        int firstByteBlockSize = size2 <= blockSize ? size2 : -1;
        this.doInit(blockSize, firstByteBlockSize);
        for (int i = 0; i < size2; ++i) {
            this.add(ois.readByte());
        }
    }

    private void checkNode(ByteBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        ByteBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(ByteBlockNode node) {
        ByteBlockNode left = node.getLeftSubTree();
        ByteBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currByteBlockStart >= 0 && this.currByteBlockEnd <= this.size && this.currByteBlockStart <= this.currByteBlockEnd);
            assert (this.currByteBlockStart + this.currNode.block.size() == this.currByteBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        ByteBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        ByteBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        ByteBlock block = node.getByteBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getByteBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getByteBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableByteBigList
    extends ByteBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableByteBigList(ByteBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, byte elem) {
            this.error();
            return false;
        }

        @Override
        protected byte doSet(int index, byte elem) {
            this.error();
            return 0;
        }

        @Override
        protected byte doReSet(int index, byte elem) {
            this.error();
            return 0;
        }

        @Override
        protected byte doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class ByteBlockNode {
        ByteBlockNode parent;
        ByteBlockNode left;
        boolean leftIsPrevious;
        ByteBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        ByteBlock block;

        private ByteBlockNode(ByteBlockNode parent2, int relPos, ByteBlock block, ByteBlockNode rightFollower, ByteBlockNode leftFollower) {
            this.parent = parent2;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private ByteBlock getByteBlock() {
            return this.block;
        }

        private void setByteBlock(ByteBlock block) {
            this.block = block;
        }

        private ByteBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private ByteBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private ByteBlockNode insert(int index, ByteBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private ByteBlockNode insertOnLeft(int relIndex, ByteBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos2 = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new ByteBlockNode(this, pos2, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            ByteBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private ByteBlockNode insertOnRight(int relIndex, ByteBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new ByteBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            ByteBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private ByteBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private ByteBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private ByteBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private ByteBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private ByteBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private ByteBlockNode removeMin(int size2) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size2), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size2;
            }
            this.recalcHeight();
            return this.balance();
        }

        private ByteBlockNode removeSelf() {
            ByteBlockNode p = this.parent;
            ByteBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private ByteBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                ByteBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                ByteBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                ByteBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private ByteBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(ByteBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(ByteBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(ByteBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private ByteBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            ByteBlockNode newTop = this.right;
            ByteBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            ByteBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private ByteBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            ByteBlockNode newTop = this.left;
            ByteBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            ByteBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(ByteBlockNode node, ByteBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(ByteBlockNode node, ByteBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "ByteBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class ByteBlock
    extends ByteGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public ByteBlock() {
        }

        public ByteBlock(int capacity) {
            super(capacity);
        }

        public ByteBlock(ByteBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public ByteBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableByteList
    extends IByteList {
        protected ImmutableByteList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, byte key) {
            return ByteBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public IByteList unmodifiableList() {
            return this;
        }

        @Override
        protected byte getDefaultElem() {
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(IByteList that) {
            this.error();
        }

        @Override
        protected byte doSet(int index, byte elem) {
            this.error();
            return 0;
        }

        @Override
        protected byte doReSet(int index, byte elem) {
            this.error();
            return 0;
        }

        @Override
        protected boolean doAdd(int index, byte elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IByteList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IByteList that) {
            this.error();
        }

        @Override
        protected byte doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableByteListList
    extends ImmutableByteList {
        List<Byte> values;

        public ImmutableByteListList(List<Byte> values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected byte doGet(int index) {
            return this.values.get(index);
        }
    }

    static class ImmutableByteListArrayWrapper
    extends ImmutableByteList {
        Byte[] values;

        public ImmutableByteListArrayWrapper(Byte[] values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected byte doGet(int index) {
            return this.values[index];
        }
    }

    static class ImmutableByteListArrayPrimitive
    extends ImmutableByteList {
        byte[] values;

        public ImmutableByteListArrayPrimitive(byte[] values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected byte doGet(int index) {
            return this.values[index];
        }
    }
}

