/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ObjectMap;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public class Reference2ObjectOpenCustomHashMap<K, V>
extends AbstractReference2ObjectMap<K, V>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected Hash.Strategy<? super K> strategy;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Reference2ObjectMap.FastEntrySet<K, V> entries;
    protected transient ReferenceSet<K> keys;
    protected transient ObjectCollection<V> values;

    public Reference2ObjectOpenCustomHashMap(int expected, float f, Hash.Strategy<? super K> strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Reference2ObjectOpenCustomHashMap(int expected, Hash.Strategy<? super K> strategy) {
        this(expected, 0.75f, strategy);
    }

    public Reference2ObjectOpenCustomHashMap(Hash.Strategy<? super K> strategy) {
        this(16, 0.75f, strategy);
    }

    public Reference2ObjectOpenCustomHashMap(Map<? extends K, ? extends V> m, float f, Hash.Strategy<? super K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Reference2ObjectOpenCustomHashMap(Map<? extends K, ? extends V> m, Hash.Strategy<? super K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Reference2ObjectOpenCustomHashMap(Reference2ObjectMap<K, V> m, float f, Hash.Strategy<? super K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Reference2ObjectOpenCustomHashMap(Reference2ObjectMap<K, V> m, Hash.Strategy<? super K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Reference2ObjectOpenCustomHashMap(K[] k, V[] v, float f, Hash.Strategy<? super K> strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Reference2ObjectOpenCustomHashMap(K[] k, V[] v, Hash.Strategy<? super K> strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy<? super K> strategy() {
        return this.strategy;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private V removeEntry(int pos2) {
        V oldValue = this.value[pos2];
        this.value[pos2] = null;
        --this.size;
        this.shiftKeys(pos2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        this.key[this.n] = null;
        V oldValue = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int find(K k) {
        if (this.strategy.equals(k, null)) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return -(pos2 + 1);
        }
        if (this.strategy.equals(k, curr)) {
            return pos2;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return -(pos2 + 1);
        } while (!this.strategy.equals(k, curr));
        return pos2;
    }

    private void insert(int pos2, K k, V v) {
        if (pos2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public V put(K k, V v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return (V)this.defRetValue;
        }
        V oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    protected final void shiftKeys(int pos2) {
        K[] key = this.key;
        while (true) {
            K curr;
            int last = pos2;
            pos2 = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos2]) == null) {
                    key[last] = null;
                    this.value[last] = null;
                    return;
                }
                int slot = HashCommon.mix(this.strategy.hashCode(curr)) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos2];
        }
    }

    @Override
    public V remove(Object k) {
        if (this.strategy.equals(k, null)) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return (V)this.defRetValue;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return (V)this.defRetValue;
        }
        if (this.strategy.equals(k, curr)) {
            return this.removeEntry(pos2);
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return (V)this.defRetValue;
        } while (!this.strategy.equals(k, curr));
        return this.removeEntry(pos2);
    }

    @Override
    public V get(Object k) {
        if (this.strategy.equals(k, null)) {
            return (V)(this.containsNullKey ? this.value[this.n] : this.defRetValue);
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return (V)this.defRetValue;
        }
        if (this.strategy.equals(k, curr)) {
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return (V)this.defRetValue;
        } while (!this.strategy.equals(k, curr));
        return this.value[pos2];
    }

    @Override
    public boolean containsKey(Object k) {
        if (this.strategy.equals(k, null)) {
            return this.containsNullKey;
        }
        K[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        K curr = key[pos2];
        if (curr == null) {
            return false;
        }
        if (this.strategy.equals(k, curr)) {
            return true;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!this.strategy.equals(k, curr));
        return true;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        K[] key = this.key;
        if (this.containsNullKey && Objects.equals(value[this.n], v)) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (key[i] == null || !Objects.equals(value[i], v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, null);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Reference2ObjectMap.FastEntrySet<K, V> reference2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ReferenceSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Reference2ObjectOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(Object v) {
                    return Reference2ObjectOpenCustomHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Reference2ObjectOpenCustomHashMap.this.clear();
                }

                @Override
                public void forEach(Consumer<? super V> consumer) {
                    if (Reference2ObjectOpenCustomHashMap.this.containsNullKey) {
                        consumer.accept(Reference2ObjectOpenCustomHashMap.this.value[Reference2ObjectOpenCustomHashMap.this.n]);
                    }
                    int pos2 = Reference2ObjectOpenCustomHashMap.this.n;
                    while (pos2-- != 0) {
                        if (Reference2ObjectOpenCustomHashMap.this.key[pos2] == null) continue;
                        consumer.accept(Reference2ObjectOpenCustomHashMap.this.value[pos2]);
                    }
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        K[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        Object[] newKey = new Object[newN + 1];
        Object[] newValue = new Object[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == null) {
            }
            int pos2 = HashCommon.mix(this.strategy.hashCode(key[i])) & mask;
            if (newKey[pos2] != null) {
                while (newKey[pos2 = pos2 + 1 & mask] != null) {
                }
            }
            newKey[pos2] = key[i];
            newValue[pos2] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Reference2ObjectOpenCustomHashMap<K, V> clone() {
        Reference2ObjectOpenCustomHashMap c;
        try {
            c = (Reference2ObjectOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (Object[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (this.key[i] == null) {
                ++i;
            }
            if (this != this.key[i]) {
                t = this.strategy.hashCode(this.key[i]);
            }
            if (this != this.value[i]) {
                t ^= this.value[i] == null ? 0 : this.value[i].hashCode();
            }
            h += t;
            ++i;
        }
        if (this.containsNullKey) {
            h += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n + 1];
        Object[] key = this.key;
        this.value = new Object[this.n + 1];
        Object[] value = this.value;
        int i = this.size;
        while (i-- != 0) {
            int pos2;
            Object k = s.readObject();
            Object v = s.readObject();
            if (this.strategy.equals(k, null)) {
                pos2 = this.n;
                this.containsNullKey = true;
            } else {
                pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
                while (key[pos2] != null) {
                    pos2 = pos2 + 1 & this.mask;
                }
            }
            key[pos2] = k;
            value[pos2] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Reference2ObjectOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractReferenceSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            if (Reference2ObjectOpenCustomHashMap.this.containsNullKey) {
                consumer.accept(Reference2ObjectOpenCustomHashMap.this.key[Reference2ObjectOpenCustomHashMap.this.n]);
            }
            int pos2 = Reference2ObjectOpenCustomHashMap.this.n;
            while (pos2-- != 0) {
                Object k = Reference2ObjectOpenCustomHashMap.this.key[pos2];
                if (k == null) continue;
                consumer.accept(k);
            }
        }

        @Override
        public int size() {
            return Reference2ObjectOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Reference2ObjectOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Reference2ObjectOpenCustomHashMap.this.size;
            Reference2ObjectOpenCustomHashMap.this.remove(k);
            return Reference2ObjectOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Reference2ObjectOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator<K> {
        @Override
        public K next() {
            return Reference2ObjectOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Reference2ObjectMap.Entry<K, V>>
    implements Reference2ObjectMap.FastEntrySet<K, V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Reference2ObjectMap.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Reference2ObjectMap.Entry<K, V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (Reference2ObjectOpenCustomHashMap.this.strategy.equals(k, null)) {
                return Reference2ObjectOpenCustomHashMap.this.containsNullKey && Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[Reference2ObjectOpenCustomHashMap.this.n], v);
            }
            K[] key = Reference2ObjectOpenCustomHashMap.this.key;
            int pos2 = HashCommon.mix(Reference2ObjectOpenCustomHashMap.this.strategy.hashCode(k)) & Reference2ObjectOpenCustomHashMap.this.mask;
            Object curr = key[pos2];
            if (curr == null) {
                return false;
            }
            if (Reference2ObjectOpenCustomHashMap.this.strategy.equals(k, curr)) {
                return Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[pos2], v);
            }
            do {
                if ((curr = key[pos2 = pos2 + 1 & Reference2ObjectOpenCustomHashMap.this.mask]) != null) continue;
                return false;
            } while (!Reference2ObjectOpenCustomHashMap.this.strategy.equals(k, curr));
            return Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[pos2], v);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (Reference2ObjectOpenCustomHashMap.this.strategy.equals(k, null)) {
                if (Reference2ObjectOpenCustomHashMap.this.containsNullKey && Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[Reference2ObjectOpenCustomHashMap.this.n], v)) {
                    Reference2ObjectOpenCustomHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            K[] key = Reference2ObjectOpenCustomHashMap.this.key;
            int pos2 = HashCommon.mix(Reference2ObjectOpenCustomHashMap.this.strategy.hashCode(k)) & Reference2ObjectOpenCustomHashMap.this.mask;
            Object curr = key[pos2];
            if (curr == null) {
                return false;
            }
            if (Reference2ObjectOpenCustomHashMap.this.strategy.equals(curr, k)) {
                if (Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[pos2], v)) {
                    Reference2ObjectOpenCustomHashMap.this.removeEntry(pos2);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key[pos2 = pos2 + 1 & Reference2ObjectOpenCustomHashMap.this.mask]) != null) continue;
                return false;
            } while (!Reference2ObjectOpenCustomHashMap.this.strategy.equals(curr, k) || !Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[pos2], v));
            Reference2ObjectOpenCustomHashMap.this.removeEntry(pos2);
            return true;
        }

        @Override
        public int size() {
            return Reference2ObjectOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Reference2ObjectOpenCustomHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super Reference2ObjectMap.Entry<K, V>> consumer) {
            if (Reference2ObjectOpenCustomHashMap.this.containsNullKey) {
                consumer.accept(new AbstractReference2ObjectMap.BasicEntry(Reference2ObjectOpenCustomHashMap.this.key[Reference2ObjectOpenCustomHashMap.this.n], Reference2ObjectOpenCustomHashMap.this.value[Reference2ObjectOpenCustomHashMap.this.n]));
            }
            int pos2 = Reference2ObjectOpenCustomHashMap.this.n;
            while (pos2-- != 0) {
                if (Reference2ObjectOpenCustomHashMap.this.key[pos2] == null) continue;
                consumer.accept(new AbstractReference2ObjectMap.BasicEntry(Reference2ObjectOpenCustomHashMap.this.key[pos2], Reference2ObjectOpenCustomHashMap.this.value[pos2]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Reference2ObjectMap.Entry<K, V>> consumer) {
            AbstractReference2ObjectMap.BasicEntry entry = new AbstractReference2ObjectMap.BasicEntry();
            if (Reference2ObjectOpenCustomHashMap.this.containsNullKey) {
                entry.key = Reference2ObjectOpenCustomHashMap.this.key[Reference2ObjectOpenCustomHashMap.this.n];
                entry.value = Reference2ObjectOpenCustomHashMap.this.value[Reference2ObjectOpenCustomHashMap.this.n];
                consumer.accept(entry);
            }
            int pos2 = Reference2ObjectOpenCustomHashMap.this.n;
            while (pos2-- != 0) {
                if (Reference2ObjectOpenCustomHashMap.this.key[pos2] == null) continue;
                entry.key = Reference2ObjectOpenCustomHashMap.this.key[pos2];
                entry.value = Reference2ObjectOpenCustomHashMap.this.value[pos2];
                consumer.accept(entry);
            }
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Reference2ObjectMap.Entry<K, V>> {
        private final MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Reference2ObjectMap.Entry<K, V>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        boolean mustReturnNullKey;
        ReferenceArrayList<K> wrapped;

        private MapIterator() {
            this.pos = Reference2ObjectOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Reference2ObjectOpenCustomHashMap.this.size;
            this.mustReturnNullKey = Reference2ObjectOpenCustomHashMap.this.containsNullKey;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Reference2ObjectOpenCustomHashMap.this.n;
                return this.last;
            }
            K[] key = Reference2ObjectOpenCustomHashMap.this.key;
            do {
                if (--this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                Object k = this.wrapped.get(-this.pos - 1);
                int p = HashCommon.mix(Reference2ObjectOpenCustomHashMap.this.strategy.hashCode(k)) & Reference2ObjectOpenCustomHashMap.this.mask;
                while (!Reference2ObjectOpenCustomHashMap.this.strategy.equals(k, key[p])) {
                    p = p + 1 & Reference2ObjectOpenCustomHashMap.this.mask;
                }
                return p;
            } while (key[this.pos] == null);
            this.last = this.pos;
            return this.last;
        }

        private void shiftKeys(int pos2) {
            K[] key = Reference2ObjectOpenCustomHashMap.this.key;
            while (true) {
                Object curr;
                int last = pos2;
                pos2 = last + 1 & Reference2ObjectOpenCustomHashMap.this.mask;
                while (true) {
                    if ((curr = key[pos2]) == null) {
                        key[last] = null;
                        Reference2ObjectOpenCustomHashMap.this.value[last] = null;
                        return;
                    }
                    int slot = HashCommon.mix(Reference2ObjectOpenCustomHashMap.this.strategy.hashCode(curr)) & Reference2ObjectOpenCustomHashMap.this.mask;
                    if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                    pos2 = pos2 + 1 & Reference2ObjectOpenCustomHashMap.this.mask;
                }
                if (pos2 < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ReferenceArrayList(2);
                    }
                    this.wrapped.add(key[pos2]);
                }
                key[last] = curr;
                Reference2ObjectOpenCustomHashMap.this.value[last] = Reference2ObjectOpenCustomHashMap.this.value[pos2];
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == Reference2ObjectOpenCustomHashMap.this.n) {
                Reference2ObjectOpenCustomHashMap.this.containsNullKey = false;
                Reference2ObjectOpenCustomHashMap.this.key[Reference2ObjectOpenCustomHashMap.this.n] = null;
                Reference2ObjectOpenCustomHashMap.this.value[Reference2ObjectOpenCustomHashMap.this.n] = null;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                Reference2ObjectOpenCustomHashMap.this.remove(this.wrapped.set(-this.pos - 1, (Object)null));
                this.last = -1;
                return;
            }
            --Reference2ObjectOpenCustomHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    final class MapEntry
    implements Reference2ObjectMap.Entry<K, V>,
    Map.Entry<K, V> {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public K getKey() {
            return Reference2ObjectOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Reference2ObjectOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Reference2ObjectOpenCustomHashMap.this.value[this.index];
            Reference2ObjectOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2ObjectOpenCustomHashMap.this.strategy.equals(Reference2ObjectOpenCustomHashMap.this.key[this.index], e.getKey()) && Objects.equals(Reference2ObjectOpenCustomHashMap.this.value[this.index], e.getValue());
        }

        @Override
        public int hashCode() {
            return Reference2ObjectOpenCustomHashMap.this.strategy.hashCode(Reference2ObjectOpenCustomHashMap.this.key[this.index]) ^ (Reference2ObjectOpenCustomHashMap.this.value[this.index] == null ? 0 : Reference2ObjectOpenCustomHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Reference2ObjectOpenCustomHashMap.this.key[this.index] + "=>" + Reference2ObjectOpenCustomHashMap.this.value[this.index];
        }
    }
}

