/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.search;

import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.gui.components.ComponentTextField;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.ComponentBookMark;
import com.teamwizardry.librarianlib.features.gui.provided.book.search.ISearchAlgorithm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ComponentSearchBar;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/context/ComponentBookMark;", "book", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;", "id", "", "onType", "Lkotlin/Function1;", "", "", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;ILkotlin/jvm/functions/Function1;)V", "textField", "Lcom/teamwizardry/librarianlib/features/gui/components/ComponentTextField;", "slideIn", "slideOutLong", "slideOutShort", "librarianlib-1.12.2"})
public final class ComponentSearchBar
extends ComponentBookMark {
    private final ComponentTextField textField;

    @Override
    public void slideOutShort() {
        super.slideOutShort();
        this.textField.setVisible(true);
    }

    @Override
    public void slideOutLong() {
        super.slideOutLong();
        this.textField.setVisible(true);
    }

    @Override
    public void slideIn() {
        super.slideIn();
        this.textField.setVisible(false);
    }

    public ComponentSearchBar(final @NotNull IBookGui book, int id, final @Nullable Function1<? super String, Unit> onType) {
        Intrinsics.checkParameterIsNotNull(book, "book");
        super(book, book.getSearchIconSprite(), id, -8, 1);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Intrinsics.checkExpressionValueIsNotNull(fontRenderer, "Minecraft.getMinecraft().fontRenderer");
        this.textField = new ComponentTextField(fontRenderer, 2, 1, this.getSize().getXi() - 44 - 2 * book.getSearchIconSprite().getWidth(), Minecraft.func_71410_x().field_71466_p.field_78288_b + 2);
        this.textField.BUS.hook(ComponentTextField.TextEditEvent.class, (Function1)new Function1<ComponentTextField.TextEditEvent, Unit>(){

            @Override
            public final void invoke(@NotNull ComponentTextField.TextEditEvent it) {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (textField.isFocused() && (charSequence = (CharSequence)it.getWhole()).length() == 0) {
                    this.slideOutShort();
                } else {
                    charSequence = it.getWhole();
                    if (charSequence.length() > 0) {
                        this.slideOutLong();
                    } else {
                        this.slideIn();
                    }
                }
                if (textField.isFocused() && onType != null) {
                    onType.invoke(it.getWhole());
                }
            }
        });
        this.textField.BUS.hook(ComponentTextField.FocusEvent.class, (Function1)new Function1<ComponentTextField.FocusEvent, Unit>(){

            @Override
            public final void invoke(@NotNull ComponentTextField.FocusEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (!it.getWasFocused()) {
                    CharSequence charSequence = textField.getText();
                    if (charSequence.length() == 0) {
                        this.slideOutShort();
                    } else {
                        this.slideOutLong();
                    }
                } else if (it.getWasFocused()) {
                    this.slideIn();
                }
            }
        });
        this.textField.getEnabledColor().setValue(book.getBook().getSearchTextColor());
        this.textField.getSelectionColor().setValue(book.getBook().getSearchTextHighlight());
        this.textField.getCursorColor().setValue(book.getBook().getSearchTextCursor());
        this.textField.getAutoFocus().setValue(true);
        this.add(this.textField);
        this.clipping.setClipToBounds(true);
        this.BUS.hook(GuiComponentEvents.MouseInEvent.class, (Function1)new Function1<GuiComponentEvents.MouseInEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseInEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (!textField.isFocused()) {
                    CharSequence charSequence = textField.getText();
                    if (charSequence.length() == 0) {
                        this.slideOutShort();
                    } else {
                        this.slideOutLong();
                    }
                }
            }
        });
        this.BUS.hook(GuiComponentEvents.MouseOutEvent.class, (Function1)new Function1<GuiComponentEvents.MouseOutEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseOutEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (!textField.isFocused()) {
                    this.slideIn();
                }
            }
        });
        this.BUS.hook(GuiComponentEvents.MouseClickOutsideEvent.class, (Function1)new Function1<GuiComponentEvents.MouseClickOutsideEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseClickOutsideEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (book.getContext().getBookElement() instanceof ISearchAlgorithm.ResultAcceptor) {
                    GuiComponent focus = book.getFocus();
                    if (focus == null || !focus.getMouseOver()) {
                        book.up();
                        textField.setText("");
                        textField.setFocused(false);
                    }
                } else {
                    textField.setText("");
                    textField.setFocused(false);
                }
            }
        });
    }
}

