/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.value;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.NullAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.ChangeListener;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMValueDouble {
    private double value;
    @Nullable
    private final ChangeListener.Double change;
    private Animatable animatable = new Animatable();

    public RMValueDouble(double initialValue) {
        this.value = initialValue;
        this.change = null;
    }

    public RMValueDouble(double initialValue, @NotNull ChangeListener.Double change) {
        this.value = initialValue;
        this.change = change;
    }

    public double get() {
        return this.value;
    }

    public void set(double value) {
        GuiAnimator.getCurrent().add(this.animatable);
        this.value = value;
    }

    public double getValue(Object thisRef, KProperty property) {
        return this.value;
    }

    public void setValue(Object thisRef, KProperty property, double value) {
        this.set(value);
    }

    public Animation<RMValueDouble> animate(double from, double to, float duration, Easing easing) {
        return this.animate(from, to, duration, easing, 0.0f);
    }

    public Animation<RMValueDouble> animate(double from, double to, float duration) {
        return this.animate(from, to, duration, Easing.linear, 0.0f);
    }

    public Animation<RMValueDouble> animate(double from, double to, float duration, Easing easing, float delay) {
        AnimationImpl animation = new AnimationImpl(from, to, this);
        animation.setDuration(duration);
        animation.easing = easing;
        animation.setStart(delay);
        Animator.global.add(animation);
        return animation;
    }

    public Animation<RMValueDouble> animate(double to, float duration) {
        return this.animate(to, duration, Easing.linear, 0.0f);
    }

    public Animation<RMValueDouble> animate(double to, float duration, Easing easing) {
        return this.animate(to, duration, easing, 0.0f);
    }

    public Animation<RMValueDouble> animate(double to, float duration, Easing easing, float delay) {
        AnimationImpl anim2 = (AnimationImpl)this.animate(this.get(), to, duration, easing, delay);
        anim2.implicitStart = true;
        return anim2;
    }

    public KeyframeAnimationBuilder animateKeyframes(double initialValue) {
        return this.animateKeyframes(initialValue, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(double initialValue, float delay) {
        return new KeyframeAnimationBuilder(initialValue, delay, this);
    }

    private static class KeyframeAnimation
    extends Animation<RMValueDouble> {
        private List<Keyframe> keyframes;

        KeyframeAnimation(RMValueDouble target, List<Keyframe> keyframes) {
            super(target, new NullAnimatable());
            this.keyframes = keyframes;
        }

        @Override
        public void update(float time) {
            float progress2 = this.timeFraction(time);
            Keyframe prev = null;
            Keyframe next = null;
            for (Keyframe it : this.keyframes) {
                if (it.time <= progress2) {
                    prev = it;
                }
                if (!(it.time >= progress2) || next != null) continue;
                next = it;
            }
            if (prev != null && next != null) {
                if (next.time == prev.time) {
                    ((RMValueDouble)this.getTarget()).set(next.value);
                } else {
                    float partialProgress = next.easing.invoke((progress2 - prev.time) / (next.time - prev.time));
                    ((RMValueDouble)this.getTarget()).set(prev.value + (next.value - prev.value) * (double)partialProgress);
                }
            } else if (next != null) {
                ((RMValueDouble)this.getTarget()).set(next.value);
            } else if (prev != null) {
                ((RMValueDouble)this.getTarget()).set(prev.value);
            }
        }
    }

    private static class Keyframe {
        float time;
        double value;
        Easing easing;

        Keyframe(float time, double value, Easing easing) {
            this.time = time;
            this.value = value;
            this.easing = easing;
        }
    }

    public static class KeyframeAnimationBuilder {
        private float delay;
        private RMValueDouble target;
        private List<Keyframe> keyframes = new ArrayList<Keyframe>();

        KeyframeAnimationBuilder(double initialValue, float delay, RMValueDouble target) {
            this.target = target;
            this.delay = delay;
            this.keyframes.add(new Keyframe(0.0f, initialValue, Easing.linear));
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, double value) {
            return this.add(time, value, Easing.linear);
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, double value, @NotNull Easing easing) {
            this.keyframes.add(new Keyframe(time, value, easing));
            return this;
        }

        @NotNull
        public Animation<RMValueDouble> finish() {
            if (this.keyframes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty keyframe animation");
            }
            float duration = 0.0f;
            for (Keyframe keyframe : this.keyframes) {
                duration += keyframe.time;
            }
            float total = 0.0f;
            for (Keyframe it : this.keyframes) {
                it.time = (total += it.time) / duration;
            }
            KeyframeAnimation keyframeAnimation = new KeyframeAnimation(this.target, this.keyframes);
            keyframeAnimation.setDuration(duration);
            keyframeAnimation.setStart(this.delay);
            Animator.global.add(keyframeAnimation);
            return keyframeAnimation;
        }
    }

    private class AnimationImpl
    extends Animation<RMValueDouble> {
        double from;
        double to;
        boolean implicitStart;
        Easing easing;

        AnimationImpl(double from, double to, RMValueDouble target) {
            super(target, new NullAnimatable());
            this.easing = Easing.linear;
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(float time) {
            if (this.implicitStart) {
                this.from = ((RMValueDouble)this.getTarget()).get();
                this.implicitStart = false;
            }
            float progress2 = this.easing.invoke(this.timeFraction(time));
            double newValue = this.from + (this.to - this.from) * (double)progress2;
            ((RMValueDouble)this.getTarget()).set(newValue);
        }
    }

    private class Animatable
    implements GuiAnimatable<Animatable> {
        private Animatable() {
        }

        @Override
        @Nullable
        public Object getAnimatableValue() {
            return RMValueDouble.this.get();
        }

        @Override
        public void setAnimatableValue(@Nullable Object value) {
            RMValueDouble.this.set((Double)value);
        }

        @Override
        @Nullable
        public Object getAnimatableCallback() {
            return null;
        }

        @Override
        public void setAnimatableCallback(@NotNull Object supplier) {
        }
    }
}

