/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf;

import net.darkhax.bookshelf.crafting.AnvilRecipe;
import net.darkhax.bookshelf.crafting.IAnvilRecipe;
import net.darkhax.bookshelf.lib.ModTrackingList;
import net.darkhax.bookshelf.world.gamerule.GameRule;
import net.minecraft.command.ICommand;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BookshelfRegistry {
    private static final ModTrackingList<IAnvilRecipe> anvilRecipes = new ModTrackingList();
    private static final ModTrackingList<ICommand> commands = new ModTrackingList();
    private static final ModTrackingList<GameRule> gameRules = new ModTrackingList();

    public static void addAnvilRecipe(String leftSlot, ItemStack rightSlot, int experience, int materialCost, ItemStack output) {
        for (ItemStack stack : OreDictionary.getOres((String)leftSlot)) {
            BookshelfRegistry.addAnvilRecipe(stack, rightSlot, null, experience, materialCost, output);
        }
    }

    public static void addAnvilRecipe(ItemStack leftSlot, String rightSlot, int experience, int materialCost, ItemStack output) {
        for (ItemStack stack : OreDictionary.getOres((String)rightSlot)) {
            BookshelfRegistry.addAnvilRecipe(leftSlot, stack, null, experience, materialCost, output);
        }
    }

    public static void addAnvilRecipe(String leftSlot, String rightSlot, int experience, int materialCost, ItemStack output) {
        for (ItemStack stackLeft : OreDictionary.getOres((String)leftSlot)) {
            for (ItemStack stackRight : OreDictionary.getOres((String)rightSlot)) {
                BookshelfRegistry.addAnvilRecipe(stackLeft, stackRight, null, experience, materialCost, output);
            }
        }
    }

    public static void addAnvilRecipe(ItemStack leftSlot, ItemStack rightSlot, int experience, int materialCost, ItemStack output) {
        BookshelfRegistry.addAnvilRecipe(leftSlot, rightSlot, null, experience, materialCost, output);
    }

    public static void addAnvilRecipe(ItemStack leftSlot, ItemStack rightSlot, String requiredName, int experience, int materialCost, ItemStack output) {
        BookshelfRegistry.addAnvilRecipe(new AnvilRecipe(leftSlot, rightSlot, requiredName, experience, materialCost, output));
    }

    public static void addAnvilRecipe(IAnvilRecipe recipe) {
        anvilRecipes.add(recipe);
    }

    public static ModTrackingList<IAnvilRecipe> getAnvilRecipes() {
        return anvilRecipes;
    }

    public static void addGameRule(GameRule rule) {
        gameRules.add(rule);
    }

    public static ModTrackingList<GameRule> getGameRules() {
        return gameRules;
    }

    public static void addCommand(ICommand command) {
        commands.add(command);
    }

    public static ModTrackingList<ICommand> getCommands() {
        return commands;
    }
}

