/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleFunction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Bezier
implements DoubleFunction<Vec3d> {
    public List<Vec3d> controlPoints;
    public List<BezierSegment> segmentsX;
    public List<BezierSegment> segmentsY;
    public List<BezierSegment> segmentsZ;

    public Bezier(List<Vec3d> controlPoints) {
        this.controlPoints = controlPoints;
        this.segmentsX = this.compute(controlPoints.stream().mapToDouble(p -> p.field_72450_a).toArray());
        this.segmentsY = this.compute(controlPoints.stream().mapToDouble(p -> p.field_72448_b).toArray());
        this.segmentsZ = this.compute(controlPoints.stream().mapToDouble(p -> p.field_72449_c).toArray());
    }

    @Override
    public Vec3d apply(double value) {
        value = MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
        double d = value * (double)(this.controlPoints.size() - 1);
        int index = (int)d;
        double lerp = d % 1.0;
        if (value >= 1.0) {
            index = this.controlPoints.size() - 2;
            lerp = 1.0;
        }
        Vec3d point = new Vec3d(this.segmentsX.get(index).apply(lerp), this.segmentsY.get(index).apply(lerp), this.segmentsZ.get(index).apply(lerp));
        return point;
    }

    public List<BezierSegment> compute(double[] k) {
        int i;
        double[] p1 = new double[k.length];
        double[] p2 = new double[k.length];
        double[] a = new double[k.length];
        double[] b = new double[k.length];
        double[] c = new double[k.length];
        double[] r = new double[k.length];
        int n = k.length - 1;
        a[0] = 0.0;
        b[0] = 2.0;
        c[0] = 1.0;
        r[0] = k[0] + 2.0 * k[1];
        for (i = 1; i < n - 1; ++i) {
            a[i] = 1.0;
            b[i] = 4.0;
            c[i] = 1.0;
            r[i] = 4.0 * k[i] + 2.0 * k[i + 1];
        }
        a[n - 1] = 2.0;
        b[n - 1] = 7.0;
        c[n - 1] = 0.0;
        r[n - 1] = 8.0 * k[n - 1] + k[n];
        for (i = 1; i < n; ++i) {
            double m = a[i] / b[i - 1];
            b[i] = b[i] - m * c[i - 1];
            r[i] = r[i] - m * r[i - 1];
        }
        p1[n - 1] = r[n - 1] / b[n - 1];
        for (i = n - 2; i >= 0; --i) {
            p1[i] = (r[i] - c[i] * p1[i + 1]) / b[i];
        }
        for (i = 0; i < n - 1; ++i) {
            p2[i] = 2.0 * k[i + 1] - p1[i + 1];
        }
        p2[n - 1] = 0.5 * (k[n] + p1[n - 1]);
        ArrayList<BezierSegment> segments = new ArrayList<BezierSegment>();
        for (int i2 = 0; i2 < n; ++i2) {
            segments.add(new BezierSegment(k[i2], p1[i2], p2[i2], k[i2 + 1]));
        }
        return segments;
    }

    static class BezierSegment {
        double p0;
        double p1;
        double p2;
        double p3;

        public BezierSegment(double p0, double p1, double p2, double p3) {
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        public double apply(double value) {
            double ivalue = 1.0 - value;
            return ivalue * ivalue * ivalue * this.p0 + 3.0 * ivalue * ivalue * value * this.p1 + 3.0 * ivalue * value * value * this.p2 + value * value * value * this.p3;
        }
    }
}

