/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.upgrade;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.tileentity.TileEntityCatalyticPlug;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeCatalyticPlug
extends DefaultUpgradeProvider {
    private static HashSet<Class<? extends TileEntity>> blacklist = new HashSet();

    public static void registerBlacklistedTile(Class<? extends TileEntity> tile) {
        blacklist.add(tile);
    }

    public UpgradeCatalyticPlug(TileEntity tile) {
        super("catalytic_plug", tile);
    }

    @Override
    public int getLimit(TileEntity tile) {
        return blacklist.contains(tile.getClass()) ? 0 : 2;
    }

    @Override
    public double transformEmberConsumption(TileEntity tile, double ember) {
        return this.hasCatalyst() ? ember * 2.0 : ember;
    }

    @Override
    public double getSpeed(TileEntity tile, double speed) {
        return this.hasCatalyst() ? speed * 2.0 : speed;
    }

    @Override
    public boolean doWork(TileEntity tile, List<IUpgradeProvider> upgrades) {
        if (this.hasCatalyst() && this.tile instanceof TileEntityCatalyticPlug) {
            this.depleteCatalyst(1);
            ((TileEntityCatalyticPlug)this.tile).setActive(20);
        }
        return false;
    }

    private boolean hasCatalyst() {
        if (!this.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        return handler.drain(FluidRegistry.getFluidStack((String)"alchemical_redstone", (int)1), false) != null;
    }

    private void depleteCatalyst(int amt) {
        if (!this.tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return;
        }
        IFluidHandler handler = (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        handler.drain(FluidRegistry.getFluidStack((String)"alchemical_redstone", (int)amt), true);
    }

    @Override
    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        if (event instanceof DialInformationEvent) {
            DialInformationEvent dialEvent = (DialInformationEvent)event;
            if (this.hasCatalyst() && "ember".equals(dialEvent.getDialType())) {
                double speedModifier = 2.0;
                DecimalFormat multiplierFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.speed_multiplier");
                dialEvent.getInformation().add(Embers.proxy.formatLocalize("embers.tooltip.upgrade.catalytic_plug", multiplierFormat.format(speedModifier)));
            }
        }
    }
}

