/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.misc.ILiquidFuel;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockSteamEngine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntitySteamEngine
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraCapabilityInformation {
    public static int NORMAL_FLUID_THRESHOLD = 10;
    public static int NORMAL_FLUID_CONSUMPTION = 4;
    public static int GAS_CONSUMPTION = 20;
    public static double MAX_POWER = 50.0;
    public static int CAPACITY = 8000;
    public static double SOLID_POWER = 20.0;
    public static double FUEL_MULTIPLIER = 2.0;
    public static final int SOUND_BURN = 1;
    public static final int SOUND_STEAM = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    BurningFuel currentFuel = new BurningFuel();
    int ticksExisted = 0;
    HashSet<Integer> soundsPlaying = new HashSet();
    EnumFacing front = EnumFacing.UP;
    public FluidTank tank = new FluidTank(CAPACITY);
    public DefaultMechCapability capability = new DefaultMechCapability(){

        public void setPower(double value, EnumFacing from) {
            if (from == null) {
                super.setPower(value, null);
            }
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntitySteamEngine.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileEntityFurnace.func_145952_a((ItemStack)stack) == 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack currentFuel = super.extractItem(slot, amount, true);
            int burntime = TileEntityFurnace.func_145952_a((ItemStack)currentFuel);
            if (burntime != 0) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("mech_power", this.capability.power);
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("progress", (NBTBase)this.currentFuel.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("front", this.front.func_176745_a());
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.power = tag.func_74769_h("mech_power");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.currentFuel.readFromNBT(tag.func_74775_l("progress"));
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.front = EnumFacing.func_82600_a((int)tag.func_74762_e("front"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return facing == this.front;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return (T)this.capability;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
        if (didFill) {
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        this.capability.setPower(0.0, null);
        this.updateNearby();
        world.func_175690_a(pos, null);
    }

    public void updateNearby() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (t == null || f != this.front || !t.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, Misc.getOppositeFace(f))) continue;
            ((IMechCapability)t.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, Misc.getOppositeFace(f))).setPower(this.capability.getPower(Misc.getOppositeFace(f)), Misc.getOppositeFace(f));
            t.func_70296_d();
        }
    }

    private ItemStack copyWithSize(ItemStack stack, int size) {
        stack = stack.func_77946_l();
        stack.func_190920_e(size);
        return stack;
    }

    public void func_73660_a() {
        ILiquidFuel fuelHandler;
        FluidStack fluid;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockSteamEngine) {
            this.front = (EnumFacing)state.func_177229_b((IProperty)BlockSteamEngine.facing);
        }
        boolean dirty = false;
        double powerGenerated = 0.0;
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
            this.handleSound();
        }
        if (!this.field_145850_b.field_72995_K && !this.currentFuel.isEmpty()) {
            this.currentFuel.tick();
            if (this.currentFuel.isEmpty()) {
                this.currentFuel.reset();
                dirty = true;
            }
        }
        if (this.currentFuel.isEmpty()) {
            ItemStack fuelCopy;
            int burnTime;
            ItemStack fuel;
            fluid = this.tank.getFluid();
            fuelHandler = EmbersAPI.getSteamEngineFuel(fluid);
            if (fluid != null && fuelHandler != null) {
                fluid = this.tank.drain(Math.min(GAS_CONSUMPTION, Math.max(fluid.amount - 1, 1)), false);
                if (!this.field_145850_b.field_72995_K) {
                    this.currentFuel = new BurningFuel(fluid, fuelHandler.getTime(fluid));
                    this.tank.drain(fluid, true);
                    dirty = true;
                }
            } else if (!(this.field_145850_b.field_72995_K || this.inventory.getStackInSlot(0).func_190926_b() || fluid == null || fluid.getFluid() != FluidRegistry.WATER || this.tank.getFluidAmount() < NORMAL_FLUID_THRESHOLD || (fuel = this.inventory.getStackInSlot(0)).func_190926_b() || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)(fuelCopy = fuel.func_77946_l()))) <= 0)) {
                this.currentFuel = new BurningFuel(this.copyWithSize(fuelCopy, 1), (int)((double)burnTime * FUEL_MULTIPLIER));
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.inventory.setStackInSlot(0, fuelCopy.func_77973_b().getContainerItem(fuelCopy));
                }
                dirty = true;
            }
        }
        if (this.currentFuel.isLiquid()) {
            fluid = this.currentFuel.liquidFuel;
            fuelHandler = EmbersAPI.getSteamEngineFuel(fluid);
            powerGenerated = Misc.getDiminishedPower(fuelHandler.getPower(fluid), MAX_POWER, 1.0);
        }
        if (this.currentFuel.isSolid()) {
            fluid = this.tank.getFluid();
            if (this.tank.getFluidAmount() >= NORMAL_FLUID_CONSUMPTION && fluid != null && fluid.getFluid() == FluidRegistry.WATER) {
                if (!this.field_145850_b.field_72995_K) {
                    this.tank.drain(NORMAL_FLUID_CONSUMPTION, true);
                    powerGenerated = SOLID_POWER;
                    dirty = true;
                }
            } else {
                this.currentFuel.reset();
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && this.capability.getPower(null) != powerGenerated) {
            this.capability.setPower(powerGenerated, null);
            this.updateNearby();
        }
    }

    private void spawnParticles() {
        if (this.currentFuel.isEmpty()) {
            return;
        }
        boolean vapor = this.currentFuel.isLiquid();
        for (int i = 0; i < 4; ++i) {
            float offX = 0.09375f + 0.8125f * (float)Misc.random.nextInt(2);
            float offZ = 0.28125f + 0.4375f * (float)Misc.random.nextInt(2);
            if (this.front.func_176740_k() == EnumFacing.Axis.X) {
                float h = offX;
                offX = offZ;
                offZ = h;
            }
            Color color = this.currentFuel.getColor();
            if (vapor) {
                ParticleUtil.spawnParticleVapor(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + offX, (float)this.func_174877_v().func_177956_o() + 1.0f, (float)this.func_174877_v().func_177952_p() + offZ, 0.025f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.025f * (Misc.random.nextFloat() - 0.5f), color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f, 0.5f, 2.0f + Misc.random.nextFloat(), 24);
                continue;
            }
            ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + offX, (float)this.func_174877_v().func_177956_o() + 1.0f, (float)this.func_174877_v().func_177952_p() + offZ, 0.025f * (Misc.random.nextFloat() - 0.5f), 0.125f * Misc.random.nextFloat(), 0.025f * (Misc.random.nextFloat() - 0.5f), color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f, 2.0f + Misc.random.nextFloat(), 24);
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.field_174879_c.func_177958_n() + 0.5f;
        float soundY = (float)this.field_174879_c.func_177956_o() + 0.5f;
        float soundZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.STEAM_ENGINE_LOOP_BURN, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.field_145850_b.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundManager.STEAM_ENGINE_START_BURN, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.STEAM_ENGINE_LOOP_STEAM, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.field_145850_b.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundManager.STEAM_ENGINE_START_STEAM, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundManager.STEAM_ENGINE_STOP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        switch (id) {
            case 1: {
                return this.currentFuel.isSolid();
            }
            case 2: {
                return this.currentFuel.isLiquid();
            }
        }
        return false;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.fuel", (Object[])new Object[0])));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.water_or_steam", (Object[])new Object[0])));
        }
    }

    class BurningFuel {
        ItemStack solidFuel = ItemStack.field_190927_a;
        FluidStack liquidFuel;
        int timeLeft;

        public BurningFuel() {
        }

        public BurningFuel(ItemStack solidFuel, int timeLeft) {
            this.solidFuel = solidFuel;
            this.timeLeft = timeLeft;
        }

        public BurningFuel(FluidStack liquidFuel, int timeLeft) {
            this.liquidFuel = liquidFuel;
            this.timeLeft = timeLeft;
        }

        public void tick() {
            --this.timeLeft;
        }

        public void reset() {
            this.solidFuel = ItemStack.field_190927_a;
            this.liquidFuel = null;
            this.timeLeft = 0;
        }

        public boolean isSolid() {
            return !this.solidFuel.func_190926_b();
        }

        public boolean isLiquid() {
            return this.liquidFuel != null;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.liquidFuel != null) {
                tag.func_74782_a("fluid", (NBTBase)this.liquidFuel.writeToNBT(new NBTTagCompound()));
            }
            if (!this.solidFuel.func_190926_b()) {
                tag.func_74782_a("item", (NBTBase)this.solidFuel.serializeNBT());
            }
            tag.func_74768_a("timeLeft", this.timeLeft);
            return tag;
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("fluid")) {
                this.liquidFuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("fluid"));
            }
            if (tag.func_74764_b("item")) {
                this.solidFuel = new ItemStack(tag.func_74775_l("item"));
            }
            this.timeLeft = tag.func_74762_e("timeLeft");
        }

        public boolean isEmpty() {
            return this.timeLeft <= 0;
        }

        public Color getColor() {
            ILiquidFuel fuelHandler;
            if (this.isSolid()) {
                return new Color(72, 72, 72, 128);
            }
            if (this.isLiquid() && (fuelHandler = EmbersAPI.getSteamEngineFuel(this.liquidFuel)) != null) {
                return fuelHandler.getBurnColor(this.liquidFuel);
            }
            return new Color(0, 0, 0, 0);
        }
    }
}

