/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import teamroots.embers.ConfigManager;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.misc.ILiquidFuel;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.block.BlockMiniBoiler;
import teamroots.embers.entity.EntityEmberProjectile;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeMiniBoiler;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityMiniBoiler
extends TileEntity
implements ITileEntityBase,
ISoundController,
ITickable,
IExtraDialInformation,
IExtraCapabilityInformation,
IFluidPipeConnectable {
    public static final int SOUND_SLOW = 1;
    public static final int SOUND_MEDIUM = 2;
    public static final int SOUND_FAST = 3;
    public static final int SOUND_PRESSURE_LOW = 4;
    public static final int SOUND_PRESSURE_MEDIUM = 5;
    public static final int SOUND_PRESSURE_HIGH = 6;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3, 4, 5, 6};
    Random random = new Random();
    HashSet<Integer> soundsPlaying = new HashSet();
    protected FluidTank fluidTank = new FluidTank(ConfigManager.miniBoilerCapacity);
    protected FluidTank gasTank = new FluidTank(ConfigManager.miniBoilerCapacity);
    protected UpgradeMiniBoiler upgrade;
    int lastBoil;
    int boilTime;

    public TileEntityMiniBoiler() {
        this.fluidTank.setTileEntity((TileEntity)this);
        this.gasTank.setTileEntity((TileEntity)this);
        this.upgrade = new UpgradeMiniBoiler(this);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fluidTank.readFromNBT(tag.func_74775_l("fluidTank"));
        this.gasTank.readFromNBT(tag.func_74775_l("gasTank"));
        this.lastBoil = tag.func_74762_e("lastBoil");
        this.boilTime = tag.func_74762_e("boilTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("lastBoil", this.lastBoil);
        tag.func_74768_a("boilTime", this.boilTime);
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing != null && facing != this.getFacing();
        }
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return facing == this.getFacing();
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN || facing != null && facing != this.getFacing() && facing.func_176740_k() != EnumFacing.Axis.Y) {
                return (T)this.fluidTank;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.gasTank;
            }
        }
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && facing == this.getFacing()) {
            return (T)this.upgrade;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return (EnumFacing)state.func_177229_b((IProperty)BlockMiniBoiler.facing);
    }

    public int getCapacity() {
        return ConfigManager.miniBoilerCapacity;
    }

    public int getFluidAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int getGasAmount() {
        return this.gasTank.getFluidAmount();
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidTank getGasTank() {
        return this.gasTank;
    }

    public Fluid getFluid() {
        if (this.fluidTank.getFluid() != null) {
            return this.fluidTank.getFluid().getFluid();
        }
        return null;
    }

    public Fluid getGas() {
        if (this.gasTank.getFluid() != null) {
            return this.gasTank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.fluidTank.getFluid();
    }

    public FluidStack getGasStack() {
        return this.gasTank.getFluid();
    }

    public void boil(double heat) {
        FluidStack fluid = this.getFluidStack();
        ILiquidFuel fuelHandler = EmbersAPI.getBoilerFluid(fluid);
        if (fuelHandler != null && fluid.amount > 0 && heat > 0.0) {
            FluidStack gas;
            int fluidBoiled = MathHelper.func_76125_a((int)((int)((double)ConfigManager.miniBoilerHeatMultiplier * heat)), (int)1, (int)fluid.amount);
            if (fluidBoiled > 0 && (gas = fuelHandler.getRemainder(fluid = this.fluidTank.drain(fluidBoiled, false))) != null) {
                this.fluidTank.drain(fluidBoiled, true);
                gas.amount -= this.gasTank.fill(gas, true);
                if (ConfigManager.miniBoilerCanExplode && gas.amount > 0 && !this.field_145850_b.field_72995_K) {
                    this.explode();
                }
            }
            this.lastBoil = fluidBoiled;
            this.boilTime = fluidBoiled / 200;
            this.func_70296_d();
        }
    }

    public void explode() {
        double posX = (double)this.field_174879_c.func_177958_n() + 0.5;
        double posY = (double)this.field_174879_c.func_177956_o() + 0.5;
        double posZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.MINI_BOILER_RUPTURE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        Explosion explosion = this.field_145850_b.func_72885_a(null, posX, posY, posZ, 3.0f, true, false);
        this.field_145850_b.func_175698_g(this.field_174879_c);
        EffectDamage effect = new EffectDamage(4.0f, preset -> DamageSource.func_94539_a((Explosion)explosion), 10, 0.0);
        for (int i = 0; i < 12; ++i) {
            EntityEmberProjectile proj = new EntityEmberProjectile(this.field_145850_b);
            proj.initCustom(posX, posY, posZ, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, 10.0, null);
            proj.setLifetime(20 + this.random.nextInt(40));
            proj.setEffect(effect);
            this.field_145850_b.func_72838_d((Entity)proj);
        }
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType) && facing.func_176740_k() != EnumFacing.Axis.Y) {
            String gasFormat = "";
            if ((double)this.getGasAmount() > (double)this.getCapacity() * 0.8) {
                gasFormat = TextFormatting.RED.toString() + " ";
            } else if ((double)this.getGasAmount() > (double)this.getCapacity() * 0.5) {
                gasFormat = TextFormatting.YELLOW.toString() + " ";
            }
            information.add(gasFormat + BlockFluidGauge.formatFluidStack(this.getGasStack(), this.getCapacity()));
            information.add(BlockFluidGauge.formatFluidStack(this.getFluidStack(), this.getCapacity()));
        }
    }

    @Override
    public int getComparatorData(EnumFacing facing, int data, String dialType) {
        if ("fluid".equals(dialType) && facing.func_176740_k() != EnumFacing.Axis.Y) {
            double fill = (double)this.getGasAmount() / (double)this.getCapacity();
            return fill > 0.0 ? (int)(1.0 + fill * 14.0) : 0;
        }
        return data;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.handleSound();
            this.spawnParticles();
        }
        if (this.boilTime > 0) {
            --this.boilTime;
        }
    }

    public void spawnParticles() {
        double gasRatio = (double)this.getGasAmount() / (double)this.getCapacity();
        int spouts = 0;
        if (gasRatio > 0.8) {
            spouts = 3;
        } else if (gasRatio > 0.5) {
            spouts = 2;
        } else if (gasRatio > 0.25) {
            spouts = 1;
        }
        Misc.spawnClogParticles(this.field_145850_b, this.field_174879_c, spouts, 0.4f);
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.field_174879_c.func_177958_n() + 0.5f;
        float soundY = (float)this.field_174879_c.func_177956_o() + 0.5f;
        float soundZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.MINI_BOILER_LOOP_SLOW, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.MINI_BOILER_LOOP_MID, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 3: {
                Embers.proxy.playMachineSound(this, 3, SoundManager.MINI_BOILER_LOOP_FAST, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 4: {
                Embers.proxy.playMachineSound(this, 4, SoundManager.MINI_BOILER_PRESSURE_LOW, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 5: {
                Embers.proxy.playMachineSound(this, 5, SoundManager.MINI_BOILER_PRESSURE_MID, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 6: {
                Embers.proxy.playMachineSound(this, 6, SoundManager.MINI_BOILER_PRESSURE_HIGH, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        int speedId = 0;
        int pressureId = 0;
        int gasAmount = this.getGasAmount();
        double gasRatio = (double)gasAmount / (double)this.getCapacity();
        if (gasRatio > 0.8) {
            pressureId = 6;
        } else if (gasRatio > 0.5) {
            pressureId = 5;
        } else if (gasRatio > 0.25) {
            pressureId = 4;
        }
        if (this.boilTime > 0 && this.lastBoil > 0) {
            speedId = this.lastBoil >= 2400 ? 3 : (this.lastBoil >= 400 ? 2 : 1);
        }
        return speedId == id || pressureId == id;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (facing == EnumFacing.DOWN || facing != null && facing.func_176740_k() != EnumFacing.Axis.Y && facing != this.getFacing()) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.water", (Object[])new Object[0])));
        }
        if (facing == EnumFacing.UP) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.steam", (Object[])new Object[0])));
        }
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (facing == this.getFacing()) {
            return EnumPipeConnection.NONE;
        }
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.PIPE;
    }
}

