/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.ConfigManager;
import teamroots.embers.block.BlockStoneEdge;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityOpenTank;
import teamroots.embers.util.FluidColorHelper;
import teamroots.embers.util.Misc;

public class TileEntityLargeTank
extends TileEntityOpenTank
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    int ticksExisted = 0;

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(4.0, 256.0, 4.0);
    }

    public TileEntityLargeTank() {
        this.tank = new FluidTank(Integer.MAX_VALUE){

            public void onContentsChanged() {
                TileEntityLargeTank.this.func_70296_d();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (Misc.isGaseousFluid(resource)) {
                    TileEntityLargeTank.this.setEscapedFluid(resource);
                    return resource.amount;
                }
                return super.fill(resource, doFill);
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean didFill;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side))))) {
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public void updateCapacity() {
        int capacity = 0;
        int i = 1;
        while (this.isReservoirPart(this.func_174877_v().func_177982_a(0, i, 0))) {
            capacity += ConfigManager.reservoirCapacity;
            ++i;
        }
        if (this.tank.getCapacity() != capacity) {
            this.tank.setCapacity(capacity);
            int amount = this.tank.getFluidAmount();
            if (amount > capacity) {
                this.tank.drain(amount - capacity, true);
            }
            this.func_70296_d();
        }
    }

    protected boolean isReservoirPart(BlockPos pos) {
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        return state.func_177230_c() instanceof BlockStoneEdge && (Integer)state.func_177229_b((IProperty)BlockStoneEdge.state) == 8;
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.ticksExisted % 20 == 0) {
            this.updateCapacity();
        }
        if (this.field_145850_b.field_72995_K && this.shouldEmitParticles()) {
            this.updateEscapeParticles();
        }
    }

    @Override
    protected void updateEscapeParticles() {
        Color fluidColor = new Color(FluidColorHelper.getColor(this.lastEscaped), true);
        Random random = new Random();
        int height = this.getCapacity() / ConfigManager.reservoirCapacity;
        for (int i = 0; i < 3; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f;
            float yOffset = (float)height + 0.9f;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f;
            ParticleUtil.spawnParticleVapor(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + xOffset, (float)this.field_174879_c.func_177956_o() + yOffset, (float)this.field_174879_c.func_177952_p() + zOffset, 0.0f, 0.05f, 0.0f, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 8.0f, 6.0f, 50);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }
}

