/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import teamroots.embers.Embers;
import teamroots.embers.api.filter.FilterExisting;
import teamroots.embers.api.filter.FilterItem;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.item.IFilterItem;
import teamroots.embers.api.tile.IOrderDestination;
import teamroots.embers.api.tile.IOrderSource;
import teamroots.embers.api.tile.ITargetable;
import teamroots.embers.block.BlockItemRequisition;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.ISpecialFilter;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityItemExtractor;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Misc;

public class TileEntityItemRequisition
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipePriority,
IItemPipeConnectable,
ITargetable,
IOrderSource,
ISpecialFilter {
    public static final int PRIORITY_REQUEST = -100;
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.field_82609_l.length];
    public IItemHandler itemHandler;
    public ItemStack filterItem = ItemStack.field_190927_a;
    public int filterSize = 0;
    IFilter filter = FilterUtil.FILTER_ANY;
    public int currentOrder;
    public BlockPos target = null;
    double angle = 0.0;
    double turnRate = 1.0;
    boolean lastPowered;

    public TileEntityItemRequisition() {
        this.itemHandler = new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!TileEntityItemRequisition.this.acceptsItem(stack)) {
                    return stack;
                }
                TileEntity attached = TileEntityItemRequisition.this.getAttached();
                if (attached != null && attached.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileEntityItemRequisition.this.getFacing().func_176734_d())) {
                    IItemHandler handler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileEntityItemRequisition.this.getFacing().func_176734_d());
                    if (TileEntityItemRequisition.this.isIntelligent()) {
                        ItemStack split = stack.func_77946_l();
                        for (int j = 0; j < handler.getSlots() && !split.func_190926_b(); ++j) {
                            split = handler.insertItem(j, split, simulate);
                        }
                        return split;
                    }
                    int count = TileEntityItemRequisition.this.countItems(handler);
                    int filterSize = TileEntityItemRequisition.this.getFilterSize() - count;
                    if (filterSize > 0) {
                        ItemStack whole = stack.func_77946_l();
                        ItemStack split = whole.func_77979_a(filterSize);
                        for (int j = 0; j < handler.getSlots() && !split.func_190926_b(); ++j) {
                            split = handler.insertItem(j, split, simulate);
                        }
                        ItemStack merged = this.merge(whole, split);
                        return merged;
                    }
                }
                return stack;
            }

            ItemStack merge(ItemStack first, ItemStack second) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)first, (ItemStack)second)) {
                    return first;
                }
                first = first.func_77946_l();
                first.func_190917_f(second.func_190916_E());
                return first;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    public void updateConnections() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setInternalConnection(facing, this.getConnection((IBlockAccess)this.field_145850_b, this.func_174877_v().func_177972_a(facing), facing));
        }
        this.func_70296_d();
    }

    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.func_176745_a()] != null ? this.connections[facing.func_176745_a()] : EnumPipeConnection.NONE;
    }

    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.func_176745_a()] = connection;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        return facing == this.getFacing() ? EnumPipeConnection.NONE : EnumPipeConnection.PIPE;
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (side == this.getFacing() || tile instanceof TileEntityItemRequisition) {
            return EnumPipeConnection.NONE;
        }
        if (tile instanceof IItemPipeConnectable) {
            return ((IItemPipeConnectable)tile).getConnection(side.func_176734_d());
        }
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
            return EnumPipeConnection.PIPE;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public boolean isIntelligent() {
        return this.filter instanceof FilterExisting;
    }

    private void setupFilter() {
        Item item = this.filterItem.func_77973_b();
        this.filter = item instanceof IFilterItem ? ((IFilterItem)item).getFilter(this.filterItem) : (!this.filterItem.func_190926_b() ? new FilterItem(this.filterItem) : FilterUtil.FILTER_ANY);
    }

    public int getFilterSize() {
        return this.filterSize;
    }

    public boolean acceptsItem(ItemStack stack) {
        IItemHandler itemHandler;
        TileEntity attached = this.getAttached();
        if (attached != null && (itemHandler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().func_176734_d())) != null) {
            return this.filter.acceptsItem(stack, itemHandler);
        }
        return false;
    }

    private EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockItemRequisition.facing);
    }

    public TileEntity getAttached() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
    }

    public TileEntityItemExtractor getSource() {
        if (this.target == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.target);
        if (tile instanceof TileEntityItemExtractor) {
            return (TileEntityItemExtractor)tile;
        }
        return null;
    }

    @Override
    public IItemHandler getItemHandler() {
        IItemHandler itemHandler;
        TileEntity attached = this.getAttached();
        if (attached != null && (itemHandler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().func_176734_d())) != null) {
            return itemHandler;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getFacing()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getFacing()) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean isPowered = false;
            isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
            int filterSize = this.getFilterSize();
            TileEntity attached = this.getAttached();
            int count = 0;
            if (attached != null && attached.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().func_176734_d())) {
                IItemHandler handler = (IItemHandler)attached.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing().func_176734_d());
                count = this.countItems(handler);
            }
            if (this.currentOrder < filterSize - count) {
                this.order(filterSize - count - this.currentOrder);
            } else if (this.currentOrder > filterSize - count) {
                this.currentOrder = Math.max(0, filterSize - count);
            }
            this.lastPowered = isPowered;
        } else {
            this.angle += this.turnRate;
        }
    }

    public int countItems(IItemHandler handler) {
        int count = 0;
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack countStack = handler.getStackInSlot(j);
            if (!this.acceptsItem(countStack)) continue;
            count += countStack.func_190916_E();
        }
        return count;
    }

    public void order(int orderSize) {
        TileEntityItemExtractor source = this.getSource();
        if (source != null) {
            source.order(this, this.filter, orderSize);
            this.currentOrder += orderSize;
        }
    }

    public void resetOrder() {
        TileEntityItemExtractor source = this.getSource();
        if (source != null) {
            source.resetOrder(this);
        }
        this.currentOrder = 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("order", this.currentOrder);
        if (!this.filterItem.func_190926_b()) {
            tag.func_74782_a("filter", (NBTBase)this.filterItem.func_77955_b(new NBTTagCompound()));
            tag.func_74768_a("filterSize", this.filterSize);
        } else {
            tag.func_74778_a("filter", "empty");
        }
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        tag.func_74768_a("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.func_74768_a("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.func_74768_a("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.func_74768_a("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.func_74768_a("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.func_74768_a("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
        tag.func_74757_a("lastPowered", this.lastPowered);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentOrder = tag.func_74762_e("order");
        if (tag.func_74764_b("filter")) {
            this.filterItem = new ItemStack(tag.func_74775_l("filter"));
            this.filterSize = tag.func_74762_e("filterSize");
        }
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        if (tag.func_74764_b("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.func_74762_e("up")));
        }
        if (tag.func_74764_b("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.func_74762_e("down")));
        }
        if (tag.func_74764_b("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.func_74762_e("north")));
        }
        if (tag.func_74764_b("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.func_74762_e("south")));
        }
        if (tag.func_74764_b("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.func_74762_e("west")));
        }
        if (tag.func_74764_b("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.func_74762_e("east")));
        }
        this.lastPowered = tag.func_74767_n("lastPowered");
        this.setupFilter();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            if (heldItem != ItemStack.field_190927_a) {
                if (!this.filterItem.func_77969_a(heldItem)) {
                    this.filterItem = heldItem.func_77946_l();
                    this.filterSize = this.filterItem.func_190916_E();
                } else {
                    this.filterSize += heldItem.func_190916_E();
                }
            } else {
                this.filterItem = ItemStack.field_190927_a;
                this.filterSize = 0;
            }
            this.setupFilter();
            this.resetOrder();
            this.func_70296_d();
            return true;
        }
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.resetOrder();
    }

    @Override
    public void setTarget(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof IOrderDestination) {
            this.resetOrder();
            this.target = pos;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public void addDescription(List<String> strings) {
        TileEntityItemExtractor source = this.getSource();
        if (source != null) {
            BlockPos pos = source.func_174877_v();
            IBlockState blockState = this.field_145850_b.func_180495_p(pos);
            strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.linked", blockState.func_177230_c().func_149732_F(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        }
        strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.filter", this.filter.formatFilter(), this.getFilterSize()));
        if (this.currentOrder > 0) {
            strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.order", this.currentOrder));
        } else {
            strings.add(Embers.proxy.formatLocalize("embers.tooltip.item_request.order.none", new Object[0]));
        }
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return -100;
    }

    @Override
    public IFilter getSpecialFilter() {
        return FilterUtil.FILTER_EXISTING;
    }
}

