/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IEmberPipeConnectable;
import teamroots.embers.tileentity.TileEntityEmberPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityEmberPipe
extends TileEntityEmberPipeBase {
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.field_82609_l.length];
    boolean syncConnections;
    boolean active;
    double currentPush;
    public static final double INIT_PUSH = 10.0;
    public static final double INCREMENT_PUSH = 10.0;

    public void updateNeighbors(IBlockAccess world) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setInternalConnection(facing, this.getConnection(world, this.func_174877_v().func_177972_a(facing), facing));
        }
        this.syncConnections = true;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.active = this.func_145831_w().func_175640_z(this.func_174877_v());
            this.currentPush = this.clogged || !this.active ? 10.0 : (this.currentPush += 10.0);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile;
                if (!this.isConnected(facing) || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing.func_176734_d())) continue;
                if (this.active) {
                    IEmberCapability handler = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing.func_176734_d());
                    if (handler.getEmber() > 0.0 && this.packet == 0.0) {
                        double removed;
                        this.packet = removed = handler.removeAmount(Math.min(this.currentPush, handler.getEmberCapacity() / 10.0), true);
                        this.syncPacket = true;
                    }
                    this.setFrom(facing, true);
                    continue;
                }
                this.setFrom(facing, false);
            }
        }
        super.func_73660_a();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeConnections(tag);
        return tag;
    }

    private void writeConnections(NBTTagCompound tag) {
        tag.func_74768_a("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.func_74768_a("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.func_74768_a("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.func_74768_a("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.func_74768_a("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.func_74768_a("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.func_74762_e("up")));
        }
        if (tag.func_74764_b("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.func_74762_e("down")));
        }
        if (tag.func_74764_b("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.func_74762_e("north")));
        }
        if (tag.func_74764_b("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.func_74762_e("south")));
        }
        if (tag.func_74764_b("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.func_74762_e("west")));
        }
        if (tag.func_74764_b("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.func_74762_e("east")));
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.syncConnections) {
            this.writeConnections(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncConnections || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncConnections = false;
    }

    @Override
    int getCapacity() {
        return 240;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing side) {
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NEIGHBORNONE;
        }
        return EnumPipeConnection.PIPE;
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.func_176745_a()] != null ? this.connections[facing.func_176745_a()] : EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.func_176745_a()] = connection;
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getInternalConnection(facing).canTransfer();
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IEmberCapability cap;
        TileEntity tile = world.func_175625_s(pos);
        IEmberCapability iEmberCapability = cap = tile != null ? (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, side.func_176734_d()) : null;
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof IEmberPipeConnectable) {
            return ((IEmberPipeConnectable)tile).getConnection(side.func_176734_d());
        }
        if (cap != null && cap.acceptsVolatile()) {
            return EnumPipeConnection.BLOCK;
        }
        if (Misc.isValidPipeConnector(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
        EnumPipeConnection connection = this.getInternalConnection(face);
        this.setInternalConnection(face, TileEntityEmberPipe.reverseForce(connection));
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (tile instanceof TileEntityEmberPipe) {
            ((TileEntityEmberPipe)tile).updateNeighbors((IBlockAccess)this.field_145850_b);
        }
        if (connection == EnumPipeConnection.FORCENONE) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.PIPE_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (connection != EnumPipeConnection.NONE && connection != EnumPipeConnection.LEVER) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.PIPE_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }
}

