/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import teamroots.embers.EventManager;
import teamroots.embers.api.tile.IBin;
import teamroots.embers.block.BlockBreaker;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityBreaker
extends TileEntity
implements ITileEntityBase,
ITickable {
    int ticksExisted = 0;
    Random random = new Random();
    WeakReference<FakePlayer> fakePlayer;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.initFakePlayer();
        }
    }

    protected void initFakePlayer() {
        FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(new UUID(13L, 13L), "embers_breaker"));
        player.field_71135_a = new NetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(EnumPacketDirection.SERVERBOUND), (EntityPlayerMP)player){

            public void func_147359_a(Packet packetIn) {
            }
        };
        this.fakePlayer = new WeakReference<FakePlayer>(player);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.ticksExisted % 20 == 0 && this.isActive() && state.func_177230_c() instanceof BlockBreaker && !this.field_145850_b.field_72995_K) {
            EnumFacing facing = this.getFacing();
            this.mineBlock(this.field_174879_c.func_177972_a(facing));
        }
    }

    public boolean isActive() {
        return !this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    protected void mineBlock(BlockPos breakPos) {
        FakePlayer player = (FakePlayer)this.fakePlayer.get();
        if (player == null) {
            return;
        }
        int exp = ForgeHooks.onBlockBreakEvent((World)this.field_145850_b, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)breakPos);
        if (exp != -1) {
            IBlockState state = this.field_145850_b.func_180495_p(breakPos);
            TileEntity tile = this.field_145850_b.func_175625_s(breakPos);
            Block block = state.func_177230_c();
            NonNullList<ItemStack> drops = null;
            if (state.func_185887_b(this.field_145850_b, this.field_174879_c) < 0.0f || this.isBlacklisted(block) && !player.func_189808_dh()) {
                this.field_145850_b.func_184138_a(breakPos, state, state, 3);
            } else {
                this.field_145850_b.func_180498_a((EntityPlayer)player, 2001, breakPos, Block.func_176210_f((IBlockState)state));
                if (player.func_184812_l_()) {
                    this.removeBlock(player, breakPos, false);
                } else {
                    boolean flag1 = this.removeBlock(player, breakPos, true);
                    if (flag1) {
                        EventManager.captureDrops(true);
                        state.func_177230_c().func_180657_a(this.field_145850_b, (EntityPlayer)player, breakPos, state, tile, ItemStack.field_190927_a);
                        drops = EventManager.captureDrops(false);
                    }
                }
            }
            if (drops != null) {
                this.collectDrops(drops);
            }
        }
    }

    private boolean isBlacklisted(Block block) {
        return block instanceof BlockCommandBlock || block instanceof BlockStructure;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return (EnumFacing)state.func_177229_b((IProperty)BlockBreaker.facing);
    }

    private void collectDrops(NonNullList<ItemStack> stacks) {
        EnumFacing facing = this.getFacing();
        BlockPos frontPos = this.func_174877_v().func_177972_a(facing);
        BlockPos binPos = this.func_174877_v().func_177972_a(facing.func_176734_d());
        TileEntity bin = this.func_145831_w().func_175625_s(binPos);
        boolean capture = bin instanceof IBin;
        for (ItemStack stack : stacks) {
            if (capture) {
                ItemStack remainder = ((IBin)bin).getInventory().insertItem(0, stack, false);
                if (!remainder.func_190926_b() && !this.func_145831_w().field_72995_K) {
                    EntityItem item = new EntityItem(this.func_145831_w(), (double)frontPos.func_177958_n() + 0.5, (double)((float)frontPos.func_177956_o() + 1.0625f), (double)frontPos.func_177952_p() + 0.5, remainder);
                    this.func_145831_w().func_72838_d((Entity)item);
                }
                bin.func_70296_d();
                this.func_70296_d();
                continue;
            }
            EntityItem item = new EntityItem(this.func_145831_w(), (double)frontPos.func_177958_n() + 0.5, (double)((float)frontPos.func_177956_o() + 1.0625f), (double)frontPos.func_177952_p() + 0.5, stack);
            this.func_145831_w().func_72838_d((Entity)item);
        }
    }

    private boolean removeBlock(FakePlayer player, BlockPos pos, boolean canHarvest) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        boolean flag = state.func_177230_c().removedByPlayer(state, this.field_145850_b, pos, (EntityPlayer)player, canHarvest);
        if (flag) {
            state.func_177230_c().func_176206_d(this.field_145850_b, pos, state);
        }
        return flag;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }
}

