/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.api.tile.ISparkable;
import teamroots.embers.api.tile.ITargetable;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockBeamCannon;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageBeamCannonFX;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityBeamCannon
extends TileEntity
implements ITileEntityBase,
ITickable,
ITargetable {
    public static final double PULL_RATE = 2000.0;
    public static final int FIRE_THRESHOLD = 400;
    public static final float DAMAGE = 25.0f;
    public static final int MAX_DISTANCE = 64;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    public BlockPos target = null;
    public BlockPos lastTarget = null;
    public long ticksExisted = 0L;
    public boolean lastPowered = false;
    public Random random = new Random();
    int offset = this.random.nextInt(40);
    private List<IUpgradeProvider> upgrades;

    public TileEntityBeamCannon() {
        this.onLoad();
        this.capability.setEmberCapacity(2000.0);
    }

    @Nonnull
    public EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockBeamCannon.facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        tag.func_74757_a("lastPowered", this.lastPowered);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        this.lastPowered = tag.func_74767_n("lastPowered");
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public void func_73660_a() {
        EnumFacing facing = this.getFacing();
        if (this.target == null && this.ticksExisted == 0L) {
            this.target = this.func_174877_v().func_177972_a(facing);
        }
        this.upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, new EnumFacing[]{facing.func_176734_d()});
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        ++this.ticksExisted;
        boolean cancel = UpgradeUtil.doWork(this, this.upgrades);
        boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
        boolean redstoneEnabled = UpgradeUtil.getOtherParameter((TileEntity)this, "redstone_enabled", true, this.upgrades);
        int threshold = UpgradeUtil.getOtherParameter((TileEntity)this, "fire_threshold", 400, this.upgrades);
        if (!cancel && this.capability.getEmber() >= (double)threshold && (!redstoneEnabled || isPowered && !this.lastPowered)) {
            this.fire();
        }
        this.lastPowered = isPowered;
    }

    private void pullEmber() {
        IEmberCapability cap;
        EnumFacing facing = this.getFacing();
        TileEntity attachedTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()));
        if (attachedTile != null && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)).getEmber() > 0.0 && this.capability.getEmber() < this.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(2000.0, true);
            this.capability.addAmount(removed, true);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTarget(BlockPos pos) {
        this.target = pos;
        this.func_70296_d();
    }

    public void fire() {
        Vec3d ray = new Vec3d((double)(this.target.func_177958_n() - this.func_174877_v().func_177958_n()), (double)(this.target.func_177956_o() - this.func_174877_v().func_177956_o()), (double)(this.target.func_177952_p() - this.func_174877_v().func_177952_p())).func_72432_b();
        double impactDist = Double.POSITIVE_INFINITY;
        double damage = UpgradeUtil.getOtherParameter((TileEntity)this, "damage", 25.0, this.upgrades);
        if (!this.func_145831_w().field_72995_K) {
            double posX = (double)this.func_174877_v().func_177958_n() + 0.5;
            double posY = (double)this.func_174877_v().func_177956_o() + 0.5;
            double posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
            double startX = posX;
            double startY = posY;
            double startZ = posZ;
            boolean doContinue = true;
            int maxDist = UpgradeUtil.getOtherParameter((TileEntity)this, "distance", 64, this.upgrades);
            for (int i = 0; i < maxDist * 10 && doContinue; ++i) {
                IBlockState state = this.func_145831_w().func_180495_p(new BlockPos(posX += ray.field_72450_a * 0.1, posY += ray.field_72448_b * 0.1, posZ += ray.field_72449_c * 0.1));
                TileEntity tile = this.func_145831_w().func_175625_s(new BlockPos(posX, posY, posZ));
                if (this.sparkTarget(tile)) {
                    doContinue = false;
                } else if (tile instanceof IEmberPacketReceiver) {
                    if (tile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
                        ((IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)).addAmount(this.capability.getEmber(), true);
                        tile.func_70296_d();
                    }
                    doContinue = false;
                } else if (state.func_185917_h() && state.func_185914_p()) {
                    doContinue = false;
                }
                List rawEntities = this.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posX - 0.85, posY - 0.85, posZ - 0.85, posX + 0.85, posY + 0.85, posZ + 0.85));
                for (EntityLivingBase rawEntity : rawEntities) {
                    rawEntity.func_70097_a(RegistryManager.damage_ember, (float)damage);
                }
                if (doContinue) continue;
                this.field_145850_b.func_184148_a(null, posX, posY, posZ, SoundManager.BEAM_CANNON_HIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                impactDist = i;
            }
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageBeamCannonFX(startX, startY, startZ, ray.field_72450_a, ray.field_72448_b, ray.field_72449_c, impactDist));
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, this.capability.getEmber()), this.upgrades);
            this.capability.setEmber(0.0);
            this.func_70296_d();
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundManager.BEAM_CANNON_FIRE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean sparkTarget(TileEntity target) {
        if (target instanceof ISparkable) {
            ((ISparkable)target).sparkProgress(this, this.capability.getEmber());
            return true;
        }
        return false;
    }
}

